/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Puttable;
import EDU.oswego.cs.dl.util.concurrent.Takable;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.StreamPipeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPipe {
    private boolean closed;
    private InputStream istream;
    private OutputStream ostream;
    private LinkedQueue queue = new LinkedQueue();

    public StreamPipe() {
        this.istream = new Consumer(this.queue);
        this.ostream = new Supplier(this.queue);
    }

    public InputStream getInputStream() {
        return this.istream;
    }

    public OutputStream getOutputStream() {
        return this.ostream;
    }

    protected void close() {
        this.closed = true;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    class Consumer
    extends InputStream {
        Buffer buffer = new Buffer();
        final Takable chan;

        Consumer(Takable channel) {
            this.chan = channel;
        }

        public int read() throws IOException {
            if (StreamPipe.this.isClosed()) {
                throw new StreamPipeIOException(CorePlugin.Util.getString("StreamPipe.The_input_stream_has_been_closed._2"));
            }
            int result = this.buffer.read();
            if (result == -1) {
                try {
                    this.buffer = (Buffer)this.chan.take();
                    if (this.buffer instanceof NoMoreBuffers) {
                        return -1;
                    }
                    result = this.buffer.read();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return result;
        }

        public void close() throws IOException {
            StreamPipe.this.close();
        }
    }

    class Supplier
    extends OutputStream {
        Buffer buffer = new Buffer();
        final Puttable chan;

        Supplier(Puttable channel) {
            this.chan = channel;
        }

        public void write(int b) throws IOException {
            if (StreamPipe.this.isClosed()) {
                throw new StreamPipeIOException(CorePlugin.Util.getString("StreamPipe.The_output_stream_has_been_closed._1"));
            }
            if (this.buffer.write(b)) {
                try {
                    this.buffer.getReadyToRead();
                    this.chan.put(this.buffer);
                    this.buffer = new Buffer();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }

        public void close() throws IOException {
            try {
                this.buffer.getReadyToRead();
                this.chan.put(this.buffer);
                this.chan.put(new NoMoreBuffers());
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void flush() throws IOException {
            try {
                this.buffer.getReadyToRead();
                this.chan.put(this.buffer);
                this.buffer = new Buffer();
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    static class NoMoreBuffers
    extends Buffer {
        NoMoreBuffers() {
        }
    }

    static class Buffer {
        private final int BUFFER_SIZE = 2048;
        private int[] buffer = new int[2048];
        private int i;
        private int max;

        Buffer() {
        }

        boolean write(int b) {
            this.buffer[this.i] = b;
            ++this.i;
            ++this.max;
            return this.i == 2048;
        }

        int read() {
            if (this.i == this.max) {
                return -1;
            }
            int result = this.buffer[this.i];
            ++this.i;
            return result;
        }

        void getReadyToRead() {
            this.max = this.i;
            this.i = 0;
        }
    }
}

