/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.keymanage;

import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.PasswordChangeUtility;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ZipFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;

public class FilePasswordConverter {
    private static final int FILE_TYPE_UNKNOWN = -1;
    public static final int FILE_TYPE_XML = 1;
    public static final int FILE_TYPE_PROPERTIES = 2;
    public static final int FILE_TYPE_VDB = 3;
    private static String DEFAULT_KEYSTORE_FILE;
    private static final char[] DEFAULT_KEYSTORE_PASSWORD;
    private static final String PASSWORD = "PASSWORD";
    private int fileType = -1;
    private String inputFile;
    private String outputFile;
    private String oldKeystoreFile;
    private char[] oldKeystorePassword;
    private boolean oldKeyIsEncoded;
    private String newKeystoreFile;
    private char[] newKeystorePassword;
    private PasswordChangeUtility passwordChangeUtility;
    protected List converted = new ArrayList();
    protected List failedDecrypt = new ArrayList();
    protected List failedEncrypt = new ArrayList();
    private Exception firstException = null;

    public FilePasswordConverter(String inputFile, String outputFile, int fileType, String oldKeystoreFile, char[] oldKeystorePassword, String newKeystoreFile, char[] newKeystorePassword) {
        this(inputFile, outputFile, fileType, oldKeystoreFile, oldKeystorePassword, false, newKeystoreFile, newKeystorePassword);
    }

    public FilePasswordConverter(String inputFile, String outputFile, int fileType, String oldKeystoreFile, char[] oldKeystorePassword, boolean oldKeyIsEncoded, String newKeystoreFile, char[] newKeystorePassword) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.fileType = fileType;
        this.oldKeystoreFile = oldKeystoreFile;
        this.oldKeystorePassword = oldKeystorePassword;
        this.oldKeyIsEncoded = oldKeyIsEncoded;
        this.newKeystoreFile = newKeystoreFile;
        this.newKeystorePassword = newKeystorePassword;
    }

    public void convert() throws Exception {
        char[] oldKeystorePasswordArgled = this.oldKeystorePassword;
        if (!this.oldKeyIsEncoded) {
            oldKeystorePasswordArgled = CryptoFactory.argle(this.oldKeystorePassword);
        }
        char[] newKeystorePasswordArgled = CryptoFactory.argle(this.newKeystorePassword);
        this.passwordChangeUtility = new PasswordChangeUtility(this.oldKeystoreFile, oldKeystorePasswordArgled, this.newKeystoreFile, newKeystorePasswordArgled);
        if (this.fileType == 1) {
            this.convertXML();
        } else if (this.fileType == 2) {
            this.convertProperties();
        } else if (this.fileType == 3) {
            this.convertVDB();
        } else {
            throw new UnsupportedOperationException("unsupported file type " + this.fileType);
        }
        this.printResults();
    }

    public void convertXML() throws Exception {
        XMLReaderWriterImpl xmlReaderWriter = new XMLReaderWriterImpl();
        FileInputStream fis = new FileInputStream(this.inputFile);
        Document document = xmlReaderWriter.readDocument((InputStream)fis);
        fis.close();
        Element root = document.getRootElement();
        List descendants = root.getChildren();
        this.convertElementsRecursive(descendants);
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        xmlReaderWriter.setUseNewLines(false);
        xmlReaderWriter.writeDocument(document, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    public void convertVDB() throws Exception {
        FileUtils.copy(this.inputFile, this.outputFile);
        ZipFile zipFile = new ZipFile(this.inputFile);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("ConfigurationInfo.def")) continue;
            XMLReaderWriterImpl xmlReaderWriter = new XMLReaderWriterImpl();
            InputStream is = zipFile.getInputStream(entry);
            Document document = xmlReaderWriter.readDocument(is);
            is.close();
            Element root = document.getRootElement();
            List descendants = root.getChildren();
            this.convertElementsRecursive(descendants);
            File tempFile = File.createTempFile("vdb-temp", ".tmp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            xmlReaderWriter.setUseNewLines(false);
            xmlReaderWriter.writeDocument(document, (OutputStream)fos);
            fos.flush();
            fos.close();
            ZipFileUtil.remove(this.outputFile, entry.getName(), false);
            ZipFileUtil.add(this.outputFile, entry.getName(), tempFile.getAbsolutePath());
            tempFile.delete();
        }
    }

    private void convertElementsRecursive(List elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Element element;
            block7: {
                element = (Element)iter.next();
                if (this.isEncrypted(element)) {
                    String value = element.getText();
                    String name = element.getAttributeValue("Name");
                    if (value != null && value.length() > 0) {
                        char[] decryptedValue;
                        try {
                            decryptedValue = this.passwordChangeUtility.oldDecrypt(value.toCharArray());
                        }
                        catch (Exception e) {
                            this.failedDecrypt.add(name);
                            if (this.firstException != null) continue;
                            this.firstException = e;
                            continue;
                        }
                        try {
                            char[] convertedValue = this.passwordChangeUtility.newEncrypt(decryptedValue);
                            element.setText(new String(convertedValue));
                            this.converted.add(name);
                        }
                        catch (Exception e) {
                            this.failedEncrypt.add(name);
                            if (this.firstException != null) break block7;
                            this.firstException = e;
                        }
                    }
                }
            }
            this.convertElementsRecursive(element.getChildren());
        }
    }

    private boolean isEncrypted(Element element) {
        String elementName = element.getName();
        String attributeValue = element.getAttributeValue("Name");
        if (elementName == null || attributeValue == null) {
            return false;
        }
        return elementName.equalsIgnoreCase("Property") && attributeValue.toUpperCase().endsWith(PASSWORD);
    }

    public void convertProperties() throws Exception {
        String header = PropertiesUtils.loadHeader(this.inputFile);
        Properties properties = PropertiesUtils.load(this.inputFile);
        Properties convertedProperties = PropertiesUtils.clone(properties);
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            char[] decryptedValue;
            String value;
            String name = (String)names.nextElement();
            if (!this.isEncrypted(name) || (value = properties.getProperty(name)) == null || value.length() <= 0) continue;
            try {
                decryptedValue = this.passwordChangeUtility.oldDecrypt(value.toCharArray());
            }
            catch (Exception e) {
                this.failedDecrypt.add(name);
                if (this.firstException != null) continue;
                this.firstException = e;
                continue;
            }
            try {
                char[] convertedValue = this.passwordChangeUtility.newEncrypt(decryptedValue);
                convertedProperties.setProperty(name, new String(convertedValue));
                this.converted.add(name);
            }
            catch (Exception e) {
                this.failedEncrypt.add(name);
                if (this.firstException != null) continue;
                this.firstException = e;
            }
        }
        PropertiesUtils.print(this.outputFile, convertedProperties, header);
    }

    private void printResults() throws Exception {
        System.out.println();
        if (this.converted.size() <= 0) {
            try {
                new File(this.outputFile).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.firstException == null) {
                throw new Exception("Did not find any properties to convert");
            }
            throw this.firstException;
        }
        System.out.println("CONVERTED properties:");
        this.prettyPrint(this.converted);
        if (this.failedDecrypt.size() > 0) {
            System.out.println();
            System.out.println("FAILED TO DECRYPT properties:");
            this.prettyPrint(this.failedDecrypt);
        }
        if (this.failedEncrypt.size() > 0) {
            System.out.println();
            System.out.println("FAILED TO RE-ENCRYPT properties:");
            this.prettyPrint(this.failedEncrypt);
        }
        if (this.firstException != null) {
            System.out.println();
            System.out.println("Reason for failure: ");
            this.firstException.printStackTrace();
        }
    }

    private void prettyPrint(List list) {
        if (list.size() == 0) {
            System.out.println("(NONE)");
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    private boolean isEncrypted(String propertyName) {
        return propertyName.toUpperCase().endsWith(PASSWORD);
    }

    public static void main(String[] args) {
        char[] newKeystorePassword;
        String newKeystoreFile;
        char[] oldKeystorePassword;
        String oldKeystoreFile;
        String XML = "-xml";
        String PROPERTIES = "-properties";
        String VDB2 = "-vdb";
        String OLD_DEFAULT = "-oldDefault";
        String NEW_DEFAULT = "-newDefault";
        int fileType = -1;
        boolean oldKeyIsEncoded = false;
        if (args.length < 6) {
            FilePasswordConverter.printUsage();
        }
        if (args[0].equalsIgnoreCase("-xml")) {
            fileType = 1;
        } else if (args[0].equalsIgnoreCase("-properties")) {
            fileType = 2;
        } else if (args[0].equalsIgnoreCase("-vdb")) {
            fileType = 3;
        }
        if (fileType == -1) {
            FilePasswordConverter.printUsage();
        }
        String inputFile = args[1];
        String outputFile = args[2];
        if (args[3].equalsIgnoreCase("-oldDefault")) {
            if (args.length != 6) {
                FilePasswordConverter.printUsage();
            }
            oldKeystoreFile = DEFAULT_KEYSTORE_FILE;
            oldKeystorePassword = DEFAULT_KEYSTORE_PASSWORD;
            newKeystoreFile = args[4];
            newKeystorePassword = args[5].toCharArray();
        } else if (args[3].equalsIgnoreCase("-newDefault")) {
            if (args.length != 7) {
                FilePasswordConverter.printUsage();
            }
            oldKeystoreFile = args[4];
            oldKeystorePassword = args[5].toCharArray();
            oldKeyIsEncoded = new Boolean(args[6]);
            newKeystoreFile = DEFAULT_KEYSTORE_FILE;
            newKeystorePassword = DEFAULT_KEYSTORE_PASSWORD;
        } else {
            if (args.length != 8) {
                FilePasswordConverter.printUsage();
            }
            oldKeystoreFile = args[3];
            oldKeystorePassword = args[4].toCharArray();
            oldKeyIsEncoded = new Boolean(args[5]);
            newKeystoreFile = args[6];
            newKeystorePassword = args[7].toCharArray();
        }
        try {
            System.out.println("\nConverting " + inputFile);
            FilePasswordConverter converter = new FilePasswordConverter(inputFile, outputFile, fileType, oldKeystoreFile, oldKeystorePassword, oldKeyIsEncoded, newKeystoreFile, newKeystorePassword);
            converter.convert();
            System.out.println("\nDone converting to " + outputFile);
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: convertpasswords [-xml|-properties|-vdb] <inputFile> <outputFile> <oldKeystoreFile> <oldKeystorePassword> <oldPasswordIsEncoded> <newKeystoreFile> <newKeystorePassword>");
        System.out.println();
        System.out.println("OR     convertpasswords [-xml|-properties|-vdb] <inputFile> <outputFile> -oldDefault <newKeystoreFile> <newKeystorePassword>");
        System.out.println();
        System.out.println("OR     convertpasswords [-xml|-properties|-vdb] <inputFile> <outputFile> -newDefault <oldKeystoreFile> <oldKeystorePassword> <oldPasswordIsEncoded>");
        System.out.println();
        System.exit(1);
    }

    static {
        DEFAULT_KEYSTORE_PASSWORD = "sputnik13".toCharArray();
        CryptoUtil.initJCEProvider();
        DEFAULT_KEYSTORE_FILE = System.getProperty("metamatrix.installationDir") + File.separator + "lib" + File.separator + "metamatrixpki.default.keystore";
    }
}

