/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.AbstractSetCriteria;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.sql.util.ValueIteratorSource;

public class DependentSetCriteria
extends AbstractSetCriteria {
    private ValueIteratorSource valueIteratorSource;
    private Expression valueExpression;

    public DependentSetCriteria() {
    }

    public DependentSetCriteria(Expression expr) {
        this.setExpression(expr);
    }

    public ValueIteratorSource getValueIteratorSource() {
        return this.valueIteratorSource;
    }

    public void setValueIteratorSource(ValueIteratorSource valueIteratorSource) {
        this.valueIteratorSource = valueIteratorSource;
    }

    public Expression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(Expression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public ValueIterator getValueIterator() {
        ValueIterator valueIterator = this.valueIteratorSource.getValueIterator(this.valueExpression);
        if (valueIterator == null) {
            throw new MetaMatrixRuntimeException("ERR.015.010.0012", QueryPlugin.Util.getString("ERR.015.010.0012"));
        }
        return valueIterator;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getExpression());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DependentSetCriteria sc = (DependentSetCriteria)obj;
        if (this.isNegated() ^ sc.isNegated()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getExpression(), sc.getExpression());
    }

    public Object clone() {
        Expression copy = null;
        if (this.getExpression() != null) {
            copy = (Expression)this.getExpression().clone();
        }
        DependentSetCriteria criteriaCopy = new DependentSetCriteria(copy);
        criteriaCopy.setNegated(this.isNegated());
        criteriaCopy.setValueIteratorSource(this.getValueIteratorSource());
        criteriaCopy.setValueExpression((Expression)this.getValueExpression().clone());
        return criteriaCopy;
    }

    public void setValueIterator(ValueIterator valueIterator) {
        throw new UnsupportedOperationException("DependentSetCriteria.setValueIterator() should never be called as the value iterator is produced dynamically.");
    }
}

