/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.FilteredResultsMetadata;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class StoredProcedureResultsImpl
extends ResultsImpl {
    private ResultsImpl actualResults;
    private int resultColumns;
    private int parameters;
    private java.sql.ResultSetMetaData resultsMetadata;
    private MMStatement statement;
    private ResultsMessage resultsMsg;
    private int highestRow = 0;
    static /* synthetic */ Class class$com$metamatrix$jdbc$StoredProcedureResultsImpl;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;
    static /* synthetic */ Class class$com$metamatrix$jdbc$ResultsImpl;
    static /* synthetic */ Class class$com$metamatrix$dqp$message$ResultsMessage;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;

    static StoredProcedureResultsImpl newInstance(MMConnection conn, ResultsImpl results, int totalColumns, int params, ResultsMessage resultsMsg, MMStatement statement) throws SQLException {
        if (AOP.useproxy()) {
            return (StoredProcedureResultsImpl)ProxyFactory.extend(class$com$metamatrix$jdbc$StoredProcedureResultsImpl == null ? (class$com$metamatrix$jdbc$StoredProcedureResultsImpl = StoredProcedureResultsImpl.class$("com.metamatrix.jdbc.StoredProcedureResultsImpl")) : class$com$metamatrix$jdbc$StoredProcedureResultsImpl, new Class[]{class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = StoredProcedureResultsImpl.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection, class$com$metamatrix$jdbc$ResultsImpl == null ? (class$com$metamatrix$jdbc$ResultsImpl = StoredProcedureResultsImpl.class$("com.metamatrix.jdbc.ResultsImpl")) : class$com$metamatrix$jdbc$ResultsImpl, Integer.TYPE, Integer.TYPE, class$com$metamatrix$dqp$message$ResultsMessage == null ? (class$com$metamatrix$dqp$message$ResultsMessage = StoredProcedureResultsImpl.class$("com.metamatrix.dqp.message.ResultsMessage")) : class$com$metamatrix$dqp$message$ResultsMessage, class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = StoredProcedureResultsImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement}, new Object[]{conn, results, new Integer(totalColumns), new Integer(params), resultsMsg, statement});
        }
        return new StoredProcedureResultsImpl(conn, results, totalColumns, params, resultsMsg, statement);
    }

    StoredProcedureResultsImpl(MMConnection conn, ResultsImpl results, int totalColumns, int params, ResultsMessage resultsMsg, MMStatement statement) throws SQLException {
        super(resultsMsg, statement);
        this.actualResults = results;
        this.resultColumns = totalColumns - params;
        this.parameters = params;
        this.statement = statement;
        this.resultsMsg = resultsMsg;
    }

    public void close() throws SQLException {
        this.actualResults.close();
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultsMetadata == null) {
            this.resultsMetadata = FilteredResultsMetadata.newInstance((ResultSetMetaData)this.actualResults.getMetaData(), this.resultColumns, this.getLogger());
        }
        return this.resultsMetadata;
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public int getFetchSize() throws SQLException {
        return this.actualResults.getFetchSize();
    }

    public MetaMatrixException getException() {
        return this.actualResults.getException();
    }

    public List getParameters() {
        return this.resultsMsg.getParameters();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.actualResults.getWarnings();
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 1;
    }

    public boolean isLast() throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        if (this.actualResults.finalRow > 0) {
            return this.currentRow == this.actualResults.finalRow - this.parameters;
        }
        return !this.hasNext();
    }

    public boolean hasNext() throws SQLException {
        int i;
        if (this.actualResults.finalRow > -1) {
            return this.actualResults.finalRow - this.parameters > this.currentRow;
        }
        if (this.highestRow - this.parameters > this.currentRow) {
            return true;
        }
        boolean hasNext = true;
        for (i = 0; i < this.parameters; ++i) {
            if (!this.actualResults.hasNext()) {
                hasNext = false;
                break;
            }
            this.actualResults.next();
            this.highestRow = Math.max(this.highestRow, this.currentRow + i);
        }
        if (hasNext) {
            hasNext = this.actualResults.hasNext();
        }
        while (i > 0) {
            this.actualResults.previous();
            --i;
        }
        return hasNext;
    }

    public boolean next() throws SQLException {
        if (!this.hasResults() || this.isAfterLast()) {
            return false;
        }
        boolean next = this.actualResults.next();
        ++this.currentRow;
        this.highestRow = Math.max(this.highestRow, this.currentRow);
        if (this.isAfterLast()) {
            return false;
        }
        return next;
    }

    public boolean previous() throws SQLException {
        if (!this.hasResults() || this.currentRow == 0) {
            return false;
        }
        boolean previous = this.actualResults.previous();
        if (this.currentRow > 0) {
            --this.currentRow;
        }
        return previous;
    }

    public int getRow() throws SQLException {
        if (this.isAfterLast()) {
            return 0;
        }
        return this.currentRow;
    }

    public Object getObject(int column) throws SQLException {
        if (this.isAfterLast()) {
            throw new MMSQLException(JDBCPlugin.Util.getString("StoredProcedureResultsImpl.ResultSet_cursor_is_after_the_last_row._1"));
        }
        if (column > this.resultColumns) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Invalid_col_index", column));
        }
        this.currentValue = this.actualResults.getObject(column);
        return this.currentValue;
    }

    public Object getObject(String column) throws SQLException {
        this.currentValue = this.actualResults.getObject(column);
        return this.currentValue;
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getClob(this.currentValue);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public List getCurrentRecord() throws SQLException {
        List wholeRecord = this.actualResults.getCurrentRecord();
        return wholeRecord.subList(0, this.resultColumns);
    }

    Object getOutputParamValue(int index) throws SQLException {
        if (index <= this.resultColumns || index > this.resultColumns + this.parameters) {
            throw new MMSQLException(JDBCPlugin.Util.getString("StoredProcedureResultsImpl.Invalid_parameter_index__{0}_2", index));
        }
        int originalRow = this.currentRow;
        int parameterRow = index - this.resultColumns - 1;
        this.afterLast();
        for (int i = 0; i < parameterRow; ++i) {
            this.actualResults.next();
        }
        Object value = this.actualResults.getObject(index);
        for (int i = 0; i < parameterRow; ++i) {
            this.actualResults.previous();
        }
        if (this.hasResults()) {
            this.absolute(originalRow);
        }
        return value;
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    protected boolean hasResults() throws SQLException {
        if (this.highestRow - this.parameters > 0) {
            return true;
        }
        return this.hasNext();
    }

    protected Map getUpdatedPlanDescription() {
        return this.actualResults.getUpdatedPlanDescription();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

