/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMConnectionWrapper;
import com.metamatrix.jdbc.MMDataSource;
import com.metamatrix.jdbc.MMXAResource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class MMXAConnection
implements XAConnection {
    private HashSet listeners;
    private XAResource resource;
    private Connection connection;
    private MMConnectionWrapper connectorWrapper;
    private String url;
    private String userName;
    private String password;
    private Properties info;
    private MMDataSource mmDataSource;
    private boolean isClosed;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMXAConnection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public static MMXAConnection newInstance(String url, Properties info) {
        if (AOP.useproxy()) {
            return (MMXAConnection)ProxyFactory.extend(class$com$metamatrix$jdbc$MMXAConnection == null ? (class$com$metamatrix$jdbc$MMXAConnection = MMXAConnection.class$("com.metamatrix.jdbc.MMXAConnection")) : class$com$metamatrix$jdbc$MMXAConnection, new Class[]{class$java$lang$String == null ? (class$java$lang$String = MMXAConnection.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = MMXAConnection.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{url, info});
        }
        return new MMXAConnection(url, info);
    }

    public static MMXAConnection newInstance(String url, String userName, String password) {
        if (AOP.useproxy()) {
            return (MMXAConnection)ProxyFactory.extend(class$com$metamatrix$jdbc$MMXAConnection == null ? (class$com$metamatrix$jdbc$MMXAConnection = MMXAConnection.class$("com.metamatrix.jdbc.MMXAConnection")) : class$com$metamatrix$jdbc$MMXAConnection, new Class[]{class$java$lang$String == null ? (class$java$lang$String = MMXAConnection.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MMXAConnection.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MMXAConnection.class$("java.lang.String")) : class$java$lang$String}, new Object[]{url, userName, password});
        }
        return new MMXAConnection(url, userName, password);
    }

    public MMXAConnection(String url, Properties info) {
        this.url = url;
        this.info = info;
    }

    public MMXAConnection(String url, String userName, String password) {
        this.url = url;
        this.userName = userName;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCPlugin.Util.getString("MMXAConnection.connection_is_closed"));
        }
        if (this.connectorWrapper == null || this.connection.isClosed()) {
            try {
                this.connection = this.info != null && !this.info.isEmpty() ? DriverManager.getConnection(this.url, this.info) : DriverManager.getConnection(this.url, this.userName, this.password);
                ((MMConnection)this.connection).createServerInstance();
                this.connectorWrapper = MMConnectionWrapper.newInstance((MMConnection)this.connection, this);
            }
            catch (SQLException e) {
                this.notifyListener(e);
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return this.connectorWrapper;
    }

    public Logger getLogger() {
        if (this.connection == null) {
            return null;
        }
        return ((MMConnection)this.connection).getLogger();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.resource == null) {
            this.resource = MMXAResource.newInstance(this);
        }
        return this.resource;
    }

    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.isClosed = true;
    }

    protected synchronized void notifyListener(SQLException e) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)iter.next();
                if (e == null) {
                    listener.connectionClosed(new ConnectionEvent(this));
                    continue;
                }
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    protected MMDataSource getMmDataSource() {
        return this.mmDataSource;
    }

    protected void setMmDataSource(MMDataSource mmDataSource) {
        this.mmDataSource = mmDataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.metamatrix.jdbc.MMDriver");
        }
        catch (ClassNotFoundException e) {
            String msg = JDBCPlugin.Util.getString("MMDataSource.Cant_load_driver");
            System.err.println(msg);
        }
    }
}

