/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.properties;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.properties.MultiValuedProperty;
import java.io.Serializable;
import java.util.Iterator;

public abstract class AbstractMultiValuedProperty
implements Serializable,
MultiValuedProperty {
    public static final long serialVersionUID = 5647554337278616628L;
    private String name;

    public AbstractMultiValuedProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.021.0001"));
        }
        this.name = name;
    }

    protected AbstractMultiValuedProperty(MultiValuedProperty obj) {
        this.name = obj.getName();
    }

    public String getName() {
        return this.name;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(':');
        Iterator iter = this.getValues().iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
        }
        while (iter.hasNext()) {
            sb.append(',');
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(Object obj) {
        MultiValuedProperty that = (MultiValuedProperty)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.021.0002"));
        }
        int result = this.getName().compareTo(that.getName());
        if (result != 0) {
            return result;
        }
        Iterator thisIter = this.getValues().iterator();
        Iterator thatIter = that.getValues().iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            result = thisIter.next().toString().compareTo(thatIter.next());
            if (result == 0) continue;
            return result;
        }
        if (thisIter.hasNext() || thatIter.hasNext()) {
            result = thisIter.hasNext() ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiValuedProperty) {
            MultiValuedProperty that = (MultiValuedProperty)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            Iterator thisIter = this.getValues().iterator();
            Iterator thatIter = that.getValues().iterator();
            while (thisIter.hasNext() && thatIter.hasNext()) {
                if (thisIter.next().toString().equals(thatIter.next())) continue;
                return false;
            }
            return !thisIter.hasNext() && !thatIter.hasNext();
        }
        return false;
    }
}

