/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.log.DbLogListener;
import com.metamatrix.common.log.DbWriter;
import com.metamatrix.common.log.DbWriterException;
import com.metamatrix.common.log.LogMessage;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.impl.BaseResource;
import com.metamatrix.common.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.log.PlatformLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;

public class DbLogWriter
implements DbWriter {
    static final String LOGGING = "LOGGING";
    public static final String RESOURCE_POOL = "metamatrix.common.pooling.resource.name";
    static final String PROPERTY_PREFIX = "metamatrix.log.";
    public static final String DATABASE_PROPERTY_NAME = "metamatrix.log.jdbcDatabase";
    public static final String PROTOCOL_PROPERTY_NAME = "metamatrix.log.jdbcProtocol";
    public static final String DRIVER_PROPERTY_NAME = "metamatrix.log.jdbcDriver";
    public static final String PRINCIPAL_PROPERTY_NAME = "metamatrix.log.jdbcUsername";
    public static final String PASSWORD_PROPERTY_NAME = "metamatrix.log.jdbcPassword";
    public static final String TABLE_PROPERTY_NAME = "metamatrix.log.jdbcTable";
    public static final String MAX_MESSAGE_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxMsgLength";
    public static final String MAX_GENERAL_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxContextLength";
    public static final String MAX_EXCEPTION_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxExceptionLength";
    public static final String DEFAULT_TABLE_NAME = "LOGENTRIES";
    public static final int DEFAULT_MAX_GENERAL_LENGTH = 64;
    public static final int DEFAULT_MAX_EXCEPTION_LENGTH = 4000;
    public static final int DEFAULT_MAX_MSG_LENGTH = 2000;
    public static final String PLUGIN_PREFIX = "com.metamatrix.";
    private static final int WAIT_TIME = 60000;
    private static final int RETRY_TIME = 5000;
    private static final int WRITE_RETRIES = 5;
    private static final int RESUME_LOGGING_AFTER_TIME = 300000;
    private boolean isLogSuspended = false;
    private long resumeTime = -1L;
    private int consecutiveExceptions = 0;
    private short sequenceNumber;
    private long lastSequenceStart;
    private String poolName;
    private int maxMsgLength = 2000;
    private int maxGeneralLength = 64;
    private int maxExceptionLength = 4000;
    private Connection con;
    private Properties connProps;
    private PreparedStatement stmt;
    private StringBuffer insertStr;
    private boolean shutdown = false;
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String LEFT_PAREN = " (";
    private static final String COMMA = ",";
    private static final String VALUES = ") VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String NULL = "Null";

    public DbLogWriter(Properties properties) {
        this.connProps = properties;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.cleanup();
    }

    private void cleanup() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException ex) {
            System.err.println(CommonPlugin.Util.getString("ERR.003.014.0027") + ex.getMessage());
        }
        this.stmt = null;
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException ex) {
            System.err.println(CommonPlugin.Util.getString("ERR.003.014.0027") + ex.getMessage());
        }
        this.con = null;
    }

    private void startup() throws DbWriterException {
        this.con = this.getConnection();
    }

    public synchronized Connection getConnection() throws DbWriterException {
        SQLException firstException = null;
        Connection connection = null;
        long endTime = System.currentTimeMillis() + 60000L;
        while (true) {
            try {
                try {
                    connection = JDBCConnectionPoolHelper.getConnection((Properties)this.connProps, (String)LOGGING);
                }
                catch (ResourcePoolException err) {
                    throw new SQLException(err.getMessage());
                }
                connection.setAutoCommit(true);
                this.getStatement(connection);
                return connection;
            }
            catch (SQLException sqle) {
                this.cleanup();
                if (firstException == null) {
                    firstException = sqle;
                }
                if (System.currentTimeMillis() > endTime) {
                    System.err.println("LOG " + CommonPlugin.Util.getString("ERR.003.014.0028", firstException.getMessage()));
                    SQLException se = new SQLException(CommonPlugin.Util.getString("ERR.003.014.0028", firstException.getMessage()));
                    se.setNextException(firstException);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                }
                continue;
            }
            break;
        }
    }

    private void getStatement(Connection connection) throws SQLException {
        this.stmt = connection.prepareStatement(this.insertStr.toString());
    }

    public String getTableName(Properties props) {
        String tableName = props.getProperty(TABLE_PROPERTY_NAME, DEFAULT_TABLE_NAME);
        return tableName;
    }

    public void initialize() throws DbWriterException {
        int max;
        this.poolName = this.connProps.getProperty(RESOURCE_POOL);
        if (this.poolName == null) {
            throw new DbWriterException("ERR.003.001.0026", CommonPlugin.Util.getString("ERR.003.001.0026", LOGGING));
        }
        this.sequenceNumber = 0;
        this.lastSequenceStart = 0L;
        try {
            max = Integer.parseInt(this.connProps.getProperty(MAX_MESSAGE_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxMsgLength = max;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            max = Integer.parseInt(this.connProps.getProperty(MAX_GENERAL_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxGeneralLength = max;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int max2 = Integer.parseInt(this.connProps.getProperty(MAX_EXCEPTION_LENGTH_PROPERTY_NAME));
            if (max2 > 0) {
                this.maxExceptionLength = max2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertStr = new StringBuffer(INSERT_INTO);
        this.insertStr.append(this.getTableName(this.connProps));
        this.insertStr.append(LEFT_PAREN);
        this.insertStr.append("TIMESTAMP");
        this.insertStr.append(COMMA);
        this.insertStr.append("VMSEQNUM");
        this.insertStr.append(COMMA);
        this.insertStr.append("CONTEXT");
        this.insertStr.append(COMMA);
        this.insertStr.append("MSGLEVEL");
        this.insertStr.append(COMMA);
        this.insertStr.append("MESSAGE");
        this.insertStr.append(COMMA);
        this.insertStr.append("HOSTNAME");
        this.insertStr.append(COMMA);
        this.insertStr.append("VMID");
        this.insertStr.append(COMMA);
        this.insertStr.append("THREADNAME");
        this.insertStr.append(COMMA);
        this.insertStr.append("\"EXCEPTION\"");
        this.insertStr.append(VALUES);
        this.startup();
    }

    public void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        Object[] message = new Object[]{status.getMessage()};
        String context = status.getPlugin();
        if (context != null && context.startsWith(PLUGIN_PREFIX)) {
            context = context.substring(PLUGIN_PREFIX.length());
        }
        int level = 0;
        switch (status.getSeverity()) {
            case 0: {
                level = 5;
                break;
            }
            case 1: {
                level = 4;
                break;
            }
            case 2: {
                level = 3;
                break;
            }
            case 4: {
                level = 2;
                break;
            }
        }
        LogMessage logMessage = new LogMessage(context, level, status.getException(), message, threadName);
        this.write(logMessage);
    }

    private void write(LogMessage message) {
        int retrycnt = 0;
        if (this.isLogSuspended && System.currentTimeMillis() > this.resumeTime) {
            this.resumeLogging();
        }
        while (!this.isLogSuspended && !this.shutdown) {
            try {
                this.printMsg(message);
                return;
            }
            catch (SQLException ex) {}
            finally {
                if (retrycnt >= 5) {
                    this.suspendLogging();
                } else {
                    this.reconnect();
                }
                ++retrycnt;
            }
        }
    }

    private synchronized boolean reconnect() {
        if (!this.shutdown) {
            try {
                BaseResource rsrc;
                if (this.con instanceof BaseResource && (LOGGING.equals((rsrc = (BaseResource)this.con).getCheckedOutBy()) || rsrc.getCheckedOutBy() == null)) {
                    ResourceContainer container = rsrc.getContainer();
                    container.shutDown();
                }
                this.cleanup();
                this.con = this.getConnection();
                return true;
            }
            catch (Exception e) {
                System.err.println("LOG " + CommonPlugin.Util.getString("ERR.003.014.0028", e.getMessage()));
                this.suspendLogging();
            }
        }
        return false;
    }

    private void printMsg(LogMessage message) throws SQLException {
        if (this.shutdown) {
            return;
        }
        long msgTimeStamp = message.getTimestamp();
        if (this.lastSequenceStart != msgTimeStamp) {
            this.lastSequenceStart = msgTimeStamp;
            this.sequenceNumber = 0;
        }
        this.stmt.setString(1, DateUtil.getDateAsString(new Timestamp(msgTimeStamp)));
        this.stmt.setShort(2, this.sequenceNumber);
        this.stmt.setString(3, StringUtil.truncString(message.getContext(), this.maxGeneralLength));
        this.stmt.setInt(4, message.getLevel());
        this.stmt.setString(5, StringUtil.truncString(message.getText(), this.maxMsgLength));
        this.stmt.setString(6, StringUtil.truncString(message.getHostName(), this.maxGeneralLength));
        this.stmt.setString(7, StringUtil.truncString(message.getVMName(), this.maxGeneralLength));
        this.stmt.setString(8, StringUtil.truncString(message.getThreadName(), this.maxGeneralLength));
        if (message.getException() != null) {
            String eMsg = message.getException().getMessage();
            eMsg = eMsg == null ? NULL : StringUtil.truncString(eMsg, this.maxExceptionLength);
            this.stmt.setString(9, eMsg);
        } else {
            this.stmt.setString(9, NULL);
        }
        this.stmt.executeUpdate();
        if (this.consecutiveExceptions > 0) {
            this.consecutiveExceptions = 0;
        }
        this.sequenceNumber = (short)(this.sequenceNumber + 1);
    }

    private synchronized void suspendLogging() {
        this.isLogSuspended = true;
        this.resumeTime = System.currentTimeMillis() + 300000L;
        Date rd = new Date(this.resumeTime);
        String stringDate = DateUtil.getDateAsString(rd);
        System.err.println(CommonPlugin.Util.getString("DBLogWriter.Database_Logging_has_been_suspended", stringDate));
    }

    private synchronized void resumeLogging() {
        if (this.reconnect()) {
            this.isLogSuspended = false;
            this.resumeTime = -1L;
            Date rd = new Date(System.currentTimeMillis());
            String stringDate = DateUtil.getDateAsString(rd);
            System.err.println(CommonPlugin.Util.getString("DBLogWriter.Database_Logging_has_been_resumed", stringDate));
        }
    }

    public static void main(String[] args) {
        Properties env = new Properties();
        env.setProperty(RESOURCE_POOL, "JDBC Shared Connection Pool");
        env.setProperty(TABLE_PROPERTY_NAME, "LogEntries");
        env.setProperty(MAX_MESSAGE_LENGTH_PROPERTY_NAME, "102");
        env.setProperty(MAX_EXCEPTION_LENGTH_PROPERTY_NAME, "100");
        env.setProperty(MAX_GENERAL_LENGTH_PROPERTY_NAME, "30");
        DbLogListener dll = null;
        try {
            dll = new DbLogListener(env);
        }
        catch (DbWriterException e) {
            e.printStackTrace();
        }
        PlatformLog.getInstance().addListener(dll);
    }

    public static final class ColumnName {
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String SEQUENCE_NUMBER = "VMSEQNUM";
        public static final String CONTEXT = "CONTEXT";
        public static final String LEVEL = "MSGLEVEL";
        public static final String EXCEPTION = "EXCEPTION";
        public static final String MESSAGE = "MESSAGE";
        public static final String HOST = "HOSTNAME";
        public static final String VM = "VMID";
        public static final String THREAD = "THREADNAME";
    }
}

