/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.GetStateEvent;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.util.Util;

public class PullPushAdapter
implements Runnable,
ChannelListener {
    protected Transport transport = null;
    protected MessageListener listener = null;
    protected final List membership_listeners = new ArrayList();
    protected Thread receiver_thread = null;
    protected final HashMap listeners = new HashMap();
    protected final Log log = LogFactory.getLog(this.getClass());
    static final String PULL_HEADER = "PULL_HEADER";

    public PullPushAdapter(Transport transport) {
        this.transport = transport;
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l) {
        this.transport = transport;
        this.setListener(l);
        this.start();
    }

    public PullPushAdapter(Transport transport, MembershipListener ml) {
        this.transport = transport;
        this.addMembershipListener(ml);
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l, MembershipListener ml) {
        this.transport = transport;
        this.setListener(l);
        this.addMembershipListener(ml);
        this.start();
    }

    public Transport getTransport() {
        return this.transport;
    }

    public final void start() {
        if (this.receiver_thread == null || !this.receiver_thread.isAlive()) {
            this.receiver_thread = new Thread((Runnable)this, "PullPushAdapterThread");
            this.receiver_thread.setDaemon(true);
            this.receiver_thread.start();
        }
        if (this.transport instanceof JChannel) {
            ((JChannel)this.transport).addChannelListener(this);
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.receiver_thread != null && this.receiver_thread.isAlive()) {
            tmp = this.receiver_thread;
            this.receiver_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receiver_thread = null;
    }

    public void send(Serializable identifier, Message msg) throws Exception {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"msg is null");
            }
            return;
        }
        if (identifier == null) {
            this.transport.send(msg);
        } else {
            msg.putHeader(PULL_HEADER, new PullHeader(identifier));
            this.transport.send(msg);
        }
    }

    public void send(Message msg) throws Exception {
        this.send(null, msg);
    }

    public final void setListener(MessageListener l) {
        this.listener = l;
    }

    public void registerListener(Serializable identifier, MessageListener l) {
        if (l == null || identifier == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message listener or identifier is null");
            }
            return;
        }
        if (this.listeners.containsKey(identifier)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("listener with identifier=" + identifier + " already exists, choose a different identifier or unregister current listener"));
            }
            return;
        }
        this.listeners.put(identifier, l);
    }

    public void unregisterListener(Serializable identifier) {
        this.listeners.remove(identifier);
    }

    public void setMembershipListener(MembershipListener ml) {
        this.addMembershipListener(ml);
    }

    public final void addMembershipListener(MembershipListener l) {
        if (l != null && !this.membership_listeners.contains(l)) {
            this.membership_listeners.add(l);
        }
    }

    public void removeMembershipListener(MembershipListener l) {
        if (l != null && this.membership_listeners.contains(l)) {
            this.membership_listeners.remove(l);
        }
    }

    public void run() {
        while (this.receiver_thread != null && Thread.currentThread().equals(this.receiver_thread)) {
            Address local_addr;
            try {
                Object obj = this.transport.receive(0L);
                if (obj == null) continue;
                if (obj instanceof Message) {
                    this.handleMessage((Message)obj);
                    continue;
                }
                if (obj instanceof GetStateEvent) {
                    String state_id;
                    byte[] retval;
                    block21: {
                        retval = null;
                        GetStateEvent evt = (GetStateEvent)obj;
                        state_id = evt.getStateId();
                        if (this.listener != null) {
                            try {
                                if (this.listener instanceof ExtendedMessageListener) {
                                    retval = ((ExtendedMessageListener)this.listener).getState(state_id);
                                    break block21;
                                }
                                retval = this.listener.getState();
                            }
                            catch (Throwable t) {
                                this.log.error((Object)"getState() from application failed, will return empty state", t);
                            }
                        } else {
                            this.log.warn((Object)"no listener registered, returning empty state");
                        }
                    }
                    if (this.transport instanceof Channel) {
                        ((Channel)this.transport).returnState(retval, state_id);
                        continue;
                    }
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error((Object)("underlying transport is not a Channel, but a " + this.transport.getClass().getName() + ": cannot return state using returnState()"));
                    continue;
                }
                if (obj instanceof SetStateEvent) {
                    SetStateEvent evt = (SetStateEvent)obj;
                    String state_id = evt.getStateId();
                    if (this.listener == null) continue;
                    try {
                        if (this.listener instanceof ExtendedMessageListener) {
                            ((ExtendedMessageListener)this.listener).setState(evt.getStateId(), evt.getArg());
                            continue;
                        }
                        this.listener.setState(evt.getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) continue;
                        this.log.error((Object)("received SetStateEvent, but argument " + ((SetStateEvent)obj).getArg() + " is not serializable ! Discarding message."));
                    }
                    continue;
                }
                if (obj instanceof View) {
                    this.notifyViewChange((View)obj);
                    continue;
                }
                if (obj instanceof SuspectEvent) {
                    this.notifySuspect((Address)((SuspectEvent)obj).getMember());
                    continue;
                }
                if (!(obj instanceof BlockEvent)) continue;
                this.notifyBlock();
            }
            catch (ChannelNotConnectedException conn) {
                local_addr = ((Channel)this.transport).getLocalAddress();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)('[' + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel not connected, exception is " + conn));
                }
                Util.sleep(1000L);
                this.receiver_thread = null;
                break;
            }
            catch (ChannelClosedException closed_ex) {
                local_addr = ((Channel)this.transport).getLocalAddress();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)('[' + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel closed, exception is " + closed_ex));
                }
                this.receiver_thread = null;
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    protected void handleMessage(Message msg) {
        Serializable identifier;
        PullHeader hdr = (PullHeader)msg.getHeader(PULL_HEADER);
        if (hdr != null && (identifier = hdr.getIdentifier()) != null) {
            MessageListener l = (MessageListener)this.listeners.get(identifier);
            if (l == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("received a messages tagged with identifier=" + identifier + ", but there is no registration for that identifier. Will drop message"));
                }
            } else {
                l.receive(msg);
            }
        } else if (this.listener != null) {
            this.listener.receive(msg);
        }
    }

    protected void notifyViewChange(View v) {
        if (v == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.viewAccepted(v);
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception notifying " + l + ": " + ex));
            }
        }
    }

    protected void notifySuspect(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.suspect(suspected_mbr);
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception notifying " + l + ": " + ex));
            }
        }
    }

    protected void notifyBlock() {
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.block();
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception notifying " + l + ": " + ex));
            }
        }
    }

    public void channelConnected(Channel channel) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"channel is connected");
        }
    }

    public void channelDisconnected(Channel channel) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"channel is disconnected");
        }
    }

    public void channelClosed(Channel channel) {
    }

    public void channelShunned() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"channel is shunned");
        }
    }

    public void channelReconnected(Address addr) {
        this.start();
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public static final class PullHeader
    extends Header {
        Serializable identifier = null;

        public PullHeader() {
        }

        public PullHeader(Serializable identifier) {
            this.identifier = identifier;
        }

        public Serializable getIdentifier() {
            return this.identifier;
        }

        public long size() {
            if (this.identifier == null) {
                return 12L;
            }
            return 64L;
        }

        public String toString() {
            return "PullHeader";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.identifier);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.identifier = (Serializable)in.readObject();
        }
    }
}

