/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.util.Util;

public class Probe {
    MulticastSocket mcast_sock;

    public void start(InetAddress addr, InetAddress bind_addr, int port, int ttl, final long timeout, List query) throws Exception {
        this.mcast_sock = new MulticastSocket();
        this.mcast_sock.setTimeToLive(ttl);
        if (bind_addr != null) {
            this.mcast_sock.setInterface(bind_addr);
        }
        StringBuffer request = new StringBuffer("QUERY: ");
        for (int i = 0; i < query.size(); ++i) {
            request.append(query.get(i)).append(" ");
        }
        byte[] probe_buf = request.toString().getBytes();
        DatagramPacket probe = new DatagramPacket(probe_buf, 0, probe_buf.length, addr, port);
        this.mcast_sock.send(probe);
        System.out.println("\n-- send probe on " + addr + ':' + port + '\n');
        int i = 0;
        new Thread(){

            public void run() {
                Util.sleep(timeout);
                Probe.this.mcast_sock.close();
            }
        }.start();
        while (true) {
            byte[] buf = new byte[65000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                this.mcast_sock.receive(rsp);
            }
            catch (Throwable t) {
                System.out.println("\n");
                return;
            }
            byte[] data = rsp.getData();
            System.out.println("\n#" + ++i + " (" + rsp.getLength() + " bytes): " + new String(data, 0, rsp.getLength()));
        }
    }

    public static void main(String[] args) {
        InetAddress addr = null;
        InetAddress bind_addr = null;
        int port = 0;
        int ttl = 32;
        long timeout = 10000L;
        String DEFAULT_DIAG_ADDR = "224.0.0.75";
        int DEFAULT_DIAG_PORT = 7500;
        ArrayList<String> query = new ArrayList<String>();
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-addr".equals(args[i])) {
                    addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-bind_addr".equals(args[i])) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-ttl".equals(args[i])) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-timeout".equals(args[i])) {
                    timeout = Long.parseLong(args[++i]);
                    continue;
                }
                if ("-query".equals(args[i])) {
                    query.add(args[++i]);
                    continue;
                }
                Probe.help();
                return;
            }
            Probe p = new Probe();
            if (addr == null) {
                addr = InetAddress.getByName("224.0.0.75");
            }
            if (port == 0) {
                port = 7500;
            }
            p.start(addr, bind_addr, port, ttl, timeout, query);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Probe [-help] [-addr <addr>] [-bind_addr <addr>] [-port <port>] [-ttl <ttl>] [-timeout <timeout>] [-query <query>] (query can be jmx or props)");
    }
}

