/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.SetStateEvent;
import org.jgroups.View;
import org.jgroups.util.Util;

public class LargeState
extends ReceiverAdapter {
    Channel channel;
    byte[] state = null;
    Thread getter = null;
    boolean rc = false;
    String props;
    long start;
    long stop;
    boolean provider = true;

    public void start(boolean provider, int size, String props) throws Exception {
        this.provider = provider;
        this.channel = new JChannel(props);
        this.channel.setReceiver(this);
        this.channel.connect("TestChannel");
        System.out.println("-- connected to channel");
        if (provider) {
            System.out.println("Creating state of " + size + " bytes");
            this.state = this.createLargeState(size);
            System.out.println("Done. Waiting for other members to join and fetch large state");
        } else {
            System.out.println("Getting state");
            this.start = System.currentTimeMillis();
            this.rc = this.channel.getState(null, 0L);
            System.out.println("getState(), rc=" + this.rc);
        }
        if (provider) {
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.channel.close();
    }

    public void mainLoop() {
        try {
            while (true) {
                Object ret;
                if ((ret = this.channel.receive(0L)) instanceof Message) {
                    System.out.println("-- received msg " + ((Message)ret).getObject() + " from " + ((Message)ret).getSrc());
                    continue;
                }
                if (ret instanceof GetStateEvent) {
                    System.out.println("--> returning state: " + ret);
                    this.channel.returnState(this.state);
                    continue;
                }
                if (!(ret instanceof SetStateEvent)) continue;
                this.stop = System.currentTimeMillis();
                byte[] new_state = ((SetStateEvent)ret).getArg();
                if (new_state != null) {
                    this.state = new_state;
                    System.out.println("<-- Received state, size = " + this.state.length + " bytes (took " + (this.stop - this.start) + "ms)");
                }
                if (!this.provider) break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte[] createLargeState(int size) {
        return new byte[size];
    }

    public void receive(Message msg) {
        System.out.println("-- received msg " + msg.getObject() + " from " + msg.getSrc());
    }

    public void viewAccepted(View new_view) {
        if (this.provider) {
            System.out.println("-- view: " + new_view);
        }
    }

    public byte[] getState() {
        System.out.println("--> returning state: " + this.state.length + " bytes");
        return this.state;
    }

    public void setState(byte[] state) {
        this.stop = System.currentTimeMillis();
        if (state != null) {
            this.state = state;
            System.out.println("<-- Received state, size =" + state.length + " (took " + (this.stop - this.start) + "ms)");
        }
    }

    public static void main(String[] args) {
        boolean provider = false;
        int size = 0x100000;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                LargeState.help();
                return;
            }
            if ("-provider".equals(args[i])) {
                provider = true;
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-props".equals(args[i])) continue;
            props = args[++i];
        }
        try {
            new LargeState().start(provider, size, props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("LargeState [-help] [-size <size of state in bytes] [-provider] [-props <properties>]");
    }
}

