/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.List;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class GossipRouter {
    public static final int GET = -10;
    public static final int REGISTER = -11;
    public static final int DUMP = -21;
    public static final int SHUTDOWN = -1;
    public static final int SHUTDOWN_OK = -2;
    public static final int PORT = 8980;
    public static final long EXPIRY_TIME = 30000L;
    public static final long GOSSIP_REQUEST_TIMEOUT = 1000L;
    public static final long ROUTING_CLIENT_REPLY_TIMEOUT = 120000L;
    private final int MARK_BUFFER_SIZE = 2048;
    private static final Object GOSSIP_REQUEST = new Object();
    private static final Object GOSSIP_FAILURE = new Object();
    private int port;
    private String bindAddressString;
    private long expiryTime;
    private long gossipRequestTimeout;
    private long routingClientReplyTimeout;
    private final Hashtable routingTable = new Hashtable();
    private final Map gossipTable = new HashMap();
    private ServerSocket srvSock = null;
    private InetAddress bindAddress = null;
    Timer timer = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    private static int threadCounter = 0;

    public GossipRouter() {
        this(8980);
    }

    public GossipRouter(int port) {
        this(port, null);
    }

    public GossipRouter(int port, String bindAddressString) {
        this(port, bindAddressString, 30000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime) {
        this(port, bindAddressString, expiryTime, 1000L, 120000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime, long gossipRequestTimeout, long routingClientReplyTimeout) {
        this.port = port;
        this.bindAddressString = bindAddressString;
        this.expiryTime = expiryTime;
        this.gossipRequestTimeout = gossipRequestTimeout;
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddressString = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddressString;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setGossipRequestTimeout(long gossipRequestTimeout) {
        this.gossipRequestTimeout = gossipRequestTimeout;
    }

    public long getGossipRequestTimeout() {
        return this.gossipRequestTimeout;
    }

    public void setRoutingClientReplyTimeout(long routingClientReplyTimeout) {
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public long getRoutingClientReplyTimeout() {
        return this.routingClientReplyTimeout;
    }

    public boolean isStarted() {
        return this.srvSock != null;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        if (this.srvSock != null) {
            throw new Exception("Router already started.");
        }
        if (this.bindAddressString != null) {
            this.bindAddress = InetAddress.getByName(this.bindAddressString);
            this.srvSock = new ServerSocket(this.port, 50, this.bindAddress);
        } else {
            this.srvSock = new ServerSocket(this.port, 50);
        }
        new Thread(new Runnable(){

            public void run() {
                GossipRouter.this.mainLoop();
                GossipRouter.this.cleanup();
            }
        }, "JGroups Router Main Thread").start();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                GossipRouter.this.sweep();
            }
        }, this.expiryTime, this.expiryTime);
    }

    public void stop() {
        block5: {
            if (this.srvSock == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"Router already stopped");
                }
                return;
            }
            this.timer.cancel();
            this.shutdown();
            try {
                this.srvSock.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)("Failed to close server socket: " + e));
            }
        }
        this.srvSock = null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Router stopped");
        }
    }

    public void destroy() {
    }

    public String dumpRoutingTable() {
        return this.dumpTable(this.routingTable);
    }

    public String dumpGossipTable() {
        return this.dumpTable(this.gossipTable);
    }

    public static String requestTypeToString(int type) {
        return type == -10 ? "GET" : (type == -11 ? "REGISTER" : (type == -21 ? "DUMP" : (type == -1 ? "SHUTDOWN" : "UNKNOWN REQUEST: " + type)));
    }

    private void mainLoop() {
        Socket sock = null;
        DataInputStream input = null;
        DataOutputStream output = null;
        IpAddress peer_addr = null;
        int type = -1;
        String gname = null;
        boolean up = true;
        if (this.bindAddress == null) {
            this.bindAddress = this.srvSock.getInetAddress();
        }
        Date d = new Date();
        System.out.println("GossipRouter started at " + d + "\nListening on port " + this.port + " bound on address " + this.bindAddress + '\n');
        d = null;
        block12: while (up) {
            try {
                sock = this.srvSock.accept();
                sock.setSoLinger(true, 500);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("router accepted connection from " + sock));
                }
                final BufferedInputStream bis = new BufferedInputStream(sock.getInputStream());
                final Promise waitArea = new Promise();
                final Socket s = sock;
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ObjectInputStream ois = null;
                        try {
                            bis.mark(2048);
                            ois = new ObjectInputStream(bis);
                            GossipData gossip_req = (GossipData)ois.readObject();
                            waitArea.setResult(GOSSIP_REQUEST);
                            GossipData gresp = GossipRouter.this.processGossip(gossip_req);
                            if (gresp != null) {
                                ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                                oos.writeObject(gresp);
                                oos.close();
                            }
                            bis.close();
                            s.close();
                        }
                        catch (Exception e) {
                            if (GossipRouter.this.log.isDebugEnabled()) {
                                GossipRouter.this.log.debug((Object)("gossip thread exception :" + e));
                            }
                            waitArea.setResult(GOSSIP_FAILURE);
                        }
                        finally {
                            try {
                                ois.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }, "Gossip Request Thread");
                t.start();
                Object waitResult = waitArea.getResult(this.gossipRequestTimeout);
                waitArea.reset();
                if (waitResult != null) continue;
                peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                output = new DataOutputStream(sock.getOutputStream());
                byte[] buf = Util.objectToByteBuffer(peer_addr);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
                waitResult = waitArea.getResult(this.routingClientReplyTimeout);
                if (waitResult == null) {
                    throw new Exception("Timeout waiting for router client answer");
                }
                if (waitResult == GOSSIP_REQUEST) {
                    output.close();
                    continue;
                }
                bis.reset();
                input = new DataInputStream(bis);
                type = input.readInt();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("request of type " + GossipRouter.requestTypeToString(type)));
                }
                gname = input.readUTF();
                switch (type) {
                    case -10: {
                        this.processGetRequest(sock, output, gname);
                        continue block12;
                    }
                    case -21: {
                        this.processDumpRequest(sock, output);
                        continue block12;
                    }
                    case -11: {
                        int len = input.readInt();
                        buf = new byte[len];
                        input.readFully(buf, 0, buf.length);
                        Address addr = (Address)Util.objectFromByteBuffer(buf);
                        SocketThread st = new SocketThread(sock, input, addr);
                        this.addEntry(gname, new AddressEntry(addr, sock, st, output));
                        st.start();
                        continue block12;
                    }
                    case -1: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"router shutting down");
                        }
                        output.writeInt(-2);
                        output.flush();
                        try {
                            sock.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        up = false;
                        continue block12;
                    }
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("request of type " + type + " not recognized"));
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("failure handling a client connection: " + e.getMessage()), (Throwable)e);
                }
                try {
                    sock.close();
                }
                catch (IOException e2) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("failed to close socket " + sock));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Map map = this.routingTable;
        synchronized (map) {
            Iterator i = this.routingTable.keySet().iterator();
            while (i.hasNext()) {
                String gname = (String)i.next();
                java.util.List l = (java.util.List)this.routingTable.get(gname);
                if (l == null) continue;
                Iterator j = l.iterator();
                while (j.hasNext()) {
                    AddressEntry e = (AddressEntry)j.next();
                    e.destroy();
                }
            }
            this.routingTable.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"routing table cleared");
            }
        }
        map = this.gossipTable;
        synchronized (map) {
            this.gossipTable.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"gossip table cleared");
            }
        }
    }

    private void shutdown() {
        block2: {
            try {
                Socket s = new Socket(this.srvSock.getInetAddress(), this.srvSock.getLocalPort());
                DataInputStream dis = new DataInputStream(s.getInputStream());
                int len = dis.readInt();
                byte[] buf = new byte[len];
                dis.readFully(buf, 0, buf.length);
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeInt(-1);
                dos.writeUTF("");
                dis.readInt();
                dos.flush();
                dos.close();
                s.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error((Object)("shutdown failed: " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GossipData processGossip(GossipData gossip) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("gossip is " + gossip));
        }
        if (gossip == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"null gossip request");
            }
            return null;
        }
        String group = gossip.getGroup();
        Address mbr = null;
        Map map = this.gossipTable;
        synchronized (map) {
            switch (gossip.getType()) {
                case 1: {
                    mbr = gossip.getMbr();
                    if (group == null || mbr == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"group or member is null, cannot register member");
                        }
                        return null;
                    }
                    this.addGossipEntry(group, new AddressEntry(mbr));
                    return null;
                }
                case 2: {
                    if (group == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"group is null, cannot get membership");
                        }
                        return null;
                    }
                    Vector<Address> mbrs = null;
                    java.util.List l = (java.util.List)this.gossipTable.get(group);
                    if (l != null) {
                        mbrs = new Vector<Address>();
                        Iterator i = l.iterator();
                        while (i.hasNext()) {
                            AddressEntry e = (AddressEntry)i.next();
                            mbrs.add(e.addr);
                        }
                    }
                    return new GossipData(3, group, null, mbrs);
                }
                case 3: {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"received a GET_RSP. Should not be received by server");
                    }
                    return null;
                }
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("received unkown gossip request (gossip=" + gossip + ')'));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGossipEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"groupname was null, not added !");
            }
            return;
        }
        Map map = this.gossipTable;
        synchronized (map) {
            int index;
            java.util.List<AddressEntry> val = (java.util.List<AddressEntry>)this.gossipTable.get(groupname);
            if (val == null) {
                val = Collections.synchronizedList(new ArrayList());
                this.gossipTable.put(groupname, val);
            }
            if ((index = val.indexOf(e)) == -1) {
                val.add(e);
                return;
            }
            ((AddressEntry)val.get(index)).update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        long currentTime = System.currentTimeMillis();
        int num_entries_removed = 0;
        String key = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"running sweep");
        }
        Map map = this.gossipTable;
        synchronized (map) {
            Iterator i = this.gossipTable.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                java.util.List val = (java.util.List)this.gossipTable.get(key);
                if (val != null) {
                    Iterator j = val.iterator();
                    while (j.hasNext()) {
                        AddressEntry ae = (AddressEntry)j.next();
                        long diff = currentTime - ae.timestamp;
                        if (diff <= this.expiryTime) continue;
                        j.remove();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Removed member " + ae + " from group " + key + '(' + diff + " msecs old)"));
                        }
                        ++num_entries_removed;
                    }
                }
                if (val.size() != 0) continue;
                i.remove();
            }
        }
        if (num_entries_removed > 0 && this.log.isTraceEnabled()) {
            this.log.trace((Object)("done (removed " + num_entries_removed + " entries)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetRequest(Socket sock, DataOutputStream output, String groupname) {
        java.util.List grpmbrs = (java.util.List)this.routingTable.get(groupname);
        List ret = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("groupname=" + groupname + ", result=" + grpmbrs));
        }
        if (grpmbrs != null && grpmbrs.size() > 0) {
            ret = new List();
            Iterator i = grpmbrs.iterator();
            while (i.hasNext()) {
                AddressEntry entry = (AddressEntry)i.next();
                ret.add(entry.addr);
            }
        }
        try {
            if (ret == null || ret.size() == 0) {
                output.writeInt(0);
            } else {
                byte[] buf = Util.objectToByteBuffer(ret);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                sock.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDumpRequest(Socket sock, DataOutputStream output) {
        try {
            output.writeUTF(this.dumpRoutingTable());
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("error sending the answer back to the client: " + e));
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block20;
                        this.log.error((Object)("error closing the output stream: " + e));
                    }
                }
                try {
                    sock.close();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block21;
                    this.log.error((Object)("error closing the socket: " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpTable(Map map) {
        String label = map instanceof Hashtable ? "routing" : "gossip";
        StringBuffer sb = new StringBuffer();
        Map map2 = map;
        synchronized (map2) {
            if (map.size() == 0) {
                sb.append("empty ");
                sb.append(label);
                sb.append(" table");
            } else {
                Iterator i = map.keySet().iterator();
                while (i.hasNext()) {
                    String gname = (String)i.next();
                    sb.append("GROUP: '" + gname + "'\n");
                    java.util.List l = (java.util.List)map.get(gname);
                    if (l == null) {
                        sb.append("\tnull list of addresses\n");
                        continue;
                    }
                    if (l.size() == 0) {
                        sb.append("\tempty list of addresses\n");
                        continue;
                    }
                    Iterator j = l.iterator();
                    while (j.hasNext()) {
                        AddressEntry ae = (AddressEntry)j.next();
                        sb.append('\t');
                        sb.append(ae.toString());
                        sb.append('\n');
                    }
                }
            }
        }
        return sb.toString();
    }

    private void route(Address dest, String dest_group, byte[] msg, Address sender) {
        if (this.log.isTraceEnabled()) {
            int len = msg != null ? msg.length : 0;
            this.log.trace((Object)("routing request from " + sender + " for " + dest_group + " to " + (dest == null ? "ALL" : dest.toString()) + ", " + len + " bytes"));
        }
        if (dest == null) {
            if (dest_group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"both dest address and group are null");
                }
                return;
            }
            this.sendToAllMembersInGroup(dest_group, msg, sender);
        } else {
            AddressEntry ae = this.findAddressEntry(dest);
            if (ae == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("cannot find " + dest + " in the routing table"));
                }
                return;
            }
            if (ae.output == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)(dest + " is associated with a null output stream"));
                }
                return;
            }
            try {
                this.sendToMember(dest, ae.output, msg);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("failed sending message to " + dest + ": " + e.getMessage()));
                }
                this.removeEntry(ae.sock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"groupname was null, not added !");
            }
            return;
        }
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            int index;
            java.util.List<AddressEntry> val = (java.util.List<AddressEntry>)this.routingTable.get(groupname);
            if (val == null) {
                val = Collections.synchronizedList(new ArrayList());
                this.routingTable.put(groupname, val);
            }
            if ((index = val.indexOf(e)) == -1) {
                val.add(e);
                return;
            }
            ((AddressEntry)val.remove(index)).destroy();
            val.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(Socket sock) {
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            Enumeration e = this.routingTable.keys();
            while (e.hasMoreElements()) {
                java.util.List val = (java.util.List)this.routingTable.get(e.nextElement());
                Iterator i = val.iterator();
                while (i.hasNext()) {
                    AddressEntry entry = (AddressEntry)i.next();
                    if (entry.sock != sock) continue;
                    entry.destroy();
                    i.remove();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressEntry findAddressEntry(Address addr) {
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            Enumeration e = this.routingTable.keys();
            while (e.hasMoreElements()) {
                java.util.List val = (java.util.List)this.routingTable.get(e.nextElement());
                Iterator i = val.iterator();
                while (i.hasNext()) {
                    AddressEntry entry = (AddressEntry)i.next();
                    if (!addr.equals(entry.addr)) continue;
                    return entry;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAllMembersInGroup(String groupname, byte[] msg, Address sender) {
        java.util.List val = (java.util.List)this.routingTable.get(groupname);
        if (val == null || val.size() == 0) {
            return;
        }
        java.util.List list = val;
        synchronized (list) {
            Iterator i = val.iterator();
            while (i.hasNext()) {
                DataOutputStream dos;
                AddressEntry ae = (AddressEntry)i.next();
                if (ae.addr != null && ae.addr.equals(sender) || (dos = ae.output) == null) continue;
                try {
                    this.sendToMember(null, dos, msg);
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("cannot send to " + ae.addr + ": " + e.getMessage()));
                    }
                    ae.destroy();
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToMember(Address dest, DataOutputStream out, byte[] msg) throws IOException {
        if (out == null) {
            return;
        }
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            Util.writeAddress(dest, out);
            out.writeInt(msg.length);
            out.write(msg, 0, msg.length);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8080;
        long expiry = 30000L;
        long timeout = 1000L;
        long routingTimeout = 120000L;
        GossipRouter router = null;
        String address = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg)) {
                address = args[++i];
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-timeout".equals(arg)) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-rtimeout".equals(arg)) {
                routingTimeout = Long.parseLong(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        System.out.println("GossipRouter is starting...");
        try {
            router = new GossipRouter(port, address, expiry, timeout, routingTimeout);
            router.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bindaddress <address>] [options]");
        System.out.println("Options: ");
        System.out.println("        -expiry <msecs>   - Time until a gossip cache entry expires.");
        System.out.println("        -timeout <msecs>  - Number of millisecs the router waits to receive");
        System.out.println("                            a gossip request after connection was established;");
        System.out.println("                            upon expiration, the router initiates the routing");
        System.out.println("                            protocol on the connection.");
    }

    class SocketThread
    extends Thread {
        private volatile boolean active;
        Socket sock;
        DataInputStream input;
        Address addr;

        public SocketThread(Socket sock, DataInputStream ois, Address addr) {
            super(Util.getGlobalThreadGroup(), "SocketThread " + threadCounter++);
            this.active = true;
            this.sock = null;
            this.input = null;
            this.addr = null;
            this.sock = sock;
            this.input = ois;
            this.addr = addr;
        }

        void closeSocket() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void finish() {
            if (GossipRouter.this.log.isTraceEnabled()) {
                GossipRouter.this.log.trace((Object)("terminating the SocketThread for " + this.sock));
            }
            this.active = false;
        }

        public void run() {
            Address dst_addr = null;
            while (this.active) {
                try {
                    int len;
                    String gname = this.input.readUTF();
                    dst_addr = Util.readAddress(this.input);
                    if (GossipRouter.this.log.isTraceEnabled()) {
                        GossipRouter.this.log.trace((Object)("group " + gname + ", routing request to " + (dst_addr == null ? "all" : dst_addr.toString())));
                    }
                    if ((len = this.input.readInt()) == 0) {
                        if (!GossipRouter.this.log.isWarnEnabled()) continue;
                        GossipRouter.this.log.warn((Object)"received null message");
                        continue;
                    }
                    byte[] buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                    GossipRouter.this.route(dst_addr, gname, buf, this.addr);
                }
                catch (EOFException io_ex) {
                    if (GossipRouter.this.log.isTraceEnabled()) {
                        GossipRouter.this.log.trace((Object)("client " + this.sock.getInetAddress().getHostName() + ':' + this.sock.getPort() + " closed connection; removing it from routing table"));
                    }
                    GossipRouter.this.removeEntry(this.sock);
                    return;
                }
                catch (Exception e) {
                    if (!GossipRouter.this.log.isErrorEnabled()) break;
                    GossipRouter.this.log.error((Object)("exception=" + e));
                    break;
                }
            }
            this.closeSocket();
        }
    }

    class AddressEntry {
        Address addr = null;
        Socket sock = null;
        DataOutputStream output = null;
        long timestamp = 0L;
        final SocketThread thread;

        public AddressEntry(Address addr) {
            this(addr, null, null, null);
        }

        public AddressEntry(Address addr, Socket sock, SocketThread thread, DataOutputStream output) {
            this.addr = addr;
            this.sock = sock;
            this.thread = thread;
            this.output = output;
            this.timestamp = System.currentTimeMillis();
        }

        void destroy() {
            if (this.thread != null) {
                this.thread.finish();
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.output = null;
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
            this.timestamp = 0L;
        }

        public void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            return this.addr.equals(((AddressEntry)other).addr);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("addr=");
            sb.append(this.addr);
            if (this.sock == null) {
                sb.append(", timestamp=");
                sb.append(this.timestamp);
            } else {
                sb.append(", sock=");
                sb.append(this.sock);
            }
            return sb.toString();
        }
    }
}

