/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.stack.Protocol;

public class FLUSH
extends Protocol {
    public static final String NAME = "FLUSH";
    private View currentView;
    private Address localAddress;
    private Address flushCaller;
    private Collection flushMembers;
    private Set flushOkSet;
    private Set flushCompletedSet;
    private final Object sharedLock = new Object();
    private final Object blockMutex = new Object();
    private volatile boolean isBlockState = false;
    private long timeout = 4000L;

    public FLUSH() {
        this.currentView = new View(null, new Vector());
        this.flushOkSet = new TreeSet();
        this.flushCompletedSet = new TreeSet();
        this.flushMembers = new ArrayList();
    }

    public String getName() {
        return NAME;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if (props.size() > 0) {
            this.log.error((Object)("FLUSH.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Object object = this.blockMutex;
                synchronized (object) {
                    while (this.isFlushRunning()) {
                        this.log.debug((Object)("FLUSH block at  " + this.localAddress + " for " + this.timeout));
                        try {
                            this.blockMutex.wait(this.timeout);
                            if (!this.isFlushRunning()) continue;
                            this.log.warn((Object)("Forcing FLUSH unblock at " + this.localAddress));
                            this.passDown(new Event(69));
                            this.isBlockState = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        Message msg = null;
        switch (evt.getType()) {
            case 1: {
                msg = (Message)evt.getArg();
                FlushHeader fh = (FlushHeader)msg.removeHeader(this.getName());
                if (fh == null) break;
                if (fh.type == 0) {
                    this.passUp(new Event(10));
                    this.onFlushStart(msg.getSrc(), fh);
                } else if (fh.type == 2) {
                    this.onStopFlush();
                } else if (this.isCurrentFlushMessage(fh)) {
                    if (fh.type == 1) {
                        this.updateOnFlushOk(msg.getSrc(), fh.viewID);
                    } else if (fh.type == 3) {
                        this.onFlushCompleted(msg.getSrc());
                    }
                } else {
                    this.log.debug((Object)(this.localAddress + " received outdated FLUSH message " + fh + ",ignoring it."));
                }
                return;
            }
            case 6: {
                this.onViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
                break;
            }
            case 9: {
                this.onSuspect((Address)evt.getArg());
                break;
            }
            case 68: {
                this.onSuspend((View)evt.getArg());
                return;
            }
            case 70: {
                this.onResume();
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentFlushMessage(FlushHeader fh) {
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId viewId = this.currentView.getVid();
            return this.flushMembers != null && viewId != null && viewId.getId() <= fh.viewID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onViewChange(View view) {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = view;
            if (this.flushCaller != null && !view.getMembers().contains(this.flushCaller) && this.localAddress.equals(view.getMembers().get(0))) {
                this.log.debug((Object)("Coordinator left, " + this.localAddress + " will complete flush"));
                this.onResume();
            }
        }
        this.log.debug((Object)("Installing view at  " + this.localAddress + " view is " + this.currentView));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopFlush() {
        this.log.debug((Object)("Received STOP_FLUSH at " + this.localAddress));
        Object object = this.blockMutex;
        synchronized (object) {
            this.isBlockState = false;
            this.blockMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(View view) {
        Message msg = null;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushMembers = new ArrayList(view.getMembers());
            this.flushMembers.retainAll(this.currentView.getMembers());
            msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.getName(), new FlushHeader(0, this.currentView.getVid().getId(), this.flushMembers));
        }
        this.passDown(new Event(1, msg));
        this.log.debug((Object)("Received SUSPEND at " + this.localAddress + ", sent START_FLUSH to " + this.flushMembers));
    }

    private void onResume() {
        Message msg = new Message(null, this.localAddress, null);
        msg.putHeader(this.getName(), new FlushHeader(2));
        this.passDown(new Event(1, msg));
        this.log.debug((Object)("Received RESUME at " + this.localAddress + ", sent STOP_FLUSH to all"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushStart(Address flushStarter, FlushHeader fh) {
        Object object = this.blockMutex;
        synchronized (object) {
            this.isBlockState = true;
        }
        object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedSet.clear();
            this.flushOkSet.clear();
            this.flushCaller = flushStarter;
            this.flushMembers = fh.flushParticipants;
        }
        Message msg = new Message(null, this.localAddress, null);
        msg.putHeader(this.getName(), new FlushHeader(1, fh.viewID));
        this.passDown(new Event(1, msg));
        this.log.debug((Object)("Received START_FLUSH at " + this.localAddress + " responded with FLUSH_OK"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnFlushOk(Address address, long viewID) {
        boolean flushOkCompleted = false;
        Message m = null;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushOkSet.add(address);
            flushOkCompleted = this.flushOkSet.containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCaller, this.localAddress, null);
            }
        }
        this.log.debug((Object)("FLUSH_OK from " + address + ",completed " + flushOkCompleted + ",  flushOkSet " + this.flushOkSet.toString()));
        if (flushOkCompleted) {
            m.putHeader(this.getName(), new FlushHeader(3, viewID));
            this.passDown(new Event(1, m));
            this.log.debug((Object)(this.localAddress + " sent FLUSH_COMPLETED message to " + this.flushCaller));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address) {
        boolean flushCompleted = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedSet.add(address);
            flushCompleted = this.flushCompletedSet.containsAll(this.flushMembers);
        }
        this.log.debug((Object)("FLUSH_COMPLETED from " + address + ",completed " + flushCompleted + ",flushCompleted " + this.flushCompletedSet.toString()));
        if (flushCompleted) {
            this.passDown(new Event(69));
            this.log.debug((Object)("All FLUSH_COMPLETED received at " + this.localAddress + " sent SUSPEND_OK down"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Address address) {
        boolean restartFlush = false;
        long viewID = 0L;
        ArrayList membersToFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            viewID = this.currentView.getVid().getId();
            boolean bl = restartFlush = this.isFlushCaller(address) && this.amIFlushCallersNeighbor(address);
            if (restartFlush) {
                membersToFlush = new ArrayList(this.currentView.getMembers());
                membersToFlush.remove(address);
            }
        }
        if (restartFlush) {
            Message msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.getName(), new FlushHeader(0, viewID, membersToFlush));
            this.passDown(new Event(1, msg));
            this.log.debug((Object)("SUSPECT was FLUSH caller. " + this.localAddress + " is neighbor that restarted FLUSH "));
        }
    }

    private boolean isFlushCaller(Address address) {
        return address.equals(this.flushCaller);
    }

    private boolean amIFlushCallersNeighbor(Address address) {
        boolean amINeighbor = false;
        if (this.currentView.size() > 1) {
            Vector members = this.currentView.getMembers();
            int suspectsIndex = members.indexOf(address);
            boolean isLast = members.size() == suspectsIndex + 1;
            amINeighbor = isLast ? this.localAddress.equals(this.currentView.getCreator()) : this.localAddress.equals(members.get(suspectsIndex + 1));
        }
        return amINeighbor;
    }

    private boolean isFlushRunning() {
        return this.isBlockState;
    }

    public static class FlushHeader
    extends Header {
        public static final byte START_FLUSH = 0;
        public static final byte FLUSH_OK = 1;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        byte type;
        long viewID;
        Collection flushParticipants;

        public FlushHeader() {
            this(0);
        }

        public FlushHeader(byte type) {
            this(type, 0L);
        }

        public FlushHeader(byte type, long viewID) {
            this(type, viewID, null);
        }

        public FlushHeader(byte type, long viewID, Collection flushView) {
            this.type = type;
            this.viewID = viewID;
            this.flushParticipants = flushView;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID + ",members=" + this.flushParticipants + "]";
                }
                case 1: {
                    return "FLUSH[type=FLUSH_OK,viewId=" + this.viewID + "]";
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            out.writeObject(this.flushParticipants);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = (Collection)in.readObject();
        }
    }
}

