/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import org.jgroups.Channel;
import org.jgroups.JChannelFactory;
import org.jgroups.demos.Draw;

public class JChannelFactoryDemo {
    JChannelFactory factory;

    public static void main(String[] args) throws Exception {
        String props = "stacks.xml";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-props")) {
                System.out.println("JChannelFactoryDemo [-help] [-props <stack config file>");
                return;
            }
            props = args[++i];
        }
        new JChannelFactoryDemo().start(props);
    }

    private void start(String props) throws Exception {
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(props);
        final Channel ch1 = this.factory.createMultiplexerChannel("fc-fast-minimalthreads", "id-1");
        ch1.connect("bela");
        final Channel ch2 = this.factory.createMultiplexerChannel("fc-fast-minimalthreads", "id-2");
        ch2.connect("ban");
        Thread t1 = new Thread(){

            public void run() {
                try {
                    Draw draw1 = new Draw(ch1);
                    draw1.go();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                try {
                    Draw draw2 = new Draw(ch2);
                    draw2.go();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }
}

