/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.osgi.service.datalocation.Location;

public class LocationManager {
    private static Location installLocation = null;
    private static Location configurationLocation = null;
    private static Location userLocation = null;
    private static Location instanceLocation = null;
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    public static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String BUNDLES_DIR = "bundles";
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    public static final String BUNDLE_DATA_FILE = ".bundledata";
    public static final String MANIFESTS_DIR = "manifests";
    public static final String CONFIG_FILE = "config.ini";
    public static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CONFIG_DIR = "configuration";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";

    public static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return LocationManager.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            if (isFile) {
                return null;
            }
            try {
                return LocationManager.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? file + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    private static void mungeConfigurationLocation() {
        String location = System.getProperty(PROP_CONFIG_AREA);
        if (location != null) {
            if ((location = LocationManager.buildURL(location, false).toExternalForm()).endsWith(".cfg")) {
                int index = location.lastIndexOf(47);
                location = location.substring(0, index + 1);
            }
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            System.getProperties().put(PROP_CONFIG_AREA, location);
        }
    }

    public static void initializeLocations() {
        URL defaultLocation;
        installLocation = LocationManager.buildLocation(PROP_INSTALL_AREA, null, null, true);
        Location temp = LocationManager.buildLocation(PROP_USER_AREA_DEFAULT, null, "", false);
        URL uRL = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(new File(System.getProperty(PROP_USER_HOME), "user").getAbsolutePath(), true);
        }
        userLocation = LocationManager.buildLocation(PROP_USER_AREA, defaultLocation, "", false);
        temp = LocationManager.buildLocation(PROP_INSTANCE_AREA_DEFAULT, null, "", false);
        URL uRL2 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(new File(System.getProperty(PROP_USER_DIR), "workspace").getAbsolutePath(), true);
        }
        instanceLocation = LocationManager.buildLocation(PROP_INSTANCE_AREA, defaultLocation, "", false);
        LocationManager.mungeConfigurationLocation();
        temp = LocationManager.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "", false);
        URL uRL3 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(LocationManager.computeDefaultConfigurationLocation(), true);
        }
        configurationLocation = LocationManager.buildLocation(PROP_CONFIG_AREA, defaultLocation, "", false);
        URL parentLocation = LocationManager.computeSharedConfigurationLocation();
        if (parentLocation != null && !parentLocation.equals(configurationLocation.getURL())) {
            BasicLocation parent = new BasicLocation(null, parentLocation, true);
            ((BasicLocation)configurationLocation).setParent(parent);
        }
        LocationManager.initializeDerivedConfigurationLocations();
    }

    private static Location buildLocation(String property, URL defaultLocation, String userDefaultAppendage, boolean readOnlyDefault) {
        String base;
        boolean readOnly;
        String location = (String)System.getProperties().remove(property);
        String userReadOnlySetting = System.getProperty(property + READ_ONLY_AREA_SUFFIX);
        boolean bl = readOnly = userReadOnlySetting == null ? readOnlyDefault : Boolean.valueOf(userReadOnlySetting);
        if (location == null) {
            return new BasicLocation(property, defaultLocation, readOnly);
        }
        String trimmedLocation = location.trim();
        if (trimmedLocation.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (trimmedLocation.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(property, null, readOnly);
        }
        if (trimmedLocation.startsWith(USER_HOME)) {
            base = LocationManager.substituteVar(location, USER_HOME, PROP_USER_HOME);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        } else if (trimmedLocation.startsWith(USER_DIR)) {
            base = LocationManager.substituteVar(location, USER_DIR, PROP_USER_DIR);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        }
        URL url = LocationManager.buildURL(location, true);
        BasicLocation result = null;
        if (url != null) {
            result = new BasicLocation(property, null, readOnly);
            result.setURL(url, false);
        }
        return result;
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return value + source.substring(var.length());
    }

    private static void initializeDerivedConfigurationLocations() {
        if (System.getProperty(PROP_MANIFEST_CACHE) == null) {
            System.getProperties().put(PROP_MANIFEST_CACHE, LocationManager.getConfigurationFile(MANIFESTS_DIR).getAbsolutePath());
        }
    }

    private static URL computeInstallConfigurationLocation() {
        String property = System.getProperty(PROP_INSTALL_AREA);
        if (property != null) {
            try {
                return new URL(property);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL computeSharedConfigurationLocation() {
        String property = System.getProperty(PROP_SHARED_CONFIG_AREA);
        if (property == null) {
            return null;
        }
        try {
            URL sharedConfigurationURL = new URL(property);
            if (sharedConfigurationURL.getPath().startsWith("/")) {
                return sharedConfigurationURL;
            }
            URL installURL = installLocation.getURL();
            if (!sharedConfigurationURL.getProtocol().equals(installURL.getProtocol())) {
                return sharedConfigurationURL;
            }
            sharedConfigurationURL = new URL(installURL, sharedConfigurationURL.getPath());
            System.getProperties().put(PROP_SHARED_CONFIG_AREA, sharedConfigurationURL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static String computeDefaultConfigurationLocation() {
        URL installURL = LocationManager.computeInstallConfigurationLocation();
        if (installURL != null) {
            File installDir = new File(installURL.getFile());
            if ("file".equals(installURL.getProtocol()) && LocationManager.canWrite(installDir)) {
                return new File(installDir, CONFIG_DIR).getAbsolutePath();
            }
        }
        return LocationManager.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            fileTest = File.createTempFile("writtableArea", null, installDir);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private static String computeDefaultUserAreaLocation(String pathAppendage) {
        String installProperty = System.getProperty(PROP_INSTALL_AREA);
        URL installURL = LocationManager.buildURL(installProperty, true);
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = appName + File.separator + appId + "_" + appVersion;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, appName + "/" + pathAppendage).getAbsolutePath();
    }

    public static Location getUserLocation() {
        return userLocation;
    }

    public static Location getConfigurationLocation() {
        return configurationLocation;
    }

    public static Location getInstallLocation() {
        return installLocation;
    }

    public static Location getInstanceLocation() {
        return instanceLocation;
    }

    public static File getOSGiConfigurationDir() {
        return new File(configurationLocation.getURL().getFile(), "org.eclipse.osgi");
    }

    public static File getConfigurationFile(String filename) {
        File dir = LocationManager.getOSGiConfigurationDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, filename);
    }
}

