/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidMetaMatrixPrincipalException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.FindResourcesResult;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.SessionServiceProxy;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public interface ISessionServiceProxy {
    public String getServiceType();

    public MetaMatrixSessionInfo createSession(String var1, Credentials var2, Serializable var3, String var4, String var5, String[] var6) throws MetaMatrixAuthenticationException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public void closeSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public boolean terminateSession(MetaMatrixSessionID var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public boolean terminateSessions(Collection var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public boolean removeSessions(Collection var1, MetaMatrixSessionID var2) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public boolean isSessionValid(MetaMatrixSessionID var1) throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public MetaMatrixSessionInfo getSessionInfo(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public Collection getActiveSessions() throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public Collection getAllSessions() throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public int getActiveSessionsCount() throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public int getAllSessionsCount() throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public int getActiveConnectionsCountForProduct(String var1) throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public int getAllConnectionsCountForProduct(String var1) throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public Collection getActiveSessionsForUser(String var1) throws InvalidMetaMatrixPrincipalException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public List getSessionsForUser(String var1) throws InvalidMetaMatrixPrincipalException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public Set getLoggedOnPrincipals() throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public MetaMatrixPrincipal getPrincipal(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public SessionToken validateSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public void updateSession(MetaMatrixSessionID var1) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public void updateSession(MetaMatrixSessionID var1, int var2) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public void unbindProductFromSession(MetaMatrixSessionID var1, String var2) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public Collection getSessionsLoggedInToVDB(String var1, String var2) throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public void setIsSubscriber(MetaMatrixSessionID var1, boolean var2) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException;

    public void reinitializeSessionCleanup(Properties var1) throws SessionServiceException, ServiceException, ComponentNotFoundException;

    public void pingServer(MetaMatrixSessionID var1) throws ServiceStateException, ServiceException, ComponentNotFoundException;

    public FindResourcesResult findResources(FindResourcesRequest var1) throws ComponentNotFoundException;

    public Encryptor getEncryptor() throws CryptoException;

    public LogonResult logon(String var1, Credentials var2, Serializable var3, String var4, String var5, String[] var6, FindResourcesRequest var7) throws LogonException, ComponentNotFoundException;

    public void ping(MetaMatrixSessionID var1) throws InvalidSessionException, ComponentNotFoundException;

    public SessionToken validateSessionHighLevel(MetaMatrixSessionID var1) throws InvalidSessionException, ComponentNotFoundException;

    public void setClientEncryption(boolean var1);

    public void logoff(MetaMatrixSessionID var1) throws InvalidSessionException, ComponentNotFoundException, RemoteException;

    public SessionServiceProxy getSessionServiceProxy();

    public String getAppServerType();

    public MetaMatrixSessionID getSessionID();

    public boolean isOpen();

    public void connect();

    public boolean isConnected();
}

