/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.TrustedSessionToken;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class MetaMatrixSessionInfo
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -9120197553960136239L;
    private static final String STATE_ACTIVE = "ACTIVE";
    private static final String STATE_CLOSED = "CLOSED";
    private static final String STATE_EXPIRED = "EXPIRED";
    private static final String STATE_TERMINATED = "TERMINATED";
    private SessionToken sessionToken;
    private long lastPingTime;
    private long timeCreated;
    private long timeStateChanged;
    private String applicationName;
    private int state;
    private int clientCount;
    private Set products;
    private String[] productInfo;

    public MetaMatrixSessionInfo(MetaMatrixSessionID sessionID, String userName, long timeCreated, long timeStateChanged, String applicationName, boolean usesSubscription, int state, int clientCount, String clusterName, String[] productInfo, Set products) {
        this.timeCreated = timeCreated;
        this.lastPingTime = timeCreated;
        this.timeStateChanged = timeStateChanged;
        this.applicationName = applicationName;
        this.state = state;
        this.clientCount = clientCount;
        this.products = Collections.unmodifiableSet(products);
        this.sessionToken = new SessionToken(sessionID);
        this.productInfo = productInfo;
    }

    public MetaMatrixSessionInfo(MetaMatrixSessionInfo info, Serializable trustedToken) {
        this.timeCreated = info.timeCreated;
        this.lastPingTime = info.timeCreated;
        this.timeStateChanged = info.timeStateChanged;
        this.applicationName = info.applicationName;
        this.state = info.state;
        this.clientCount = info.clientCount;
        this.products = info.getProductNames();
        SessionToken token = info.sessionToken;
        this.sessionToken = new TrustedSessionToken(token, trustedToken);
    }

    public String getSessionStateLabel() {
        return MetaMatrixSessionInfo.getLabelForSessionState(this.state);
    }

    public static String getLabelForSessionState(int state) {
        String theState = "UNKNOWN";
        switch (state) {
            case 1: {
                theState = STATE_ACTIVE;
                break;
            }
            case 3: {
                theState = STATE_CLOSED;
                break;
            }
            case 4: {
                theState = STATE_EXPIRED;
                break;
            }
            case 5: {
                theState = STATE_TERMINATED;
            }
        }
        return theState;
    }

    public MetaMatrixSessionID getSessionID() {
        return this.sessionToken.getSessionID();
    }

    public String getUserName() {
        return this.sessionToken.getUsername();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeStateChanged() {
        return this.timeStateChanged;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public void setLastPingTime(long lastPingTime) {
        this.lastPingTime = lastPingTime;
    }

    public Set getProductNames() {
        return this.products;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public SessionToken getSessionToken() {
        return this.sessionToken;
    }

    public int getState() {
        return this.state;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MetaMatrixSessionInfo[ ");
        s.append(this.sessionToken.toString());
        s.append(", ");
        s.append("application:");
        s.append(this.applicationName);
        s.append(", state:");
        s.append(this.state);
        s.append(", created:");
        s.append(this.timeCreated);
        s.append(", state changed:");
        s.append(this.timeStateChanged);
        s.append(", last pinged server:");
        s.append(this.lastPingTime);
        s.append(", client count:");
        s.append(this.clientCount);
        s.append("]");
        return s.toString();
    }

    public String[] getProductInfo() {
        return this.productInfo;
    }
}

