/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.exception.security.MetaBaseResourceNotResolvedException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.MetaBaseResource;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;

public class MetaBasePermission
extends AuthorizationPermission
implements Cloneable {
    public static final String RECURSIVE = "*";
    public static final String SEPARATOR_WITH_RECURSIVE = "/*";

    MetaBasePermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String contentModifier, String factoryClassName) {
        super(resource, realm, actions, contentModifier, factoryClassName);
    }

    MetaBasePermission(AuthorizationResource resource, AuthorizationRealm realm, String factoryClassName) {
        super(resource, realm, factoryClassName);
    }

    MetaBasePermission(AuthorizationResource resource, AuthorizationRealm realm, AuthorizationActions actions, String factoryClassName) {
        super(resource, realm, actions, factoryClassName);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new MetaBasePermission(this.getResource(), this.getRealm(), this.getActions(), this.getContentModifier(), this.getFactoryClassName());
    }

    public boolean implies(AuthorizationPermission request) throws MetaBaseResourceNotResolvedException {
        if (!(request instanceof MetaBasePermission)) {
            return false;
        }
        if (((Object)this.getActions()).equals(StandardAuthorizationActions.NONE) || ((Object)request.getActions()).equals(StandardAuthorizationActions.NONE)) {
            return false;
        }
        if (!this.getRealm().equals(request.getRealm())) {
            return false;
        }
        if (!this.getActions().implies(request.getActions())) {
            return false;
        }
        MetaBasePermission that = (MetaBasePermission)request;
        MetaBaseResource thisResource = (MetaBaseResource)this.getResource();
        return thisResource.implies(that.getResource());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetaBasePermission) {
            return MetaBasePermission.compare(this, (MetaBasePermission)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0049"));
        }
        if (!(o instanceof MetaBasePermission)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0050", o.getClass()));
        }
        return MetaBasePermission.compare(this, (MetaBasePermission)o);
    }

    public static String removeRecursion(String resourceName) {
        return resourceName.substring(0, resourceName.indexOf(SEPARATOR_WITH_RECURSIVE));
    }

    public static boolean isRecursiveResource(String resourceName) {
        return resourceName.endsWith(SEPARATOR_WITH_RECURSIVE);
    }
}

