/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSPreLoginRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSSSLSocket;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUCS2;
import com.metamatrix.util.UtilTransliteratorPool;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.SQLException;

public final class TDSConnection {
    private static String footprint = "$Revision:   3.57.1.2  $";
    public Socket socket;
    public Socket sslSocket;
    public int serverEncryptMode;
    public SQLServerByteOrderedDataWriter writer;
    BaseExceptions exceptions;
    BaseWarnings warnings;
    byte[] sqlCollation;
    int tdsVersion;
    int databaseMajorVersion;
    public static final int SQL_SERVER_7 = 7;
    public static final int SQL_SERVER_2000 = 8;
    public static final int SQL_SERVER_2005 = 9;
    int databaseMinorVersion;
    public UtilTransliteratorForUCS2 unicodeTransliterator;
    public UtilTransliterator nonUnicodeTransliterator;
    public UtilTransliteratorPool transliteratorPool;
    private String catalog;
    private String username;
    public static final int TDS_UNDEFINED = 0;
    public static final int TDS_07000000 = 1;
    public static final int TDS_07010000 = 2;
    public static final int TDS_72090002 = 3;
    public SQLServerByteOrderedDataReader currentlyRegisteredReader;
    public TDSRequest currentlyRegisteredRequest;
    int replyBufferSize;
    public int maxMemoryPerLongDataCache;
    String codePageOverride;
    UtilSecurityContext securityContext;
    UtilVectorUnsynced readerBufferPool;
    public int packetSize;
    public boolean hasZeroPacketSize;
    public SQLServerConnection connection;
    private SQLServerImplStatement cancelPendingStatement;
    public boolean isTransactionImplicitOn;
    public long transactionDescriptor;

    public TDSConnection(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3, String string6, BaseConnectionProperties baseConnectionProperties, BaseWarnings baseWarnings, BaseExceptions baseExceptions, SQLServerConnection sQLServerConnection) throws SQLException {
        String string7;
        String string8;
        block21: {
            this.sslSocket = null;
            this.serverEncryptMode = 0;
            this.cancelPendingStatement = null;
            this.connection = sQLServerConnection;
            this.maxMemoryPerLongDataCache = n3;
            this.codePageOverride = string6;
            this.transliteratorPool = new UtilTransliteratorPool(10);
            this.unicodeTransliterator = null;
            this.nonUnicodeTransliterator = null;
            this.exceptions = baseExceptions;
            this.warnings = baseWarnings;
            string8 = string;
            string7 = string2;
            this.username = string3;
            this.replyBufferSize = n;
            this.isTransactionImplicitOn = false;
            this.transactionDescriptor = 0L;
            if (n2 == 0) {
                this.hasZeroPacketSize = true;
                this.packetSize = 4096;
            } else {
                this.hasZeroPacketSize = false;
                this.packetSize = n2;
            }
            this.tdsVersion = 0;
            try {
                Object object;
                int n4 = string8.indexOf(92);
                String string9 = null;
                if (n4 != -1) {
                    object = string8.substring(0, n4);
                    string9 = string8.substring(n4 + 1);
                    string7 = this.mapInstanceNameToPort((String)object, string9);
                    string8 = object;
                }
                this.socket = UtilSocketCreator.getSocket(string8, Integer.parseInt(string7), baseConnectionProperties.getProperties());
                this.socket.setReceiveBufferSize(65536);
                this.readerBufferPool = new UtilVectorUnsynced();
                this.unicodeTransliterator = (UtilTransliteratorForUCS2)this.getTransliteratorForCodePage("UCS2");
                this.unicodeTransliterator.setToLittleEndian();
                if (string5 != null && (string5.equalsIgnoreCase("requestSSL") || string5.equalsIgnoreCase("SSL") || string5.equalsIgnoreCase("LoginSSL"))) {
                    TDSPreLoginRequest tDSPreLoginRequest;
                    TDSSSLSocket tDSSSLSocket;
                    boolean bl;
                    block20: {
                        bl = (string5 = string5.toUpperCase()).equalsIgnoreCase("SSL") || string5.equalsIgnoreCase("LoginSSL");
                        byte by = 1;
                        if (string5.startsWith("LOGIN")) {
                            by = 0;
                        }
                        tDSSSLSocket = new TDSSSLSocket(this.socket);
                        InputStream inputStream = tDSSSLSocket.getInputStream();
                        OutputStream outputStream = tDSSSLSocket.getOutputStream();
                        this.writer = new SQLServerByteOrderedDataWriter(tDSSSLSocket, this.unicodeTransliterator, false, false);
                        tDSPreLoginRequest = new TDSPreLoginRequest(this, this.createReader(), this.writer, by, string9);
                        try {
                            tDSPreLoginRequest.submitRequest(null);
                        }
                        catch (SQLException sQLException) {
                            if (!bl) break block20;
                            throw this.exceptions.getException(7025, "08001");
                        }
                    }
                    this.serverEncryptMode = tDSPreLoginRequest.serverEncryptMode;
                    if (bl && this.serverEncryptMode == 2) {
                        throw this.exceptions.getException(7025, "08001");
                    }
                    if (this.serverEncryptMode == 2) {
                        this.socket = UtilSocketCreator.getSocket(string8, Integer.parseInt(string7), baseConnectionProperties.getProperties());
                        this.socket.setReceiveBufferSize(65536);
                        this.connection.implConnection.setConnectionStatus(2);
                    } else {
                        tDSSSLSocket.setWriteHeader(true);
                        tDSSSLSocket.setStripHeader(true);
                        String[] stringArray = null;
                        this.sslSocket = UtilSocketCreator.getSSLSocket(string8, Integer.parseInt(string7), tDSSSLSocket, false, stringArray, baseConnectionProperties.getProperties());
                        tDSSSLSocket.setWriteHeader(false);
                        tDSSSLSocket.setStripHeader(false);
                    }
                    break block21;
                }
                if (string5 != null && string5.length() > 0 && !string5.equalsIgnoreCase("noEncryption")) {
                    throw this.exceptions.getException(7024, "08001");
                }
                if (sQLServerConnection.implConnection.protocolVersion != 72) break block21;
                this.writer = new SQLServerByteOrderedDataWriter(this.socket, this.unicodeTransliterator, false, false);
                object = new TDSPreLoginRequest(this, this.createReader(), this.writer, 2, string9);
                try {
                    ((TDSPreLoginRequest)object).submitRequest(null);
                }
                catch (SQLException sQLException) {
                    this.socket = UtilSocketCreator.getSocket(string8, Integer.parseInt(string7), baseConnectionProperties.getProperties());
                    this.socket.setReceiveBufferSize(65536);
                    this.connection.implConnection.setConnectionStatus(2);
                }
                if (((TDSPreLoginRequest)object).serverEncryptMode == 3 && (string5 == null || string5.equalsIgnoreCase("noEncryption"))) {
                    throw this.exceptions.getException(7026, "08001");
                }
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                if (exception instanceof UtilException) {
                    throw this.exceptions.getException(exception, "08001");
                }
                String[] stringArray = new String[]{exception.toString()};
                throw this.exceptions.getException(6001, stringArray, "08001");
            }
        }
        try {
            String string10 = "MSSQLSvc/" + string8 + ":" + string7;
            this.securityContext = this.createSecurityContext(string4, string10);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
        this.writer = this.sslSocket == null ? new SQLServerByteOrderedDataWriter(this.socket, this.unicodeTransliterator, baseConnectionProperties.socketSnoopingEnabled(), true) : new SQLServerByteOrderedDataWriter(this.sslSocket, this.unicodeTransliterator, baseConnectionProperties.socketSnoopingEnabled(), (this.serverEncryptMode & 1) == 0);
        this.databaseMajorVersion = 0;
        this.databaseMinorVersion = 0;
        this.catalog = null;
        this.currentlyRegisteredReader = null;
        this.currentlyRegisteredRequest = null;
    }

    public synchronized SQLServerImplStatement getCancelPendingStatement() {
        return this.cancelPendingStatement;
    }

    public synchronized void setCancelPendingStatement(SQLServerImplStatement sQLServerImplStatement) {
        this.cancelPendingStatement = sQLServerImplStatement;
    }

    private String mapInstanceNameToPort(String string, String string2) throws SQLException {
        int n;
        Object object;
        DatagramSocket datagramSocket = null;
        byte[] byArray = new byte[1024];
        try {
            datagramSocket = new DatagramSocket();
            object = InetAddress.getByName(string);
            byte[] byArray2 = ("x" + string2).getBytes();
            byArray2[0] = 4;
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, (InetAddress)object, 1434);
            datagramSocket.send(datagramPacket);
            datagramSocket.setSoTimeout(1000);
            datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramSocket.receive(datagramPacket);
            byArray = datagramPacket.getData();
        }
        catch (Exception exception) {
            throw this.exceptions.getException(7014, "08001");
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        object = new String(byArray, 3, byArray.length - 3);
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            n2 = ((String)object).indexOf(59, n2);
            ++n2;
        }
        if ((n2 = ((String)object).indexOf("tcp;", n2)) == -1) {
            throw this.exceptions.getException(7014);
        }
        n = n2 + 4;
        int n3 = ((String)object).indexOf(59, n);
        return ((String)object).substring(n, n3);
    }

    public SQLServerByteOrderedDataReader createReader() {
        SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader = null;
        sQLServerByteOrderedDataReader = this.sslSocket == null ? new SQLServerByteOrderedDataReader(this, this.socket, this.replyBufferSize, this.unicodeTransliterator) : new SQLServerByteOrderedDataReader(this, this.sslSocket, this.replyBufferSize, this.unicodeTransliterator);
        return sQLServerByteOrderedDataReader;
    }

    public void close() throws SQLException {
        this.isTransactionImplicitOn = false;
        this.writer.close();
        try {
            this.socket.close();
            if (this.securityContext != null) {
                this.securityContext.cleanup();
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public SQLServerByteOrderedDataWriter getWriter() {
        return this.writer;
    }

    public void setMessageType(int n) {
        this.writer.messageType = n;
    }

    public void setPacketSize(int n) {
        this.writer.setPacketSize(n, (this.serverEncryptMode & 1) == 0);
        this.packetSize = n;
    }

    String mapCollationToCodePage(byte[] byArray) throws SQLException {
        if (this.codePageOverride.length() > 0) {
            return this.codePageOverride;
        }
        String string = null;
        if (byArray[4] != 0) {
            string = this.mapSortIdToCodePage(byArray[4] & 0xFF);
        } else {
            int n = (byArray[2] & 0xF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            string = this.mapLCIDToCodePage(n);
        }
        return string;
    }

    String mapSortIdToCodePage(int n) throws SQLException {
        String string = null;
        switch (n) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "437";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                string = "850";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: {
                string = "1252";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                string = "1250";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                string = "1251";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: 
            case 124: {
                string = "1253";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                string = "1254";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                string = "1255";
                break;
            }
            case 144: 
            case 145: 
            case 146: {
                string = "1256";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                string = "1257";
                break;
            }
            case 192: 
            case 193: 
            case 200: {
                string = "VMMS932";
                break;
            }
            case 194: 
            case 195: 
            case 201: {
                string = "949";
                break;
            }
            case 196: 
            case 197: 
            case 202: {
                string = "VM_MS950";
                break;
            }
            case 198: 
            case 199: 
            case 203: {
                string = "VM_MS936";
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                string = "874";
                break;
            }
            default: {
                String[] stringArray = new String[]{String.valueOf(n)};
                throw this.exceptions.getException(7015, stringArray);
            }
        }
        return string;
    }

    String mapLCIDToCodePage(int n) throws SQLException {
        String string = null;
        switch (n) {
            case 1054: {
                string = "874";
                break;
            }
            case 1041: 
            case 66577: {
                string = "VMMS932";
                break;
            }
            case 2052: 
            case 4100: 
            case 133124: {
                string = "VM_MS936";
                break;
            }
            case 1042: 
            case 66578: {
                string = "949";
                break;
            }
            case 1028: 
            case 197636: {
                string = "VM_MS950";
                break;
            }
            case 1029: 
            case 1038: 
            case 1045: 
            case 1048: 
            case 1050: 
            case 1051: 
            case 1052: 
            case 1060: 
            case 66574: {
                string = "1250";
                break;
            }
            case 1026: 
            case 1049: 
            case 1058: 
            case 1059: 
            case 1071: 
            case 2074: 
            case 3098: {
                string = "1251";
                break;
            }
            case 1027: 
            case 1030: 
            case 1031: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1039: 
            case 1040: 
            case 1043: 
            case 1044: 
            case 1046: 
            case 1053: 
            case 1057: 
            case 1069: 
            case 1080: 
            case 2055: 
            case 2057: 
            case 2058: 
            case 2060: 
            case 2064: 
            case 2067: 
            case 2068: 
            case 2070: 
            case 3079: 
            case 3081: 
            case 3082: 
            case 3084: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4108: 
            case 5127: 
            case 5129: 
            case 5130: 
            case 5132: 
            case 6153: 
            case 6154: 
            case 7178: 
            case 7717: 
            case 8201: 
            case 8202: 
            case 9225: 
            case 9226: 
            case 10250: 
            case 11274: 
            case 12298: 
            case 13322: 
            case 14346: 
            case 15370: 
            case 16394: 
            case 66567: 
            case 66615: {
                string = "1252";
                break;
            }
            case 1032: {
                string = "1253";
                break;
            }
            case 1055: {
                string = "1254";
                break;
            }
            case 1037: {
                string = "1255";
                break;
            }
            case 1025: 
            case 1056: 
            case 1065: 
            case 2049: 
            case 3073: 
            case 4097: 
            case 5121: 
            case 6145: 
            case 7169: 
            case 8193: 
            case 9217: 
            case 10241: 
            case 11265: 
            case 12289: 
            case 13313: 
            case 14337: 
            case 15361: 
            case 16385: {
                string = "1256";
                break;
            }
            case 1061: 
            case 1062: 
            case 1063: 
            case 2087: {
                string = "1257";
                break;
            }
            case 1066: {
                string = "1258";
                break;
            }
            default: {
                String[] stringArray = new String[]{String.valueOf(n)};
                throw this.exceptions.getException(7010, stringArray);
            }
        }
        return string;
    }

    public UtilTransliterator getTransliteratorForCodePage(String string) throws UtilException {
        return this.transliteratorPool.getTransliteratorForCodePage(string);
    }

    public void resetTransliteratorPool() {
        this.transliteratorPool.reset();
    }

    public byte[] getSQLCollation() {
        return this.sqlCollation;
    }

    public void setSQLCollation(byte[] byArray) {
        this.sqlCollation = byArray;
    }

    public void setNonUnicodeTransliterator(byte[] byArray) throws SQLException {
        this.setNonUnicodeTransliterator(this.mapCollationToCodePage(byArray));
    }

    public void setNonUnicodeTransliterator(String string) throws SQLException {
        if (this.codePageOverride.length() > 0) {
            string = this.codePageOverride;
        }
        try {
            this.nonUnicodeTransliterator = this.getTransliteratorForCodePage(string);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public int getTDSVersion() {
        return this.tdsVersion;
    }

    public void setTDSVersion(int n) {
        if (n == 0x7000000) {
            this.tdsVersion = 1;
        } else if (n == 0x7010000) {
            this.tdsVersion = 2;
        } else if (n == 1913192450) {
            this.tdsVersion = 3;
        } else {
            UtilDebug.assert("The server is using an unknown TDS version.", false);
        }
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(byte by) {
        this.databaseMajorVersion = by & 0xFF;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(byte by) {
        this.databaseMinorVersion = by & 0xFF;
    }

    public void setCatalog(String string) {
        this.catalog = string;
        this.connection.setCurrentCatalog(string);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLocalHostname() {
        if (this.socket != null) {
            String string = this.socket.getLocalAddress().toString();
            return string.substring(string.indexOf(47) + 1);
        }
        return "";
    }

    public String getServerHostname() {
        if (this.socket != null) {
            String string = this.socket.getInetAddress().toString();
            return string.substring(string.indexOf(47) + 1);
        }
        return "";
    }

    public byte[] getSecurityToken(byte[] byArray) throws SQLException {
        try {
            return this.securityContext.getSecurityToken(byArray);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void putReaderBuffer(byte[] byArray) {
        this.readerBufferPool.addElement(byArray);
    }

    public byte[] getReaderBuffer(int n) {
        int n2 = this.readerBufferPool.size();
        if (n2 > 0) {
            return (byte[])this.readerBufferPool.remove(n2 - 1);
        }
        return new byte[n];
    }

    private UtilSecurityContext createSecurityContext(String string, String string2) throws UtilException, SQLException {
        if (string.equalsIgnoreCase("ntlm")) {
            this.username = "";
            return UtilSecurityContextCreator.createType2SecurityContext(string2, this.connection.getLoadLibraryPath());
        }
        if (string.equalsIgnoreCase("kerberos")) {
            this.username = "";
            return UtilSecurityContextCreator.createType4SecurityContext(string2);
        }
        if (this.username != null && this.username.length() > 0) {
            return null;
        }
        if (string.equalsIgnoreCase("type2")) {
            return UtilSecurityContextCreator.createType2SecurityContext(string2, this.connection.getLoadLibraryPath());
        }
        if (string.equalsIgnoreCase("type4")) {
            return UtilSecurityContextCreator.createType4SecurityContext(string2);
        }
        if (string.equalsIgnoreCase("none") || string.equalsIgnoreCase("UserIdPassword")) {
            throw this.exceptions.getException(7022);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                return UtilSecurityContextCreator.createType2SecurityContext(string2, this.connection.getLoadLibraryPath());
            }
            catch (UtilException utilException) {
                return UtilSecurityContextCreator.createType4SecurityContext(string2);
            }
        }
        return UtilSecurityContextCreator.createType4SecurityContext(string2);
    }

    public void closeSSLSocket() throws SQLException {
        try {
            this.sslSocket = null;
            this.writer = new SQLServerByteOrderedDataWriter(this.socket, this.unicodeTransliterator, this.writer.getDebuggingSocket(), true);
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    private class TransliteratorForLCID {
        String codePage;
        UtilTransliterator transliterator;

        private TransliteratorForLCID() {
        }
    }
}

