/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilTransliterator;
import java.math.BigInteger;
import java.security.Key;
import java.sql.SQLException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DRDACrypto {
    private static String footprint = "$Revision:   1.7.1.0  $";
    private static final byte[] b = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private BigInteger largePrime = new BigInteger(1, b);
    private static final byte[] d = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private BigInteger generator = new BigInteger(1, d);
    public BigInteger serverPublicKey;
    private BigInteger clientPublicKey;
    private BigInteger clientPrivateKey;
    private BigInteger sharedSecret;
    private byte[] DESKey;
    private byte[] DESInitVector;
    public byte[] serverPubKeyBytes;
    public Cipher encryptCipher;
    public Cipher decryptCipher;
    IvParameterSpec initVectorSpec;
    SecretKeySpec secretkeyspec;
    private boolean updateCipherInitialized = false;
    private DRDACommunication comm;

    public DRDACrypto(DRDACommunication dRDACommunication) throws SQLException {
        try {
            this.comm = dRDACommunication;
            this.encryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            this.decryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        }
        catch (SecurityException securityException) {
            throw dRDACommunication.exceptions.getException((Exception)securityException);
        }
        catch (Exception exception) {
            throw dRDACommunication.exceptions.getException(exception);
        }
    }

    public void setInitVector(IvParameterSpec ivParameterSpec) {
        this.initVectorSpec = ivParameterSpec;
    }

    public void setSecretKey(SecretKeySpec secretKeySpec) {
        this.secretkeyspec = secretKeySpec;
    }

    public byte[] getConnectionKey() {
        BigInteger bigInteger = new BigInteger(80, new Random());
        byte[] byArray = new byte[32];
        while (bigInteger.toByteArray().length < 10) {
            bigInteger = new BigInteger(80, new Random());
        }
        System.arraycopy(bigInteger.toByteArray(), 0, byArray, 22, 10);
        this.clientPrivateKey = new BigInteger(1, byArray);
        this.clientPublicKey = this.generator.modPow(this.clientPrivateKey, this.largePrime);
        return this.getKeyBytes(this.clientPublicKey);
    }

    public byte[] getSharedSessionKey() {
        this.serverPublicKey = new BigInteger(1, this.serverPubKeyBytes);
        this.sharedSecret = this.serverPublicKey.modPow(this.clientPrivateKey, this.largePrime);
        return this.getKeyBytes(this.sharedSecret);
    }

    public byte[] deriveDESKey(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byte by = byArray[i + 12];
            int n = 0;
            for (int j = 0; j < 7; ++j) {
                if ((byte)(by & 0xFFFFFF80) == -128) {
                    ++n;
                }
                by = (byte)(by << 1);
            }
            byte by2 = n & true ? (byte)0 : 1;
            byArray2[i] = (byte)((byte)(byArray[i + 12] & 0xFFFFFFFE) | by2);
        }
        this.DESKey = byArray2;
        this.secretkeyspec = new SecretKeySpec(this.DESKey, "DES");
        return this.DESKey;
    }

    public byte[] deriveDESInitVector(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = byArray.length;
        if (n < 8) {
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = i <= n - 1 ? byArray[i] : (byte)0;
            }
        } else {
            int n2 = n / 2 - 4;
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = byArray[i + n2];
            }
        }
        this.DESInitVector = byArray2;
        this.initVectorSpec = new IvParameterSpec(this.DESInitVector);
        return this.DESInitVector;
    }

    public byte[] DES_Encrypt(String string, UtilTransliterator utilTransliterator) throws SQLException {
        try {
            byte[] byArray = utilTransliterator.encode(string);
            this.encryptCipher.init(1, (Key)this.secretkeyspec, this.initVectorSpec);
            byte[] byArray2 = this.encryptCipher.doFinal(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
    }

    public int DES_Encrypt_ByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws SQLException {
        int n4 = -1;
        try {
            this.encryptCipher.init(1, (Key)this.secretkeyspec, this.initVectorSpec);
            n4 = this.encryptCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return n4;
    }

    public int getOutputSize(int n) throws SQLException {
        try {
            this.decryptCipher.init(1, (Key)this.secretkeyspec, this.initVectorSpec);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return this.encryptCipher.getOutputSize(n);
    }

    public String DES_Decrypt(byte[] byArray, UtilTransliterator utilTransliterator) throws SQLException {
        try {
            this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
            byte[] byArray2 = this.decryptCipher.doFinal(byArray);
            return utilTransliterator.decode(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
    }

    public void initCipher_decrypt() throws SQLException {
        try {
            this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
    }

    public int DES_Decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws SQLException {
        int n4 = -1;
        try {
            this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
            n4 = this.decryptCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return n4;
    }

    public int DES_Decrypt_update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws SQLException {
        int n4 = -1;
        try {
            if (!this.updateCipherInitialized) {
                this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
                this.updateCipherInitialized = true;
            }
            n4 = this.decryptCipher.update(byArray, n, n2, byArray2, n3);
        }
        catch (Exception exception) {
            this.updateCipherInitialized = false;
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return n4;
    }

    public int DES_Decrypt_update_final(byte[] byArray, int n) throws SQLException {
        int n2 = -1;
        try {
            n2 = this.decryptCipher.doFinal(byArray, n);
            this.updateCipherInitialized = false;
        }
        catch (Exception exception) {
            this.updateCipherInitialized = false;
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return n2;
    }

    public int DES_Decrypt_update_final(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws SQLException {
        int n4 = -1;
        try {
            n4 = this.decryptCipher.doFinal(byArray, n, n2, byArray2, n3);
            this.updateCipherInitialized = false;
        }
        catch (Exception exception) {
            this.updateCipherInitialized = false;
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
        return n4;
    }

    public byte[] DES_Decrypt(byte[] byArray, int n, int n2) throws SQLException {
        try {
            this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
            return this.decryptCipher.doFinal(byArray, n, n2);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.comm.exceptions.getException(7107, stringArray);
        }
    }

    private String printBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(UtilDataConversions.byteToHex((byte)byArray[i]));
            if (i == byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private byte[] getKeyBytes(BigInteger bigInteger) {
        byte[] byArray = new byte[32];
        if (bigInteger.toByteArray().length > 32 && bigInteger.toByteArray()[0] == 0) {
            System.arraycopy(bigInteger.toByteArray(), 1, byArray, 0, 32);
        } else {
            byArray = bigInteger.toByteArray();
        }
        return byArray;
    }
}

