/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.model;

import com.metamatrix.modeler.modelgenerator.xml.model.DatabaseMetaDataBase;
import com.metamatrix.modeler.modelgenerator.xml.model.MapResultSet;
import com.metamatrix.modeler.modelgenerator.xml.model.UserSettings;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.schema.tools.NameUtil;
import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.QName;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.Type;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelImpl;
import com.metamatrix.modeler.schema.tools.processing.SchemaUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class DatabaseMetaDataImpl
extends DatabaseMetaDataBase {
    private static final String ELEMENT_TABLETYPE = "ELEMENT";
    private static final String RELATIONSHIP_TABLETYPE = "RELATIONSHIP";
    private static final String[] tableTypes = new String[]{"ELEMENT", "RELATIONSHIP"};
    private StateManager stateManager;
    private UserSettings userSettings;
    private List catalogsResultsetData;
    private List columnsResultsetData;
    private Map columnsByTableName;
    private List crossReferencesResultsetData;
    private Map crossReferencesByBothTableNames;
    private Map crossReferencesByPrimaryTableName;
    private Map crossReferencesByForeignTableName;
    private List primaryKeysResultsetData;
    private Map primaryKeysByTableName;
    private List tablesResultsetData;
    private Map tablesByTableName;
    private List tableTypesResultsetData;
    private Map tableNameInSourceMap;
    private Map columnNameInSourceMap;
    private Map primaryKeyNameInSourceMap;
    private Map foreignKeyNameInSourceMap;
    private Map tableSimpleNameMap;
    private Map columnSimpleNameMap;
    private Map primaryKeySimpleNameMap;
    private Map foreignKeySimpleNameMap;
    private Object syncObject;
    private SchemaModel schemaModel;
    private HashSet knownCatalogs;
    public static boolean exportSQL = true;

    public DatabaseMetaDataImpl(StateManager manager, UserSettings userSettings, Connection connection, Object syncObject) {
        super(connection);
        this.stateManager = manager;
        this.syncObject = syncObject;
        this.userSettings = userSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        Object object = this.syncObject;
        synchronized (object) {
            this.initialize();
        }
    }

    private void ensureInitialized() {
    }

    private void initialize() {
        this.tableTypesResultsetData = new ArrayList();
        this.catalogsResultsetData = new ArrayList();
        this.columnsResultsetData = new ArrayList();
        this.columnsByTableName = new HashMap();
        this.crossReferencesResultsetData = new ArrayList();
        this.crossReferencesByBothTableNames = new HashMap();
        this.crossReferencesByPrimaryTableName = new HashMap();
        this.crossReferencesByForeignTableName = new HashMap();
        this.primaryKeysResultsetData = new ArrayList();
        this.primaryKeysByTableName = new HashMap();
        this.tablesResultsetData = new ArrayList();
        this.tablesByTableName = new HashMap();
        this.tableNameInSourceMap = new HashMap();
        this.columnNameInSourceMap = new HashMap();
        this.primaryKeyNameInSourceMap = new HashMap();
        this.foreignKeyNameInSourceMap = new HashMap();
        this.tableSimpleNameMap = new HashMap();
        this.columnSimpleNameMap = new HashMap();
        this.primaryKeySimpleNameMap = new HashMap();
        this.foreignKeySimpleNameMap = new HashMap();
        this.knownCatalogs = new HashSet();
        this.schemaModel = this.stateManager.getProcessedModel();
        this.createMetadataForTableTypes();
        this.createMetadataForCatalogs();
        this.createMetadataForRequestTable();
        this.createMetadataForTables();
        if (exportSQL) {
            this.exportMetaData();
        }
    }

    private void createMetadataForTables() {
        for (Object o : this.schemaModel.getElements()) {
            SchemaObject table = (SchemaObject)o;
            this.createMetadataForTable(table);
        }
    }

    private void createMetadataForRequestTable() {
        if (this.userSettings.getSourceType() == 4 || this.userSettings.getSourceType() == 2 || this.userSettings.getSourceType() == 3) {
            QName qname = this.stateManager.getRequestResponseTable();
            this.addTable(qname.getNamespace(), qname.getLName(), ELEMENT_TABLETYPE);
            this.addTableNameToMap(qname.getNamespace(), this.userSettings.getRequestResponseTableXpath(), qname.getLName());
        }
    }

    protected void createMetadataForCatalogs() {
        this.catalogsResultsetData = new ArrayList();
        List catalogs = this.stateManager.getCatalogs();
        for (int i = 0; i < catalogs.size(); ++i) {
            String catalog = (String)catalogs.get(i);
            if (catalog == null || catalog.length() == 0) continue;
            this.createMetadataForCatalog(catalog);
        }
        this.createMetadataForCatalog(StateManager.globalNamespace);
    }

    public static String[] getTableTypeNames() {
        return tableTypes;
    }

    private void createMetadataForTableTypes() {
        for (int i = 0; i < DatabaseMetaDataImpl.getTableTypeNames().length; ++i) {
            String tableType = DatabaseMetaDataImpl.getTableTypeNames()[i];
            ArrayList<String> row = new ArrayList<String>();
            row.add(tableType);
            this.tableTypesResultsetData.add(row);
        }
    }

    private void createMetadataForCatalog(String catalog) {
        if (!this.knownCatalogs.contains(catalog)) {
            this.knownCatalogs.add(catalog);
            ArrayList<String> row = new ArrayList<String>();
            row.add(catalog);
            this.catalogsResultsetData.add(row);
        }
    }

    private void createMetadataForTable(SchemaObject table) {
        this.addTableForTable(table);
        int pkIndex = 1;
        for (Object oCol : table.getAttributes()) {
            Column column = (Column)oCol;
            this.addColumnForTable(table, column);
            if (!column.isPrimaryKey()) continue;
            this.addPrimaryKeyForTable(table, column, pkIndex++);
        }
        for (Object oTableRelationship : table.getChildren()) {
            Relationship tableRelationship = (Relationship)oTableRelationship;
            String key = tableRelationship.getChild().getSimpleName() + ':' + tableRelationship.getChild().getNamespace();
            int representation = ((SchemaModelImpl)this.schemaModel).getRelationToParent(key);
            switch (representation) {
                case 5: {
                    this.createMetadataForRelationshipTable(tableRelationship);
                    break;
                }
                case 4: {
                    this.createMetadataForKeyInChild(tableRelationship);
                    break;
                }
                case 0: {
                    this.createMetadataForKeyInParent(tableRelationship);
                    break;
                }
                case 1: {
                    this.createMetadataForKeyInParent(tableRelationship);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private void createMetadataForKeyInChild(Relationship tableRelationship) {
        int pkIndex = 1;
        for (Object oCol : tableRelationship.getParent().getAttributes()) {
            Column column = (Column)oCol;
            if (!column.isPrimaryKey()) continue;
            this.addColumnForKeyInChild(tableRelationship, column);
            this.addForeignKeyForKeyInChild(tableRelationship, column, pkIndex);
            ++pkIndex;
        }
    }

    private void createMetadataForKeyInParent(Relationship tableRelationship) {
        int maxOccurs = tableRelationship.getMaxOccurs();
        for (int iOccurrence = 1; iOccurrence <= maxOccurs; ++iOccurrence) {
            int pkIndex = 1;
            int iOccurenceParam = maxOccurs > 1 ? iOccurrence : -1;
            for (Object oCol : tableRelationship.getChild().getAttributes()) {
                Column column = (Column)oCol;
                if (!column.isPrimaryKey()) continue;
                this.addColumnForKeyInParent(tableRelationship, column, iOccurenceParam);
                this.addForeignKeyForKeyInParent(tableRelationship, column, pkIndex, iOccurenceParam);
                ++pkIndex;
            }
        }
    }

    private void createMetadataForRelationshipTable(Relationship tableRelationship) {
        this.addTableForParent(tableRelationship);
        int pkIndex = 1;
        SchemaObject child = tableRelationship.getChild();
        SchemaObject parent = tableRelationship.getParent();
        int fkIndex = 1;
        for (Object oCol : parent.getAttributes()) {
            Column column = (Column)oCol;
            if (!column.isPrimaryKey()) continue;
            this.addColumnForRelationshipTable(tableRelationship, column, false);
            this.addPrimaryKeyForRelationshipTable(tableRelationship, column, false, pkIndex++);
            this.addForeignKeyForRelationshipTable(tableRelationship, column, false, fkIndex++);
        }
        fkIndex = 1;
        boolean selfReference = parent == child;
        for (Object oCol : child.getAttributes()) {
            Column column = (Column)oCol;
            if (!column.isPrimaryKey()) continue;
            this.addColumnForRelationshipTable(tableRelationship, column, selfReference);
            this.addPrimaryKeyForRelationshipTable(tableRelationship, column, selfReference, pkIndex++);
            this.addForeignKeyForRelationshipTable(tableRelationship, column, selfReference, fkIndex++);
        }
    }

    private String getPrimaryKeySimpleName(String name, String namespace) {
        String[] array = new String[]{namespace, name};
        List<String> list = Arrays.asList(array);
        return (String)this.primaryKeyNameInSourceMap.get(list);
    }

    private String getTableSimpleName(String name, String namespace) {
        String[] array = new String[]{namespace, name};
        List<String> list = Arrays.asList(array);
        return (String)this.tableNameInSourceMap.get(list);
    }

    private String getColumnSimpleName(String name, String namespace, String tableName) {
        String[] array = new String[]{namespace, tableName, name};
        List<String> list = Arrays.asList(array);
        return (String)this.columnNameInSourceMap.get(list);
    }

    private String getForeignKeySimpleName(String name, String namespace) {
        String[] array = new String[]{namespace, name};
        List<String> list = Arrays.asList(array);
        return (String)this.foreignKeyNameInSourceMap.get(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrimaryKeyNameInSource(String name, String namespace) {
        Object object = this.syncObject;
        synchronized (object) {
            String[] array = new String[]{namespace, name};
            List<String> list = Arrays.asList(array);
            return (String)this.primaryKeySimpleNameMap.get(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getForeignKeyNameInSource(String name, String namespace) {
        Object object = this.syncObject;
        synchronized (object) {
            String[] array = new String[]{namespace, name};
            List<String> list = Arrays.asList(array);
            return (String)this.foreignKeySimpleNameMap.get(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableNameInSource(String name, String namespace) {
        Object object = this.syncObject;
        synchronized (object) {
            String[] array = new String[]{namespace, name};
            List<String> list = Arrays.asList(array);
            return (String)this.tableSimpleNameMap.get(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnNameInSource(String name, String namespace, String tableName) {
        Object object = this.syncObject;
        synchronized (object) {
            String[] array = new String[]{namespace, tableName, name};
            List<String> list = Arrays.asList(array);
            return (String)this.columnSimpleNameMap.get(list);
        }
    }

    private void addTableNameToMap(String catalog, String name, String simpleName) {
        String[] array = new String[]{catalog, name};
        List<String> list = Arrays.asList(array);
        this.tableNameInSourceMap.put(list, simpleName);
        array = new String[]{catalog, simpleName};
        list = Arrays.asList(array);
        this.tableSimpleNameMap.put(list, name);
    }

    private void addColumnNameToMap(String catalog, String tableName, String columnName, String simpleName, String tableSimpleName) {
        String[] array = new String[]{catalog, tableName, columnName};
        List<String> list = Arrays.asList(array);
        this.columnNameInSourceMap.put(list, simpleName);
        array = new String[]{catalog, tableSimpleName, simpleName};
        list = Arrays.asList(array);
        this.columnSimpleNameMap.put(list, columnName);
    }

    private void addPrimaryKeyNameToMap(String catalog, String primaryKeyName, String simpleName) {
        String[] array = new String[]{catalog, primaryKeyName};
        List<String> list = Arrays.asList(array);
        this.primaryKeyNameInSourceMap.put(list, simpleName);
        array = new String[]{catalog, simpleName};
        list = Arrays.asList(array);
        this.primaryKeySimpleNameMap.put(list, primaryKeyName);
    }

    private void addForeignKeyNameToMap(String catalog, String foreignKeyName, String simpleName) {
        String[] array = new String[]{catalog, foreignKeyName};
        List<String> list = Arrays.asList(array);
        this.foreignKeyNameInSourceMap.put(list, simpleName);
        array = new String[]{catalog, simpleName};
        list = Arrays.asList(array);
        this.foreignKeySimpleNameMap.put(list, foreignKeyName);
    }

    private void addTableForTable(SchemaObject table) {
        String catalog = this.stateManager.getCatalog(table);
        this.createMetadataForCatalog(catalog);
        String name = table.getInputXPath();
        String simpleName = NameUtil.normalizeNameForRelationalTable((String)table.getSimpleName());
        this.addTable(catalog, simpleName, ELEMENT_TABLETYPE);
        this.addTableNameToMap(catalog, name, simpleName);
    }

    private void addColumnForTable(SchemaObject table, Column column) {
        String catalog = this.stateManager.getCatalog(table);
        String tableName = table.getInputXPath();
        String columnName = column.getXpath();
        String simpleName = NameUtil.normalizeNameForRelationalTable((String)column.getSimpleName());
        int sepLength = UserSettings.getMergedChildSep().length();
        if (simpleName.endsWith("text") && simpleName.length() > 4 + sepLength) {
            simpleName = simpleName.substring(0, simpleName.length() - 4 - sepLength);
        }
        String simpleTableName = NameUtil.normalizeNameForRelationalTable((String)table.getSimpleName());
        this.addColumn(catalog, simpleTableName, simpleName, (Type)column);
        this.addColumnNameToMap(catalog, tableName, columnName, simpleName, simpleTableName);
    }

    private void addPrimaryKeyForTable(SchemaObject table, Column column, int pkIndex) {
        String catalog = this.stateManager.getCatalog(table);
        String tableName = table.getInputXPath();
        String simpleTableName = NameUtil.normalizeNameForRelationalTable((String)table.getSimpleName());
        String columnName = column.getXpath();
        String primaryKeyName = "pk_" + tableName;
        String simpleName = "pk" + NameUtil.normalizeNameForRelationalTable((String)table.getSimpleName());
        this.addPrimaryKey(pkIndex, catalog, simpleTableName, columnName, simpleName);
        this.addPrimaryKeyNameToMap(catalog, primaryKeyName, simpleName);
    }

    private String getRelationshipCatalog(Relationship tableRelationship) {
        return this.stateManager.getCatalog(tableRelationship.getChild());
    }

    private String getRelationshipTableName(Relationship tableRelationship) {
        SchemaObject child = tableRelationship.getChild();
        String parent = tableRelationship.getParent().getInputXPath();
        String childRel = tableRelationship.getChildRelativeXpath();
        return parent + "/" + childRel;
    }

    private String getRelationshipTableSimpleName(Relationship tableRelationship) {
        return NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getChild().getSimpleName()) + "_rel_" + NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getParent().getSimpleName());
    }

    private String getRelationshipColumnName(Relationship tableRelationship, Column column, boolean selfReferenceChild) {
        String xpath;
        boolean useChild;
        SchemaObject child = tableRelationship.getChild();
        SchemaObject parent = tableRelationship.getParent();
        SchemaObject table = column.getTable();
        String columnXpath = column.getXpath();
        if (parent == child) {
            useChild = selfReferenceChild;
        } else {
            boolean bl = useChild = table == child;
        }
        if (useChild) {
            xpath = columnXpath;
        } else {
            String parentRelativeXpath = tableRelationship.getParentRelativeXpath();
            xpath = parentRelativeXpath + "/" + columnXpath;
        }
        return xpath;
    }

    private String getRelationshipSimpleColumnName(Column column, boolean selfReferenceChild) {
        SchemaObject table = column.getTable();
        StringBuffer retval = new StringBuffer();
        if (selfReferenceChild) {
            retval.append("child_");
        }
        retval.append(NameUtil.normalizeNameForRelationalTable((String)table.getSimpleName()));
        retval.append('_');
        retval.append(NameUtil.normalizeNameForRelationalTable((String)column.getSimpleName()));
        return retval.toString();
    }

    private void addTableForParent(Relationship tableRelationship) {
        String catalog = this.getRelationshipCatalog(tableRelationship);
        String name = this.getRelationshipTableName(tableRelationship);
        String simpleName = this.getRelationshipTableSimpleName(tableRelationship);
        this.addTable(catalog, simpleName, RELATIONSHIP_TABLETYPE);
        this.addTableNameToMap(catalog, name, simpleName);
    }

    private void addTable(String catalog, String name, String tableType) {
        ArrayList<String> row = new ArrayList<String>();
        row = new ArrayList();
        row.add(catalog);
        row.add(null);
        row.add(name);
        row.add(tableType);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        this.tablesResultsetData.add(row);
        QName qname = SchemaUtil.getQName((String)catalog, (String)name);
        this.addToMapOfLists(this.tablesByTableName, qname, row);
    }

    private void addColumnForRelationshipTable(Relationship tableRelationship, Column column, boolean selfReferenceChild) {
        String catalog = this.getRelationshipCatalog(tableRelationship);
        String columnName = this.getRelationshipColumnName(tableRelationship, column, selfReferenceChild);
        String simpleName = this.getRelationshipSimpleColumnName(column, selfReferenceChild);
        String tableName = this.getRelationshipTableName(tableRelationship);
        String simpleTableName = this.getRelationshipTableSimpleName(tableRelationship);
        this.addColumn(catalog, simpleTableName, simpleName, (Type)column);
        this.addColumnNameToMap(catalog, tableName, columnName, simpleName, simpleTableName);
    }

    private void addColumnForKeyInChild(Relationship tableRelationship, Column column) {
        String catalog = this.stateManager.getCatalog(tableRelationship.getChild());
        String columnName = tableRelationship.getParentRelativeXpath() + "/" + column.getXpath();
        String simpleName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getParent().getSimpleName()) + "_" + NameUtil.normalizeNameForRelationalTable((String)column.getSimpleName());
        String tableName = tableRelationship.getParent().getInputXPath() + "/" + tableRelationship.getChildRelativeXpath();
        String simpleTableName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getChild().getSimpleName());
        this.addColumn(catalog, simpleTableName, simpleName, (Type)column);
        this.addColumnNameToMap(catalog, tableName, columnName, simpleName, simpleTableName);
    }

    private void addForeignKeyForKeyInChild(Relationship tableRelationship, Column column, int fkIndex) {
        String importerCatalog = this.stateManager.getCatalog(tableRelationship.getChild());
        String importerColumnName = tableRelationship.getParentRelativeXpath() + "/" + column.getXpath();
        String importerTableName = tableRelationship.getParent().getInputXPath() + "/" + tableRelationship.getChildRelativeXpath();
        String importerTableSimpleName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getChild().getSimpleName());
        String exporterCatalog = this.stateManager.getCatalog(tableRelationship.getParent());
        String exporterColumnName = column.getXpath();
        String exporterTableName = tableRelationship.getParent().getInputXPath();
        String exporterTableSimpleName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getParent().getSimpleName());
        String primaryKeyName = "pk_" + exporterTableName;
        String foreignKeyName = "fk_" + importerTableName + "_" + exporterTableName;
        String simpleName = "fk_" + importerTableSimpleName + "_" + exporterTableSimpleName;
        this.addCrossReference(fkIndex, importerCatalog, importerColumnName, importerTableSimpleName, exporterCatalog, exporterColumnName, exporterTableSimpleName, primaryKeyName, simpleName);
        this.addForeignKeyNameToMap(exporterCatalog, foreignKeyName, simpleName);
    }

    private void addCrossReference(int index, String importerCatalog, String importerColumnName, String importerTableName, String exporterCatalog, String exporterColumnName, String exporterTableName, String primaryKeyName, String name) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(exporterCatalog);
        row.add(null);
        row.add(exporterTableName);
        row.add(exporterColumnName);
        row.add(importerCatalog);
        row.add(null);
        row.add(importerTableName);
        row.add(importerColumnName);
        row.add(new Integer(index));
        row.add(new Integer(3));
        row.add(new Integer(3));
        row.add(name);
        row.add(primaryKeyName);
        row.add(new Integer(5));
        this.crossReferencesResultsetData.add(row);
        QName primaryQname = SchemaUtil.getQName((String)exporterCatalog, (String)exporterTableName);
        this.addToMapOfLists(this.crossReferencesByPrimaryTableName, primaryQname, row);
        QName foreignQname = SchemaUtil.getQName((String)importerCatalog, (String)importerTableName);
        this.addToMapOfLists(this.crossReferencesByForeignTableName, foreignQname, row);
        Pair pair = new Pair(primaryQname, foreignQname);
        this.addToMapOfLists(this.crossReferencesByBothTableNames, pair, row);
    }

    private void addColumnForKeyInParent(Relationship tableRelationship, Column column, int repetition) {
        String simpleName;
        String columnName;
        String catalog = this.stateManager.getCatalog(tableRelationship.getParent());
        String columnNameElementPart = tableRelationship.getChildRelativeXpath();
        String columnNameAttributePart = "/" + column.getXpath();
        String simpleNameElementPart = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getChild().getSimpleName());
        String simpleNameAttributePart = NameUtil.normalizeNameForRelationalTable((String)column.getSimpleName());
        if (repetition >= 0) {
            columnName = columnNameElementPart + "[" + repetition + "]" + columnNameAttributePart;
            simpleName = simpleNameElementPart + repetition + "_" + simpleNameAttributePart;
        } else {
            columnName = columnNameElementPart + columnNameAttributePart;
            simpleName = simpleNameElementPart + "_" + simpleNameAttributePart;
        }
        String tableName = tableRelationship.getParent().getInputXPath();
        String simpleTableName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getParent().getSimpleName());
        this.addColumn(catalog, simpleTableName, simpleName, (Type)column);
        this.addColumnNameToMap(catalog, tableName, columnName, simpleName, simpleTableName);
    }

    private void addColumn(String catalog, String tableName, String columnName, Type type) {
        XSDSimpleTypeDefinition sourceType = type.getType();
        EList validFacets = sourceType.getValidFacets();
        String typeName = null;
        String baseTypeName = sourceType.getBaseTypeDefinition().getName();
        typeName = baseTypeName != null && baseTypeName.equals("anySimpleType") ? sourceType.getRootTypeDefinition().getName() : sourceType.getBaseTypeDefinition().getName();
        int actualLength = 255;
        int actualFractionalDigits = 0;
        boolean lengthDone = false;
        if (validFacets.contains("length") && sourceType.getLengthFacet() != null) {
            actualLength = sourceType.getLengthFacet().getValue();
            lengthDone = true;
        }
        if (!lengthDone && validFacets.contains("maxLength") && sourceType.getMaxLengthFacet() != null) {
            actualLength = sourceType.getMaxLengthFacet().getValue();
            lengthDone = true;
        }
        if (!lengthDone && validFacets.contains("totalDigits") && sourceType.getTotalDigitsFacet() != null) {
            actualLength = sourceType.getTotalDigitsFacet().getValue();
        } else if (!lengthDone && validFacets.contains("totalDigits")) {
            actualLength = 20;
        }
        if (validFacets.contains("fractionDigits") && sourceType.getFractionDigitsFacet() != null) {
            actualFractionalDigits = sourceType.getFractionDigitsFacet().getValue();
        }
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(catalog);
        row.add(null);
        row.add(tableName);
        row.add(columnName);
        if (this.userSettings.isUseSchemaTypes()) {
            row.add(new Integer(this.getSQLtype(typeName)));
            row.add(typeName);
        } else {
            row.add(new Integer(this.getSQLtype("string")));
            row.add(String.class.getName());
        }
        row.add(new Integer(actualLength));
        row.add("");
        row.add(new Integer(actualFractionalDigits));
        row.add(new Integer(10));
        row.add(new Integer(2));
        row.add("");
        row.add("");
        row.add("");
        row.add("");
        String bType = type.getBaseType();
        if (bType != null && bType.equals("string")) {
            row.add(new Integer(actualLength * 2));
        } else {
            row.add(new Integer(0));
        }
        row.add("");
        row.add("");
        row.add("");
        row.add("");
        row.add("");
        row.add("");
        this.columnsResultsetData.add(row);
        QName qname = SchemaUtil.getQName((String)catalog, (String)tableName);
        this.addToMapOfLists(this.columnsByTableName, qname, row);
    }

    private int getSQLtype(String schemaTypeName) {
        int retval = 12;
        if (schemaTypeName == null) {
            return retval;
        }
        String lschemaTypeName = null;
        int idx = schemaTypeName.indexOf(":");
        lschemaTypeName = idx != -1 ? new String(schemaTypeName.substring(idx)) : schemaTypeName;
        if (lschemaTypeName.equals("string")) {
            retval = 12;
        } else if (lschemaTypeName.equals("boolean")) {
            retval = 16;
        } else if (lschemaTypeName.equals("decimal")) {
            retval = 3;
        } else if (lschemaTypeName.equals("float")) {
            retval = 6;
        } else if (lschemaTypeName.equals("double")) {
            retval = 8;
        } else if (lschemaTypeName.equals("duration")) {
            retval = 93;
        } else if (lschemaTypeName.equals("dateTime")) {
            retval = 93;
        } else if (lschemaTypeName.equals("integer")) {
            retval = 4;
        } else if (lschemaTypeName.equals("long") || lschemaTypeName.equals("nonPositiveInteger") || lschemaTypeName.equals("nonNegativeInteger")) {
            retval = 4;
        } else if (lschemaTypeName.equals("int") || lschemaTypeName.equals("positiveInteger") || lschemaTypeName.equals("negativeInteger") || lschemaTypeName.equals("unsignedLong")) {
            retval = 5;
        } else if (lschemaTypeName.equals("short") || lschemaTypeName.equals("unsignedInt")) {
            retval = -6;
        } else if (lschemaTypeName.equals("byte") || lschemaTypeName.equals("unsignedShort") || lschemaTypeName.equals("unsignedByte")) {
            retval = -6;
        } else if (lschemaTypeName.equals("date")) {
            retval = 93;
        } else if (lschemaTypeName.equals("time")) {
            retval = 93;
        } else if (lschemaTypeName.equals("dateTime")) {
            retval = 93;
        } else if (lschemaTypeName.equals("hexBinary")) {
            retval = -3;
        } else if (lschemaTypeName.equals("base64Binary")) {
            retval = -3;
        } else if (lschemaTypeName.equals("anyURI")) {
            retval = 12;
        } else if (lschemaTypeName.equals("QNameImpl")) {
            retval = 12;
        } else if (lschemaTypeName.equals("NOTATION")) {
            retval = 12;
        }
        return retval;
    }

    private void addToMapOfLists(Map map, Object key, List row) {
        Object olists = map.get(key);
        ArrayList<List> lists = (ArrayList<List>)olists;
        if (lists == null) {
            lists = new ArrayList<List>();
            map.put(key, lists);
        }
        lists.add(row);
    }

    private void addForeignKeyForKeyInParent(Relationship tableRelationship, Column column, int fkIndex, int repetition) {
        String importerCatalog = this.stateManager.getCatalog(tableRelationship.getParent());
        String columnNameElementPart = tableRelationship.getChildRelativeXpath();
        String columnNameAttributePart = "/" + column.getXpath();
        String importerColumnName = repetition >= 0 ? columnNameElementPart + "[" + repetition + "]" + columnNameAttributePart : columnNameElementPart + columnNameAttributePart;
        String importerTableName = tableRelationship.getParent().getInputXPath();
        String importerTableSimpleName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getParent().getSimpleName());
        String exporterCatalog = this.stateManager.getCatalog(tableRelationship.getChild());
        String exporterColumnName = column.getXpath();
        String exporterTableName = tableRelationship.getParent().getInputXPath() + "/" + tableRelationship.getChildRelativeXpath();
        String exporterTableSimpleName = NameUtil.normalizeNameForRelationalTable((String)tableRelationship.getChild().getSimpleName());
        String primaryKeyName = "pk_" + exporterTableName;
        String foreignKeyName = "fk_" + importerTableName + "_" + exporterTableName;
        if (repetition > 0) {
            foreignKeyName = foreignKeyName + repetition;
        }
        String simpleName = "fk_" + importerTableSimpleName + "_" + exporterTableSimpleName;
        if (repetition > 0) {
            simpleName = simpleName + repetition;
        }
        this.addCrossReference(fkIndex, importerCatalog, importerColumnName, importerTableSimpleName, exporterCatalog, exporterColumnName, exporterTableSimpleName, primaryKeyName, simpleName);
        this.addForeignKeyNameToMap(exporterCatalog, foreignKeyName, simpleName);
    }

    private void addPrimaryKeyForRelationshipTable(Relationship tableRelationship, Column column, boolean selfReferenceChild, int pkIndex) {
        String catalog = this.getRelationshipCatalog(tableRelationship);
        String tableName = this.getRelationshipTableName(tableRelationship);
        String simpleTableName = this.getRelationshipTableSimpleName(tableRelationship);
        String columnName = this.getRelationshipColumnName(tableRelationship, column, selfReferenceChild);
        String primaryKeyName = "pk_" + tableName;
        String simpleName = "pk_" + this.getRelationshipTableSimpleName(tableRelationship);
        this.addPrimaryKey(pkIndex, catalog, simpleTableName, columnName, simpleName);
        this.addPrimaryKeyNameToMap(catalog, primaryKeyName, simpleName);
    }

    private void addPrimaryKey(int pkIndex, String catalog, String tableName, String columnName, String keyName) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(catalog);
        row.add(null);
        row.add(tableName);
        row.add(columnName);
        row.add(new Integer(pkIndex));
        row.add(keyName);
        this.primaryKeysResultsetData.add(row);
        QName qname = SchemaUtil.getQName((String)catalog, (String)tableName);
        this.addToMapOfLists(this.primaryKeysByTableName, qname, row);
    }

    private void addForeignKeyForRelationshipTable(Relationship tableRelationship, Column column, boolean selfReferenceChild, int fkIndex) {
        String importerCatalog = this.getRelationshipCatalog(tableRelationship);
        String importerTableName = this.getRelationshipTableName(tableRelationship);
        String importerTableSimpleName = this.getRelationshipTableSimpleName(tableRelationship);
        String importerColumnName = this.getRelationshipColumnName(tableRelationship, column, selfReferenceChild);
        String exporterCatalog = this.stateManager.getCatalog(column.getTable());
        String exporterTableName = column.getTable().getInputXPath();
        String exporterTableSimpleName = NameUtil.normalizeNameForRelationalTable((String)column.getTable().getSimpleName());
        String exporterColumnName = column.getXpath();
        String primaryKeyName = "pk_" + exporterTableName;
        String fkPrefix = selfReferenceChild ? "fk_child_" : "fk_";
        String foreignKeyName = fkPrefix + importerTableName + "_" + exporterTableName;
        String simpleName = fkPrefix + this.getRelationshipTableSimpleName(tableRelationship) + "_" + NameUtil.normalizeNameForRelationalTable((String)column.getTable().getSimpleName());
        this.addCrossReference(fkIndex, importerCatalog, importerColumnName, importerTableSimpleName, exporterCatalog, exporterColumnName, exporterTableSimpleName, primaryKeyName, simpleName);
        this.addForeignKeyNameToMap(exporterCatalog, foreignKeyName, simpleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCatalogs() throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            this.ensureInitialized();
            MapResultSet retval = new MapResultSet(this.catalogsResultsetData, catalogsResultsetMetadata);
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTableTypes() throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            return new MapResultSet(this.tableTypesResultsetData, tableTypesResultsetMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            this.ensureInitialized();
            QName qname = this.makeLookup(catalog, schema, table);
            if (qname != null) {
                Object o = this.crossReferencesByPrimaryTableName.get(qname);
                data = (List)o;
                if (data == null) {
                    data = new ArrayList();
                }
            } else {
                data = new ArrayList();
                for (Object o : this.crossReferencesResultsetData) {
                    List row = (List)o;
                    Object rowCatalog = row.get(0);
                    Object rowTable = row.get(2);
                    if (catalog != null && !catalog.equals(rowCatalog) || table != null && !table.equals(rowTable)) continue;
                    data.add(row);
                }
            }
            return new MapResultSet(data, crossReferencesResultsetMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            this.ensureInitialized();
            QName qname = this.makeLookup(catalog, schema, table);
            if (qname != null) {
                Object o = this.crossReferencesByForeignTableName.get(qname);
                data = (List)o;
                if (data == null) {
                    data = new ArrayList();
                }
            } else {
                data = new ArrayList();
                for (Object o : this.crossReferencesResultsetData) {
                    List row = (List)o;
                    Object rowCatalog = row.get(4);
                    Object rowTable = row.get(6);
                    if (catalog != null && !catalog.equals(rowCatalog) || table != null && !table.equals(rowTable)) continue;
                    data.add(row);
                }
            }
            return new MapResultSet(data, crossReferencesResultsetMetadata);
        }
    }

    private QName makeLookup(String catalog, String schema, String tableNamePattern) {
        if (tableNamePattern == null || tableNamePattern.indexOf(37) > -1) {
            return null;
        }
        if (schema != null) {
            return null;
        }
        QName retval = SchemaUtil.getQName((String)catalog, (String)tableNamePattern);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPrimaryKeys(String catalog, String schema, String tableNamePattern) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            this.ensureInitialized();
            QName qname = this.makeLookup(catalog, schema, tableNamePattern);
            if (qname != null) {
                Object o = this.primaryKeysByTableName.get(qname);
                data = (List)o;
                if (data == null) {
                    data = new ArrayList();
                }
            } else {
                data = new ArrayList();
                for (Object o : this.primaryKeysResultsetData) {
                    List row = (List)o;
                    Object rowCatalog = row.get(0);
                    Object oRowTable = row.get(2);
                    String rowTable = (String)oRowTable;
                    if (catalog != null && !catalog.equals(rowCatalog) || tableNamePattern != null && !this.patternMatch(tableNamePattern, rowTable)) continue;
                    data.add(row);
                }
            }
            return new MapResultSet(data, primaryKeysResultsetMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            List<List> dataForTable;
            this.ensureInitialized();
            QName qname = this.makeLookup(catalog, schemaPattern, tableNamePattern);
            if (qname != null) {
                Object o = this.columnsByTableName.get(qname);
                dataForTable = (List)o;
            } else {
                dataForTable = new ArrayList();
                for (Object o : this.columnsResultsetData) {
                    List list = (List)o;
                    Object rowCatalog = list.get(0);
                    Object oRowTable = list.get(2);
                    String rowTable = (String)oRowTable;
                    if (catalog != null && !catalog.equals(rowCatalog) || tableNamePattern != null && !this.patternMatch(tableNamePattern, rowTable)) continue;
                    dataForTable.add(list);
                }
            }
            if (columnNamePattern == null || columnNamePattern.equals("%")) {
                data = dataForTable;
            } else {
                data = new ArrayList();
                for (Object e : dataForTable) {
                    List row = (List)e;
                    Object oRowColumn = row.get(3);
                    String rowColumn = (String)oRowColumn;
                    if (!this.patternMatch(columnNamePattern, rowColumn)) continue;
                    data.add(row);
                }
            }
            if (data == null) {
                data = new ArrayList();
            }
            return new MapResultSet(data, columnsResultsetMetadata);
        }
    }

    private boolean patternMatch(String pattern, String test) {
        if (pattern.equals("%")) {
            return true;
        }
        if (pattern.indexOf(37) == -1) {
            boolean retval = pattern.equals(test);
            return retval;
        }
        StringBuffer regex = new StringBuffer();
        boolean insideQuote = false;
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '%': {
                    if (insideQuote) {
                        regex.append("\\E");
                        insideQuote = false;
                    }
                    regex.append(".*");
                    continue block4;
                }
                case '_': {
                    if (insideQuote) {
                        regex.append("\\E");
                        insideQuote = false;
                    }
                    regex.append('.');
                    continue block4;
                }
                default: {
                    if (!insideQuote) {
                        regex.append("\\Q");
                        insideQuote = true;
                    }
                    regex.append(c);
                }
            }
        }
        if (insideQuote) {
            regex.append("\\E");
            insideQuote = false;
        }
        Pattern p = Pattern.compile(regex.toString());
        Matcher m = p.matcher(test);
        boolean b = m.matches();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            List<List> dataForTable;
            this.ensureInitialized();
            List<String> typeList = types == null ? null : Arrays.asList(types);
            QName qname = this.makeLookup(catalog, schemaPattern, tableNamePattern);
            if (qname != null) {
                Object o = this.tablesByTableName.get(qname);
                dataForTable = (List)o;
                if (dataForTable == null) {
                    dataForTable = new ArrayList();
                }
            } else {
                dataForTable = new ArrayList();
                for (Object o : this.tablesResultsetData) {
                    List list = (List)o;
                    Object rowCatalog = list.get(0);
                    Object oRowTable = list.get(2);
                    String rowTable = (String)oRowTable;
                    if (catalog != null && !catalog.equals(rowCatalog) || tableNamePattern != null && !this.patternMatch(tableNamePattern, rowTable)) continue;
                    dataForTable.add(list);
                }
            }
            if (types == null) {
                data = dataForTable;
            } else {
                data = new ArrayList();
                for (Object e : dataForTable) {
                    List row = (List)e;
                    Object oType = row.get(3);
                    String type = (String)oType;
                    if (!typeList.contains(type)) continue;
                    data.add(row);
                }
            }
            return new MapResultSet(data, tablesResultsetMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            List<List> data;
            this.ensureInitialized();
            QName primaryQname = this.makeLookup(primaryCatalog, primarySchema, primaryTable);
            QName foreignQname = this.makeLookup(foreignCatalog, foreignSchema, foreignTable);
            Pair pair = primaryQname == null || foreignQname == null ? null : new Pair(primaryQname, foreignQname);
            if (pair != null) {
                Object o = this.crossReferencesByBothTableNames.get(pair);
                data = (List)o;
                if (data == null) {
                    data = new ArrayList();
                }
            } else {
                data = new ArrayList();
                for (Object o : this.crossReferencesResultsetData) {
                    List row = (List)o;
                    Object rowPkCatalog = row.get(0);
                    Object rowPkTable = row.get(2);
                    Object rowFkCatalog = row.get(4);
                    Object rowFkTable = row.get(6);
                    if (primaryCatalog != null && !primaryCatalog.equals(rowPkCatalog) || primaryTable != null && !primaryTable.equals(rowPkTable) || foreignCatalog != null && !foreignCatalog.equals(rowFkCatalog) || foreignTable != null && !foreignTable.equals(rowFkTable)) continue;
                    data.add(row);
                }
            }
            return new MapResultSet(data, crossReferencesResultsetMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMetaData() {
        File file = null;
        Writer writer = null;
        try {
            String tableNameInSource;
            String tableName;
            ResultSet tableset;
            String catalog;
            file = File.createTempFile("xmlmetadata", ".sql");
            writer = new FileWriter(file);
            ResultSet catalogset = this.getCatalogs();
            while (catalogset.next()) {
                catalog = catalogset.getString(1);
                tableset = this.getTables(catalog, null, null, null);
                while (tableset.next()) {
                    tableName = tableset.getString(3);
                    tableNameInSource = this.getTableNameInSource(tableName, catalog);
                    writer.write("CREATE TABLE [" + tableName + "] (\n");
                    ResultSet columnset = this.getColumns(catalog, null, tableName, null);
                    boolean first = true;
                    while (columnset.next()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.write(",\n");
                        }
                        writer.write("\t[" + columnset.getString(4) + "] [varchar] NOT NULL");
                    }
                    writer.write("\n) ON [PRIMARY]\nGO\n\n");
                    ResultSet pkset = this.getPrimaryKeys(catalog, null, tableName);
                    if (!pkset.next()) continue;
                    String pkName = pkset.getString(6);
                    writer.write("ALTER TABLE [" + tableName + "] ADD \n");
                    writer.write("\tCONSTRAINT [" + pkName + "] PRIMARY KEY CLUSTERED (\n");
                    first = true;
                    while (first || pkset.next()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.write(",\n");
                        }
                        String colNameInSource = pkset.getString(4);
                        String colName = this.getColumnSimpleName(colNameInSource, catalog, tableNameInSource);
                        writer.write("\t[" + colName + "]");
                    }
                    writer.write("\n) ON [PRIMARY]\nGO\n\n");
                }
            }
            catalogset = this.getCatalogs();
            while (catalogset.next()) {
                catalog = catalogset.getString(1);
                tableset = this.getTables(catalog, null, null, null);
                while (tableset.next()) {
                    tableName = tableset.getString(3);
                    tableNameInSource = this.getTableNameInSource(tableName, catalog);
                    ResultSet fkset = this.getImportedKeys(catalog, null, tableName);
                    if (!fkset.next()) continue;
                    String fkName = fkset.getString(12);
                    String exporterTableName = fkset.getString(3);
                    writer.write("ALTER TABLE [" + tableName + "] ADD \n");
                    writer.write("\tCONSTRAINT [" + fkName + "] FOREIGN KEY (\n");
                    boolean first = true;
                    while (first || fkset.next()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.write(",\n");
                        }
                        String importerColNameInSource = fkset.getString(8);
                        String importerColName = this.getColumnSimpleName(importerColNameInSource, catalog, tableNameInSource);
                        writer.write("\t[" + importerColName + "]");
                    }
                    writer.write("\n) REFERENCES " + exporterTableName + " (\n");
                    first = true;
                    fkset.beforeFirst();
                    while (fkset.next()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.write(",\n");
                        }
                        String exporterColNameInSource = fkset.getString(4);
                        String exporterColName = this.getColumnSimpleName(exporterColNameInSource, catalog, tableNameInSource);
                        writer.write("\t[" + exporterColName + "]");
                    }
                    writer.write("\n)\nGO\n\n");
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(0);
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter(0);
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    return;
                }
            }
        }
    }

    public Boolean isRequestOrResponseTable(QName qname) {
        return this.stateManager.isRequestOrResponseTable(qname);
    }

    protected void catalogsChanged() {
        this.initialize();
    }

    public Map getNamespacePrefixes(String name) {
        return this.schemaModel.getNamespacePrefixes();
    }

    private static class Pair {
        public Object o1;
        public Object o2;
        int hashCode;

        public Pair(Object o1, Object o2) {
            this.o1 = o1;
            this.o2 = o2;
            int o1Hash = o1 == null ? 0 : o1.hashCode();
            int o2Hash = o2 == null ? 0 : o2.hashCode();
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + o1Hash;
            this.hashCode = 37 * this.hashCode + o2Hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (this.o1 == null && other.o1 != null) {
                return false;
            }
            if (this.o1 != null && other.o1 == null) {
                return false;
            }
            if (this.o1 != null && !this.o1.equals(other.o1)) {
                return false;
            }
            if (this.o2 == null && other.o2 != null) {
                return false;
            }
            if (this.o2 != null && other.o2 == null) {
                return false;
            }
            return this.o2 == null || this.o2.equals(other.o2);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

