/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.util.UtilBufferedDataConsumer;
import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPacketizingDataConsumer;
import com.metamatrix.util.UtilSnoopIndirection;
import java.net.Socket;

public class SybasePacketizingDataConsumer
extends UtilPacketizingDataConsumer {
    private static String footprint = "$Revision:   3.3.1.0  $";
    private static int DEFAULT_PACKET_SIZE = 512;
    private int messageType;
    int savedStatusFieldPos;
    public Socket snoopSocket;

    public SybasePacketizingDataConsumer(UtilBufferedDataConsumer utilBufferedDataConsumer, Socket socket) {
        super((UtilDataConsumer)utilBufferedDataConsumer, DEFAULT_PACKET_SIZE);
        this.snoopSocket = socket;
    }

    public SybasePacketizingDataConsumer(UtilBufferedDataConsumer utilBufferedDataConsumer, Socket socket, boolean bl) {
        super((UtilDataConsumer)utilBufferedDataConsumer, DEFAULT_PACKET_SIZE, bl);
        this.snoopSocket = socket;
    }

    public void setMessageType(int n) {
        this.messageType = n;
    }

    protected void signalStartOfPacket() throws UtilException {
        if (this.snoopSocket != null) {
            UtilSnoopIndirection.addTextToSendStream((Socket)this.snoopSocket, (int)((UtilBufferedDataConsumer)this.dataConsumerObject).getPosition(), (String)"Start of Packet", (boolean)true);
        }
        if (this.messageType == 2 && this.numPacketsCreatedSinceSend >= 1) {
            this.writeInt8(15);
        } else {
            this.writeInt8(this.messageType);
        }
        this.savedStatusFieldPos = ((UtilBufferedDataConsumer)this.dataConsumerObject).getPosition();
        this.writeInt8(0);
        this.writeInt16(this.packetSize);
        this.writeInt16(0);
        this.writeInt8(1);
        this.writeInt8(0);
        this.numBytesInCurrentPacket += 8;
    }

    public void signalEndOfPacket(boolean bl) throws UtilException {
        if (this.numBytesInCurrentPacket < this.packetSize) {
            ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(this.savedStatusFieldPos + 1);
            this.writeInt16(this.numBytesInCurrentPacket);
            ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(Integer.MAX_VALUE);
        }
    }

    public void send() throws UtilException {
        if (this.messageType == 6) {
            this.signalStartOfPacket();
        }
        ((UtilBufferedDataConsumer)this.dataConsumerObject).setPosition(this.savedStatusFieldPos);
        this.writeInt8(1);
        super.send();
    }
}

