/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public class TDSRPCCallRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   3.6.1.0  $";
    private String procName;
    private boolean callHasReturnParam;

    public TDSRPCCallRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, String string, boolean bl) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter);
        this.procName = string;
        this.callHasReturnParam = bl;
    }

    public void createUserParameters(UtilVectorUnsynced utilVectorUnsynced, int n, boolean bl, int n2) {
        this.baseParamSets = utilVectorUnsynced;
        this.maxPrecision = n;
        this.sendStringParametersAsUnicode = bl;
        this.receiveStringParameterType = n2;
        if (utilVectorUnsynced == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)utilVectorUnsynced.get(0);
        int n3 = baseParameters.count();
        for (int i = 1; i <= n3; ++i) {
            if (i == 1 && this.callHasReturnParam) continue;
            this.addUserParameter(new TDSRPCParameter(this.conn, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        if (this.baseParamSets != null && this.baseParamSets.size() > 1) {
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                for (int i = 0; i < this.baseParamSets.size(); ++i) {
                    this.addRPCToBatch(this.procName, 0);
                    try {
                        this.processUserParameters((BaseParameters)this.baseParamSets.get(i));
                        this.addUserParametersToRPC();
                        this.encodeRPCCall(i == 0);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.removeLastRPCFromBatch();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.addRPCToBatch(this.procName, 0);
            if (this.baseParamSets != null) {
                this.processUserParameters((BaseParameters)this.baseParamSets.get(0));
            }
            this.addUserParametersToRPC();
        }
        this.submitRequest(sQLServerImplStatement);
    }

    private void processUserParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null) {
            return;
        }
        int n = baseParameters.count();
        TDSRPCParameter tDSRPCParameter = null;
        if (baseParameters.parameterOrder == 2) {
            for (int i = 1; i <= n; ++i) {
                if (i == 1 && this.callHasReturnParam) continue;
                tDSRPCParameter = this.callHasReturnParam ? (TDSRPCParameter)this.userParameters.get(i - 2) : (TDSRPCParameter)this.userParameters.get(i - 1);
                tDSRPCParameter.initializeUserParam(i, baseParameters, this.sendStringParametersAsUnicode, this.receiveStringParameterType);
            }
        } else {
            boolean bl = false;
            for (int i = 1; i <= n; ++i) {
                if (this.callHasReturnParam && !bl) {
                    BaseParameter baseParameter = baseParameters.get(i, 1);
                    if (baseParameter == null) {
                        baseParameter = baseParameters.get(i, 2);
                    }
                    if (baseParameter != null && baseParameter.name.equalsIgnoreCase("@RETURN_VALUE")) {
                        bl = true;
                        continue;
                    }
                }
                tDSRPCParameter = bl ? (TDSRPCParameter)this.userParameters.get(i - 2) : (TDSRPCParameter)this.userParameters.get(i - 1);
                tDSRPCParameter.initializeUserParam(i, baseParameters, this.sendStringParametersAsUnicode, this.receiveStringParameterType);
            }
        }
    }
}

