/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OJTASTARTEND;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OJTATRAN;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_ORPC;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.oracle.OracleXid;
import com.metamatrix.util.UtilDataConversions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.10.1.1  $";
    OracleImplConnection implConn;
    TTIOERDataPacket gTTIoer;
    TTIFUN_OJTASTARTEND ttifunStartEnd;
    TTIFUN_OJTATRAN ttifunTran;
    TTIFUN_ORPC ttifunRPC;
    OracleNet8NSPTDAPacket NSPTDAPacket;
    BaseConnectionProperties connectProps;
    int timeout;
    boolean localTxnIsAutoCommit;
    private byte[] context;
    Xid currentTxnXid = null;
    boolean recursiveMode = false;
    Vector suspendedXids = new Vector();
    static final short ERROR = 0;
    static final short INVALID_FLAG = 1;
    static final short INVALID_XID = 2;
    static final short INVALID_VERSION = 3;
    static final short TXN_NOT_ENDED = 4;
    static final short INVALID_TIMEOUT = 5;

    public OracleImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.getConnectProperties();
        this.timeout = 60;
        this.requiredLocalAutoCommit = 0;
        this.implConn = ((OracleConnection)baseConnection).oic;
        this.gTTIoer = new TTIOERDataPacket(this.implConn);
        this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.implConn.comm);
        this.ttifunStartEnd = new TTIFUN_OJTASTARTEND();
        this.ttifunTran = new TTIFUN_OJTATRAN();
        this.ttifunRPC = new TTIFUN_ORPC();
    }

    protected void reset() throws SQLException {
        if (this.currentTxnXid == null) {
            return;
        }
        this.saveAutoCommitMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block13: {
                if (n != 0 && n != 0x8000000 && n != 0x200000 && (n & 2) != 2) {
                    throw this.getXAException(1);
                }
                this.saveAutoCommitMode();
                try {
                    int n2 = 0;
                    switch (n) {
                        case 0: {
                            n2 = 1;
                            break;
                        }
                        case 0x200000: 
                        case 0x8000000: {
                            n2 = 4;
                        }
                    }
                    this.ttifunStartEnd.setInfo((byte)1, this.timeout, n2, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunStartEnd);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunStartEnd, this.gTTIoer);
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunStartEnd.xaRet = this.processError();
                    }
                    this.context = this.ttifunStartEnd.getContext();
                    this.setCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    this.resumeAutoCommitMode();
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block13;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (n == 0x8000000) {
                this.suspendedXids.remove(xid);
            }
            if (this.recursiveMode) {
                return;
            }
            this.checkError(this.ttifunStartEnd.xaRet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block14: {
                if (n != 0x4000000 && n != 0x2000000 && n != 0x20000000 && (n & 2) != 2) {
                    throw this.getXAException(1);
                }
                try {
                    if ((n == 0x4000000 || n == 0x20000000) && this.suspendedXids.contains(xid)) {
                        this.start(xid, 0x8000000);
                    }
                    this.clearCurrentTransaction(xid);
                    int n2 = 0;
                    switch (n) {
                        case 0x4000000: {
                            n2 = 0;
                            break;
                        }
                        case 0x2000000: 
                        case 0x20000000: {
                            n2 = 4;
                        }
                    }
                    this.ttifunStartEnd.setInfo((byte)2, this.timeout, n2, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunStartEnd);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunStartEnd, this.gTTIoer);
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunStartEnd.xaRet = this.processError();
                    }
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block14;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.recursiveMode) {
                return;
            }
            this.checkError(this.ttifunStartEnd.xaRet);
            this.resumeAutoCommitMode();
            if (n == 0x2000000) {
                this.suspendedXids.add(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block8: {
                try {
                    this.suspendCurrentTransaction(xid);
                    this.ttifunTran.setInfo((byte)3, this.timeout, 0, this.context, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunTran.xaRet = this.processError();
                    }
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block8;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.ttifunTran.xaRet == 24767 || this.ttifunTran.xaRet == 4) {
                return 3;
            }
            if (this.ttifunTran.xaRet == 1) {
                return 0;
            }
            this.checkError(this.ttifunTran.xaRet);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Xid xid, boolean bl) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl2;
            block12: {
                bl2 = false;
                try {
                    this.suspendCurrentTransaction(xid);
                    int n = bl ? 4 : 2;
                    this.ttifunTran.setInfo((byte)1, this.timeout, n, this.context, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.retCode == 24756 && this.xidIsInSecondaryOracleTable(xid)) {
                        n = 3;
                        this.ttifunTran.setInfo((byte)5, this.timeout, n, this.context, xid);
                        this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                        this.NSPTDAPacket.sendRequest();
                        this.NSPTDAPacket.receiveReply();
                        this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                        bl2 = true;
                        if (this.gTTIoer.retCode == 0) {
                            this.NSPTDAPacket.appendTTISubPacket(this.ttifunRPC);
                            this.NSPTDAPacket.sendRequest();
                            this.NSPTDAPacket.receiveReply();
                            this.implConn.processReply(this.ttifunRPC, this.gTTIoer);
                        }
                    }
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunTran.xaRet = this.processError();
                    }
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block12;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (bl) {
                if (this.ttifunTran.xaRet == 2 || this.ttifunTran.xaRet == 4 || this.ttifunTran.xaRet == 3 && bl2) {
                    return;
                }
            } else if (this.ttifunTran.xaRet == 5 || this.ttifunTran.xaRet == 3 && bl2) {
                return;
            }
            this.checkError(this.ttifunTran.xaRet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block9: {
                try {
                    this.suspendCurrentTransaction(xid);
                    int n = 3;
                    this.ttifunTran.setInfo((byte)2, this.timeout, n, this.context, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.retCode == 24756 && this.xidIsInSecondaryOracleTable(xid)) {
                        n = 0;
                        this.ttifunTran.setInfo((byte)5, this.timeout, n, this.context, xid);
                        this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                        this.NSPTDAPacket.sendRequest();
                        this.NSPTDAPacket.receiveReply();
                        this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                        if (this.gTTIoer.retCode == 0) {
                            this.NSPTDAPacket.appendTTISubPacket(this.ttifunRPC);
                            this.NSPTDAPacket.sendRequest();
                            this.NSPTDAPacket.receiveReply();
                            this.implConn.processReply(this.ttifunRPC, this.gTTIoer);
                        }
                    }
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunTran.xaRet = this.processError();
                    }
                    this.resumeCurrentTransaction(xid);
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block9;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
            if (this.ttifunTran.xaRet == 3) {
                return;
            }
            this.checkError(this.ttifunTran.xaRet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forget(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            block8: {
                try {
                    this.suspendCurrentTransaction(xid);
                    int n = 4;
                    this.ttifunStartEnd.setInfo((byte)1, this.timeout, n, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunStartEnd);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunStartEnd, this.gTTIoer);
                    if (this.gTTIoer.retCode != 24756) {
                        // empty if block
                    }
                    n = 2;
                    this.ttifunTran.setInfo((byte)5, this.timeout, n, this.context, xid);
                    this.NSPTDAPacket.appendTTISubPacket(this.ttifunTran);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.implConn.processReply(this.ttifunTran, this.gTTIoer);
                    if (this.gTTIoer.retCode != 0) {
                        this.ttifunTran.xaRet = this.processError();
                    }
                    this.resumeCurrentTransaction(xid);
                    if (this.ttifunTran.xaRet == 5) {
                        this.NSPTDAPacket.appendTTISubPacket(this.ttifunRPC);
                        this.NSPTDAPacket.sendRequest();
                        this.NSPTDAPacket.receiveReply();
                        this.implConn.processReply(this.ttifunRPC, this.gTTIoer);
                    }
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().regionMatches(false, 0, "08", 0, 2)) break block8;
                    XAException xAException = new XAException(sQLException.getMessage());
                    xAException.errorCode = -7;
                    throw xAException;
                }
            }
        }
    }

    protected Xid[] recover(int n) throws XAException {
        boolean bl = false;
        Xid[] xidArray = null;
        if (n != 0 && (n & 0x1000000) != 0x1000000 && (n & 0x800000) != 0x800000) {
            throw this.getXAException(1);
        }
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT count (*) FROM SYS.DBA_PENDING_TRANSACTIONS");
            resultSet.next();
            int n2 = resultSet.getInt(1);
            resultSet.close();
            xidArray = new Xid[n2];
            if (n2 == 0) {
                return xidArray;
            }
            int n3 = 0;
            resultSet = statement.executeQuery("SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS");
            while (resultSet.next()) {
                int n4 = resultSet.getInt(1);
                byte[] byArray = resultSet.getBytes(2);
                byte[] byArray2 = resultSet.getBytes(3);
                xidArray[n3] = new OracleXid(n4, byArray, byArray2);
                if (++n3 != n2) continue;
                break;
            }
            resultSet.close();
            statement.close();
            return xidArray;
        }
        catch (SQLException sQLException) {
            throw this.getXAException(0, sQLException.getMessage());
        }
    }

    boolean xidIsInSecondaryOracleTable(Xid xid) {
        try {
            Statement statement = this.connection.createStatement();
            StringBuffer stringBuffer = new StringBuffer(xid.getFormatId() + ".");
            byte[] byArray = xid.getGlobalTransactionId();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(UtilDataConversions.byteToHex((byte)byArray[i]).toUpperCase());
            }
            String string = "SELECT count (*) FROM SYS.DBA_2PC_PENDING WHERE GLOBAL_TRAN_ID = '" + stringBuffer + "'";
            ResultSet resultSet = statement.executeQuery(string);
            resultSet.next();
            int n = resultSet.getInt(1);
            resultSet.close();
            return n != 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    void saveAutoCommitMode() {
        if (this.recursiveMode) {
            return;
        }
        try {
            this.localTxnIsAutoCommit = this.connection.getAutoCommit();
            if (this.localTxnIsAutoCommit) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void resumeAutoCommitMode() {
        if (this.recursiveMode || !this.localTxnIsAutoCommit) {
            return;
        }
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setCurrentTransaction(Xid xid) {
        if (this.recursiveMode) {
            return;
        }
        this.currentTxnXid = xid;
    }

    void clearCurrentTransaction(Xid xid) {
        if (this.recursiveMode || this.currentTxnXid == null || !this.currentTxnXid.equals(xid)) {
            return;
        }
        this.currentTxnXid = null;
    }

    void suspendCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.end(this.currentTxnXid, 0x2000000);
        this.recursiveMode = false;
    }

    void resumeCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.start(this.currentTxnXid, 0x8000000);
        this.recursiveMode = false;
    }

    byte[] getSerializedBytes(Xid xid) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xid);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    int getVersionNumber(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " .", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n2 = Integer.decode(string2);
            n = n * 10 + n2;
            if (++n3 != 4) continue;
            break;
        }
        return n;
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw this.getXAException(5);
        }
        this.timeout = n;
        return true;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("SID");
        String string4 = this.connectProps.get("user");
        return string + "_" + string2 + "_" + string3 + "_" + string4;
    }

    int processError() throws SQLException {
        if (this.gTTIoer.retCode == 2091 || this.gTTIoer.retCode == 24756) {
            return this.gTTIoer.retCode;
        }
        String[] stringArray = new String[]{this.gTTIoer.errMsg};
        throw this.implConn.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
    }

    void checkError(int n) throws XAException {
        if (n == 0) {
            return;
        }
        int n2 = -3;
        Object var3_3 = null;
        switch (n & 0xFFFF) {
            case 2091: {
                n2 = 100;
                break;
            }
            case 24756: {
                n2 = -4;
                break;
            }
            case 25351: {
                n2 = 4;
                break;
            }
            case 24764: {
                n2 = 7;
                break;
            }
            case 24765: {
                n2 = 6;
                break;
            }
            case 24766: {
                n2 = 5;
                break;
            }
            case 24767: {
                n2 = 3;
                break;
            }
            case 3113: 
            case 3114: {
                n2 = -7;
                break;
            }
            case 24763: 
            case 24769: 
            case 24770: {
                n2 = -6;
            }
        }
        String[] stringArray = new String[]{Integer.toString(n)};
        XAException xAException = new XAException(this.exceptions.getException(7013, stringArray).getMessage());
        xAException.errorCode = n2;
        throw xAException;
    }

    XAException getXAException(int n) {
        return this.getXAException(n, null);
    }

    XAException getXAException(int n, String string) {
        XAException xAException;
        switch (n) {
            case 1: {
                xAException = new XAException(this.exceptions.getException(7014).getMessage());
                xAException.errorCode = -5;
                break;
            }
            case 2: {
                xAException = new XAException(this.exceptions.getException(7015).getMessage());
                xAException.errorCode = -6;
                break;
            }
            case 3: {
                xAException = new XAException(this.exceptions.getException(7016).getMessage());
                xAException.errorCode = -6;
                break;
            }
            case 4: {
                xAException = new XAException(this.exceptions.getException(7017).getMessage());
                xAException.errorCode = -3;
                break;
            }
            case 5: {
                xAException = new XAException(this.exceptions.getException(7018).getMessage());
                xAException.errorCode = -5;
            }
            default: {
                xAException = new XAException(string);
                xAException.errorCode = -3;
            }
        }
        return xAException;
    }
}

