/**
 * 
 */
package com.amentra.metamatrix.solr;

import java.util.Properties;

import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectionPool;

/**
 * Responsible for fetching SolrConnections.
 * @author Michael Walker
 */
public class SolrConnector implements Connector {
	private ConnectorLogger logger;
	private Properties props;
	private ConnectionPool pool;
	private SolrConnectionFactory solrConnFactory;

	/**
	 * Fetches a SolrConnection from the connection pool.
	 * @see com.metamatrix.data.api.Connector#getConnection(com.metamatrix.data.api.SecurityContext)
	 */
	
	public Connection getConnection(SecurityContext ctx)
			throws ConnectorException {
		if(pool != null){
			SolrConnection conn = (SolrConnection)pool.obtain(ctx);
			conn.setConnectionPool(pool);
			return conn;
		} else {
			throw new ConnectorException("Solr connection pool is not initialized properly. Cannot create a new connection.");
		}
	}

	/**
	 * Creates a connection pool of SolrConnections.
	 * @see com.metamatrix.data.api.Connector#initialize(com.metamatrix.data.api.ConnectorEnvironment)
	 */
	
	public void initialize(ConnectorEnvironment env)
			throws ConnectorException {
		logger = env.getLogger();
		props = env.getProperties();
		solrConnFactory = new SolrConnectionFactory(props, logger);
		solrConnFactory.initialize(env);
		
		pool = new ConnectionPool(solrConnFactory);
		pool.initialize(props);
	}

	/**
	 * Does nothing, since the pool of connections is initialized during initialize.
	 * @see com.metamatrix.data.api.Connector#start()
	 */
	
	public void start() throws ConnectorException {
		// TODO Auto-generated method stub


	}

	/**
	 * Stops the connection pool.
	 * @see com.metamatrix.data.api.Connector#stop()
	 */
	public void stop() {
		pool.shutDown();

	}

}
