package org.apache.camel.component.infinispan;

import java.io.IOException;

import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.client.hotrod.CustomEvent;
import org.junit.Test;

public class InfinispanRemoteAsyncConsumerConverterFactoryIT extends CamelTestSupport {
    @EndpointInject(uri = "mock:result")
    private MockEndpoint mockResult;

    protected RemoteCacheManager manager;

    @ClientListener(converterFactoryName = "static-converter-factory")
    protected static class MyCustomListener extends InfinispanRemoteCustomListener {
    }

    @Override
    protected void doPreSetup() throws IOException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(11222);
        manager = new RemoteCacheManager(builder.build());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        registry.bind("myCustomListener", new MyCustomListener());
        registry.bind("myCustomContainer", manager);
        return registry;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() {
                from("infinispan://?cacheContainer=#myCustomContainer&cacheName=static_converter_factory&customListener=#myCustomListener&sync=false")
                .to("mock:result");
            }
        };
    }

    @Test
    public void customEventConsumed() throws InterruptedException {
        mockResult.expectedMessageCount(2);

        int sameKey = 12345;
        getCache().put(sameKey, "aValue");
        getCache().remove(sameKey);

        mockResult.assertIsSatisfied();
        Exchange exchange = mockResult.getExchanges().get(1);
        Message out = exchange.getOut();

        /* The user needs to extract the key from the event data if available. */
        assertNull(out.getHeader(InfinispanConstants.KEY));

        Object eventData = out.getHeader(InfinispanConstants.EVENT_DATA);
        assertNotNull(eventData);
        assertTrue(eventData instanceof CustomEvent);
    }

    private RemoteCache<Object, Object> getCache() {
        return manager.getCache("static_converter_factory");
    }
}
