package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.annotations.Test;

import static org.infinispan.client.hotrod.test.HotRodClientTestingUtil.withRemoteCacheManager;
import static org.infinispan.server.hotrod.test.HotRodTestingUtil.hotRodCacheConfiguration;
import static org.infinispan.test.TestingUtil.detectThreadLeaks;

@Test(groups = "functional", testName = "client.hotrod.event.ClientListenerLeakTest")
public class ClientListenerLeakTest extends SingleHotRodServerTest {

   private String cacheName;

   @Override
   protected EmbeddedCacheManager createCacheManager() throws Exception {
      EmbeddedCacheManager cm = super.createCacheManager();
      ConfigurationBuilder cfg = hotRodCacheConfiguration();
      cacheName = this.getClass().getSimpleName();
      cm.defineConfiguration(cacheName, cfg.build());
      return cm;
   }

   @Override
   protected RemoteCacheManager getRemoteCacheManager() {
      org.infinispan.client.hotrod.configuration.ConfigurationBuilder builder =
            new org.infinispan.client.hotrod.configuration.ConfigurationBuilder();
      builder.addServer().host("127.0.0.1").port(hotrodServer.getPort());
      // A short socket timeout ensures quick detection of invalid transport when the socket is closed
      // so ClientListenerNotifier.EventDispatcher finishes quickly rather than linger on and be (wrongly) detected as a
      // leaking thread. The timeout should be shorter than the executor shutdown time in ClientListenerNotifier.stop().
      builder.socketTimeout(2000);
      return new InternalRemoteCacheManager(builder.build());
   }

   public void testNoLeaksAfterShutdown() {
      withRemoteCacheManager(new RemoteCacheManagerCallable(getRemoteCacheManager()) {
         @Override
         public void call() {
            RemoteCache<Integer, String> remote = rcm.getCache(cacheName);
            EventLogListener<Integer> eventListener = new EventLogListener<Integer>();
            remote.addClientListener(eventListener);
            eventListener.expectNoEvents();
            remote.put(1, "one");
            eventListener.expectOnlyCreatedEvent(1, cache(cacheName));
         }
      });
      detectThreadLeaks(".*Client-Listener-ClientListenerLeakTest-.*");
   }

}
