#!/bin/bash
HEIGHT=20
WIDTH=78
LISTHEIGHT=15

function check_cancel {
    if [ $? -ne 0 ]; then
        exit
    fi
}

# Check Kerberos credentials cache
function check_kerberos {
	klist -s
	if [ $? -eq 1 ]; then
		kinit
	fi
}

function mead_build {
	PROJECT=$(whiptail --title "JDG Builder" --menu "Project" 20 100 15 git://git.app.eng.bos.redhat.com/infinispan/infinispan.git Infinispan git://git.app.eng.bos.redhat.com/jdg-packaging.git JDG git://git.app.eng.bos.redhat.com/infinispan/protostream.git Protostream git://git.app.eng.bos.redhat.com/jdg/jdg-quickstart.git Quickstarts git://git.app.eng.bos.redhat.com/JGroups.git JGroups git://git.app.eng.bos.redhat.com/jboss-remoting/jboss-marshalling.git JBossMarshalling 3>&1 1>&2 2>&3)
	check_cancel
	HASH=$(whiptail --menu Branch/Tag 20 78 15 `git ls-remote $PROJECT | grep -i '[ej]dg'` 3>&1 1>&2 2>&3)
	check_cancel
	TARGET=$(whiptail --menu "Target" 20 78 15 jb-edg-6-jdk7-rhel-6 JDK7 jb-edg-6-rhel-6 JDK6 3>&1 1>&2 2>&3)
	check_cancel
	whiptail --yesno "Release build" 7 40
	if [ $? -eq 0 ]; then
		SCRATCH=""
	else
		SCRATCH="--scratch"
	fi
	run_brew $TARGET maven-build $SCRATCH --nowait -Pdistribution -Dmaven.test.skip.exec=true $TARGET-candidate $PROJECT#$HASH 
}


function brew_build {
	PROJECT=$(whiptail --title "JDG Builder" --menu "Project" 20 100 15 git://pkgs.devel.redhat.com/rpms/infinispan-cpp-client "C++/C# HotRod client"  3>&1 1>&2 2>&3)
	check_cancel
	HASH=$(whiptail --menu Branch/Tag 20 78 15 `git ls-remote $PROJECT | grep -i '[ej]dg'` 3>&1 1>&2 2>&3)
        check_cancel
	TARGET=`git ls-remote $PROJECT | grep $HASH| sed 's/^.*heads\///'`
        if [ $TARGET = jb-jdg-6-win ]; then
		BUILD_TYPE="win-build"
                BUILD_TYPE_ARGS="jdg-natives-20131125" 
	else
                BUILD_TYPE="build"
                BUILD_TYPE_ARGS=""
	fi
	whiptail --yesno "Release build" 7 40
        if [ $? -eq 0 ]; then
                SCRATCH=""
        else
                SCRATCH="--scratch"
        fi
	run_brew $TARGET $BUILD_TYPE $SCRATCH --nowait $TARGET-candidate $PROJECT#$HASH $BUILD_TYPE_ARGS 
}

function run_brew {
        TARGET=$1
	shift
	TEMPFILE=`mktemp`
        brew $@ > $TEMPFILE
        TASK_ID=`grep "Created task" $TEMPFILE |cut -f3 -d' '`
        rm -f $TEMPFILE
        brew watch-task $TASK_ID
        if [[ $? -eq 0 && $2 != '--scratch' ]]; then
                brew regen-repo $TARGET-build
        fi
}

check_kerberos
brewmead=$(whiptail --title "JDG Builder" --menu "Build type" 20 100 15 brew Brew mead MEAD 3>&1 1>&2 2>&3)
check_cancel
if [ "$brewmead" = "mead" ]; then
	mead_build
else
	brew_build
fi

