#!/bin/bash
HEIGHT=20
WIDTH=78
LISTHEIGHT=15

function check_cancel {
    if [ $? -ne 0 ]; then
        exit
    fi
}

# Check Kerberos credentials cache
klist -s
if [ $? -eq 1 ]; then
    kinit
fi

project=$(whiptail --title "JDG Builder" --menu "Project" 20 78 15 git://git.app.eng.bos.redhat.com/infinispan/infinispan.git Infinispan git://git.app.eng.bos.redhat.com/jdg-packaging.git JDG git://git.app.eng.bos.redhat.com/infinispan/protostream.git Protostream git://git.app.eng.bos.redhat.com/jdg/jdg-quickstart.git Quickstarts git://git.app.eng.bos.redhat.com/JGroups.git JGroups git://git.app.eng.bos.redhat.com/jboss-remoting/jboss-marshalling.git JBossMarshalling 3>&1 1>&2 2>&3)
check_cancel
hash=$(whiptail --menu Branch/Tag 20 78 15 `git ls-remote $project | grep -i jdg` 3>&1 1>&2 2>&3)
check_cancel
target=$(whiptail --menu "Target" 20 78 15 jb-edg-6-jdk7-rhel-6 JDK7 jb-edg-6-rhel-6 JDK6 3>&1 1>&2 2>&3)
check_cancel
brew maven-build -Pdistribution -DskipTests=true $target-candidate $project#$hash
brew regen-repo $target-build



