/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.interfaces.ConfigurableProvider;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class ImplicitlyCaTest
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});

    public void performTest() throws Exception {
        this.testBCAPI();
        this.testJDKAPI();
        this.testKeyFactory();
        this.testBasicThreadLocal();
    }

    private void testBCAPI() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = new org.bouncycastle.jce.spec.ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ConfigurableProvider configurableProvider = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        configurableProvider.setParameter("ecImplicitlyCa", eCParameterSpec);
        keyPairGenerator.initialize(null, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        this.testECDSA(eCPrivateKey, eCPublicKey);
        this.testBCParamsAndQ(eCPrivateKey, eCPublicKey);
        this.testEC5Params(eCPrivateKey, eCPublicKey);
        this.testEncoding(eCPrivateKey, eCPublicKey);
    }

    private void testKeyFactory() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = new org.bouncycastle.jce.spec.ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ConfigurableProvider configurableProvider = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        configurableProvider.setParameter("ecImplicitlyCa", eCParameterSpec);
        keyPairGenerator.initialize(null, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        eCPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(eCPublicKey.getQ(), null));
        eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(new ECPrivateKeySpec(eCPrivateKey.getD(), null));
        this.testECDSA(eCPrivateKey, eCPublicKey);
        this.testBCParamsAndQ(eCPrivateKey, eCPublicKey);
        this.testEC5Params(eCPrivateKey, eCPublicKey);
        this.testEncoding(eCPrivateKey, eCPublicKey);
        ECPublicKey eCPublicKey2 = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(eCPublicKey.getQ(), eCParameterSpec));
        ECPrivateKey eCPrivateKey2 = (ECPrivateKey)keyFactory.generatePrivate(new ECPrivateKeySpec(eCPrivateKey.getD(), eCParameterSpec));
        if (!eCPublicKey.equals(eCPublicKey2) || eCPublicKey.hashCode() != eCPublicKey2.hashCode()) {
            this.fail("private equals/hashCode failed");
        }
        if (!eCPrivateKey.equals(eCPrivateKey2) || eCPrivateKey.hashCode() != eCPrivateKey2.hashCode()) {
            this.fail("private equals/hashCode failed");
        }
    }

    private void testJDKAPI() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint(ellipticCurve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        ConfigurableProvider configurableProvider = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        configurableProvider.setParameter("ecImplicitlyCa", eCParameterSpec);
        keyPairGenerator.initialize(null, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        this.testECDSA(eCPrivateKey, eCPublicKey);
        this.testBCParamsAndQ(eCPrivateKey, eCPublicKey);
        this.testEC5Params(eCPrivateKey, eCPublicKey);
        this.testEncoding(eCPrivateKey, eCPublicKey);
    }

    private void testBasicThreadLocal() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint(ellipticCurve, Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
        ConfigurableProvider configurableProvider = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        configurableProvider.setParameter("threadLocalEcImplicitlyCa", eCParameterSpec);
        keyPairGenerator.initialize(null, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        this.testECDSA(eCPrivateKey, eCPublicKey);
        this.testBCParamsAndQ(eCPrivateKey, eCPublicKey);
        this.testEC5Params(eCPrivateKey, eCPublicKey);
        this.testEncoding(eCPrivateKey, eCPublicKey);
    }

    private void testECDSA(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        Signature signature = Signature.getInstance("ECDSA", "BC");
        signature.initSign(eCPrivateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("ECDSA", "BC");
        signature.initVerify(eCPublicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("ECDSA verification failed");
        }
    }

    private void testEncoding(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws Exception {
        ECPublicKey eCPublicKey2;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        ECPrivateKey eCPrivateKey2;
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        byte[] byArray = eCPrivateKey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(new ASN1InputStream(byArray).readObject());
        if (!privateKeyInfo.getAlgorithmId().getParameters().equals(DERNull.INSTANCE)) {
            this.fail("private key parameters wrong");
        }
        if (!(eCPrivateKey2 = (ECPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray))).equals(eCPrivateKey)) {
            this.fail("private equals failed");
        }
        if (eCPrivateKey2.hashCode() != eCPrivateKey.hashCode()) {
            this.fail("private hashCode failed");
        }
        if (!(subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(new ASN1InputStream(byArray = eCPublicKey.getEncoded()).readObject())).getAlgorithmId().getParameters().equals(DERNull.INSTANCE)) {
            this.fail("public key parameters wrong");
        }
        if (!(eCPublicKey2 = (ECPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(byArray))).equals(eCPublicKey) || eCPublicKey2.hashCode() != eCPublicKey.hashCode()) {
            this.fail("public equals/hashCode failed");
        }
        this.testBCParamsAndQ(eCPrivateKey2, eCPublicKey2);
        this.testEC5Params(eCPrivateKey2, eCPublicKey2);
        this.testECDSA(eCPrivateKey2, eCPublicKey2);
    }

    private void testBCParamsAndQ(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        if (eCPrivateKey.getParameters() != null) {
            this.fail("parameters exposed in private key");
        }
        if (eCPublicKey.getParameters() != null) {
            this.fail("parameters exposed in public key");
        }
        if (eCPublicKey.getQ().getCurve() != null) {
            this.fail("curve exposed in public point");
        }
    }

    private void testEC5Params(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        ECKey eCKey = (ECKey)((Object)eCPrivateKey);
        if (eCKey.getParams() != null) {
            this.fail("parameters exposed in private key");
        }
        if ((eCKey = (ECKey)((Object)eCPublicKey)).getParams() != null) {
            this.fail("parameters exposed in public key");
        }
    }

    public String getName() {
        return "ImplicitlyCA";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        ImplicitlyCaTest.runTest(new ImplicitlyCaTest());
    }
}

