/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.AttrCertTest;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509AttributeCertStoreSelector;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertPairStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.bouncycastle.x509.X509CertificatePair;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class X509StoreTest
extends SimpleTest {
    private void certPairTest() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CertificatePair x509CertificatePair = new X509CertificatePair(x509Certificate, x509Certificate2);
        ArrayList<X509CertificatePair> arrayList = new ArrayList<X509CertificatePair>();
        arrayList.add(x509CertificatePair);
        arrayList.add(new X509CertificatePair(x509Certificate2, x509Certificate3));
        X509CollectionStoreParameters x509CollectionStoreParameters = new X509CollectionStoreParameters(arrayList);
        X509Store x509Store = X509Store.getInstance("CertificatePair/Collection", (X509StoreParameters)x509CollectionStoreParameters, "BC");
        X509CertPairStoreSelector x509CertPairStoreSelector = new X509CertPairStoreSelector();
        X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setSerialNumber(x509Certificate.getSerialNumber());
        x509CertPairStoreSelector.setForwardSelector(x509CertStoreSelector);
        Collection collection = x509Store.getMatches(x509CertPairStoreSelector);
        if (collection.size() != 1 || !collection.contains(x509CertificatePair)) {
            this.fail("failed pair1 test");
        }
        if ((collection = x509Store.getMatches(null)).size() != 2) {
            this.fail("failed null test");
        }
    }

    public void performTest() throws Exception {
        Collection collection;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate3);
        X509CollectionStoreParameters x509CollectionStoreParameters = new X509CollectionStoreParameters(arrayList);
        X509Store x509Store = X509Store.getInstance("Certificate/Collection", (X509StoreParameters)x509CollectionStoreParameters, "BC");
        X509Principal.DefaultReverse = true;
        X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setSubject(PrincipalUtil.getSubjectX509Principal(x509Certificate).getEncoded());
        Collection collection2 = x509Store.getMatches(x509CertStoreSelector);
        if (collection2.size() != 1 || !collection2.contains(x509Certificate)) {
            this.fail("rootCert not found by subjectDN");
        }
        x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setSubject(PrincipalUtil.getSubjectX509Principal(x509Certificate).getEncoded());
        collection2 = x509Store.getMatches(x509CertStoreSelector);
        if (collection2.size() != 1 || !collection2.contains(x509Certificate)) {
            this.fail("rootCert not found by encoded subjectDN");
        }
        X509Principal.DefaultReverse = false;
        x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setSubjectPublicKey(x509Certificate.getPublicKey().getEncoded());
        collection2 = x509Store.getMatches(x509CertStoreSelector);
        if (collection2.size() != 1 || !collection2.contains(x509Certificate)) {
            this.fail("rootCert not found by encoded public key");
        }
        x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setIssuer(PrincipalUtil.getSubjectX509Principal(x509Certificate).getEncoded());
        collection2 = x509Store.getMatches(x509CertStoreSelector);
        if (collection2.size() != 2) {
            this.fail("did not found 2 certs");
        }
        if (!collection2.contains(x509Certificate)) {
            this.fail("rootCert not found");
        }
        if (!collection2.contains(x509Certificate2)) {
            this.fail("interCert not found");
        }
        ArrayList<X509CRL> arrayList2 = new ArrayList<X509CRL>();
        arrayList2.add(x509CRL);
        arrayList2.add(x509CRL2);
        x509CollectionStoreParameters = new X509CollectionStoreParameters(arrayList2);
        X509Store x509Store2 = X509Store.getInstance("CRL/Collection", (X509StoreParameters)x509CollectionStoreParameters, "BC");
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        x509CRLStoreSelector.setIssuers(Collections.singleton(x509CRL.getIssuerX500Principal()));
        Collection collection3 = x509Store2.getMatches(x509CRLStoreSelector);
        if (collection3.size() != 1 || !collection3.contains(x509CRL)) {
            this.fail("rootCrl not found");
        }
        if ((collection3 = x509Store.getMatches(x509CRLStoreSelector)).size() != 0) {
            this.fail("error using wrong selector (CRL)");
        }
        if ((collection2 = x509Store2.getMatches(x509CertStoreSelector)).size() != 0) {
            this.fail("error using wrong selector (certs)");
        }
        X509V2AttributeCertificate x509V2AttributeCertificate = new X509V2AttributeCertificate(AttrCertTest.attrCert);
        X509V2AttributeCertificate x509V2AttributeCertificate2 = new X509V2AttributeCertificate(AttrCertTest.certWithBaseCertificateID);
        ArrayList<X509V2AttributeCertificate> arrayList3 = new ArrayList<X509V2AttributeCertificate>();
        arrayList3.add(x509V2AttributeCertificate);
        arrayList3.add(x509V2AttributeCertificate2);
        x509CollectionStoreParameters = new X509CollectionStoreParameters(arrayList3);
        x509Store2 = X509Store.getInstance("AttributeCertificate/Collection", (X509StoreParameters)x509CollectionStoreParameters, "BC");
        X509AttributeCertStoreSelector x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setHolder(x509V2AttributeCertificate.getHolder());
        if (!x509AttributeCertStoreSelector.getHolder().equals(x509V2AttributeCertificate.getHolder())) {
            this.fail("holder get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on holder");
        }
        x509AttributeCertStoreSelector.setHolder(x509V2AttributeCertificate2.getHolder());
        if (x509AttributeCertStoreSelector.getHolder().equals(x509V2AttributeCertificate.getHolder())) {
            this.fail("holder get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate2)) {
            this.fail("attrCert2 not found on holder");
        }
        x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setIssuer(x509V2AttributeCertificate.getIssuer());
        if (!x509AttributeCertStoreSelector.getIssuer().equals(x509V2AttributeCertificate.getIssuer())) {
            this.fail("issuer get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on issuer");
        }
        x509AttributeCertStoreSelector.setIssuer(x509V2AttributeCertificate2.getIssuer());
        if (x509AttributeCertStoreSelector.getIssuer().equals(x509V2AttributeCertificate.getIssuer())) {
            this.fail("issuer get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate2)) {
            this.fail("attrCert2 not found on issuer");
        }
        x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setAttributeCert(x509V2AttributeCertificate);
        if (!x509AttributeCertStoreSelector.getAttributeCert().equals(x509V2AttributeCertificate)) {
            this.fail("attrCert get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on attrCert");
        }
        x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setSerialNumber(x509V2AttributeCertificate.getSerialNumber());
        if (!x509AttributeCertStoreSelector.getSerialNumber().equals(x509V2AttributeCertificate.getSerialNumber())) {
            this.fail("serial number get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on serial number");
        }
        if (!(x509AttributeCertStoreSelector = (X509AttributeCertStoreSelector)x509AttributeCertStoreSelector.clone()).getSerialNumber().equals(x509V2AttributeCertificate.getSerialNumber())) {
            this.fail("serial number get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on serial number");
        }
        x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setAttributeCertificateValid(x509V2AttributeCertificate.getNotBefore());
        if (!x509AttributeCertStoreSelector.getAttributeCertificateValid().equals(x509V2AttributeCertificate.getNotBefore())) {
            this.fail("valid get not correct");
        }
        if ((collection = x509Store2.getMatches(x509AttributeCertStoreSelector)).size() != 1 || !collection.contains(x509V2AttributeCertificate)) {
            this.fail("attrCert not found on valid");
        }
        x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.setAttributeCertificateValid(new Date(x509V2AttributeCertificate.getNotBefore().getTime() - 100L));
        collection = x509Store2.getMatches(x509AttributeCertStoreSelector);
        if (collection.size() != 0) {
            this.fail("attrCert found on before");
        }
        x509AttributeCertStoreSelector.setAttributeCertificateValid(new Date(x509V2AttributeCertificate.getNotAfter().getTime() + 100L));
        collection = x509Store2.getMatches(x509AttributeCertStoreSelector);
        if (collection.size() != 0) {
            this.fail("attrCert found on after");
        }
        x509AttributeCertStoreSelector.setSerialNumber(BigInteger.valueOf(10000L));
        collection = x509Store2.getMatches(x509AttributeCertStoreSelector);
        if (collection.size() != 0) {
            this.fail("attrCert found on wrong serial number");
        }
        x509AttributeCertStoreSelector.setAttributeCert(null);
        x509AttributeCertStoreSelector.setAttributeCertificateValid(null);
        x509AttributeCertStoreSelector.setHolder(null);
        x509AttributeCertStoreSelector.setIssuer(null);
        x509AttributeCertStoreSelector.setSerialNumber(null);
        if (x509AttributeCertStoreSelector.getAttributeCert() != null) {
            this.fail("null attrCert");
        }
        if (x509AttributeCertStoreSelector.getAttributeCertificateValid() != null) {
            this.fail("null attrCertValid");
        }
        if (x509AttributeCertStoreSelector.getHolder() != null) {
            this.fail("null attrCert holder");
        }
        if (x509AttributeCertStoreSelector.getIssuer() != null) {
            this.fail("null attrCert issuer");
        }
        if (x509AttributeCertStoreSelector.getSerialNumber() != null) {
            this.fail("null attrCert serial");
        }
        if ((collection = x509Store.getMatches(x509AttributeCertStoreSelector)).size() != 0) {
            this.fail("error using wrong selector (attrs)");
        }
        this.certPairTest();
    }

    public String getName() {
        return "X509Store";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        X509StoreTest.runTest(new X509StoreTest());
    }
}

