/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PKCS10CertRequestTest
extends SimpleTest {
    private byte[] gost3410EC_A = Base64.decode("MIIBOzCB6wIBADB/MQ0wCwYDVQQDEwR0ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiMBBgcqhQMCAh4BA0MABEBYx0P2D7YuuZo5HgdIAUKAXcLBDZ+4LYFgbKjrfStVfH59lc40BQ2FZ7M703hLpXK8GiBQGEYpKaAuQZnMIpByoAAwCAYGKoUDAgIDA0EAgXMcTrhdOY2Er2tHOSAgnMezqrYxocZTWhxmW5RlJY6lbXH5rndCn4swFzXU+YhgAsJv1wQBaoZEWRl5WV4/nA==");
    private byte[] gost3410EC_B = Base64.decode("MIIBPTCB7QIBADCBgDENMAsGA1UEAxMEdGVzdDEWMBQGA1UEChMNRGVtb3MgQ28gTHRkLjEeMBwGA1UECxMVQ3J5cHRvZ3JhcGh5IGRpdmlzaW9uMQ8wDQYDVQQHEwZNb3Njb3cxCzAJBgNVBAYTAnJ1MRkwFwYJKoZIhvcNAQkBFgpzZGJAZG9sLnJ1MGMwHAYGKoUDAgITMBIGByqFAwICIwIGByqFAwICHgEDQwAEQI5SLoWT7dZVilbV9j5B/fyIDuDs6x4pjqNC2TtFYbpRHrk/Wc5g/mcHvD80tsm5o1C77cizNzkvAVUM4VT4Dz6gADAIBgYqhQMCAgMDQQAoT5TwJ8o+bSrxckymyo3diwG7ZbSytX4sRiKywXPWRS9LlBvPO2NqwpS2HUnxSU8rzfL9fJcybATf7Yt1OEVq");
    private byte[] gost3410EC_C = Base64.decode("MIIBRDCB9AIBADCBhzEVMBMGA1UEAxMMdGVzdCByZXF1ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiMDBgcqhQMCAh4BA0MABEBcmGh7OmR4iqqj+ycYo1S1fS7r5PhisSQU2Ezuz8wmmmR2zeTZkdMYCOBaUTMNms0msW3wuYDho7nTDNscHTB5oAAwCAYGKoUDAgIDA0EAVoOMbfyo1Un4Ss7WQrUjHJoiaYW8Ime5LeGGU2iW3ieAv6es/FdMrwTKkqn5dhd3aL/itFg5oQbhyfXw5yw/QQ==");
    private byte[] gost3410EC_ExA = Base64.decode("MIIBOzCB6wIBADB/MQ0wCwYDVQQDEwR0ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiQABgcqhQMCAh4BA0MABEDkqNT/3f8NHj6EUiWnK4JbVZBh31bEpkwq9z3jf0u8ZndG56Vt+K1ZB6EpFxLT7hSIos0wweZ2YuTZ4w43OgodoAAwCAYGKoUDAgIDA0EASk/IUXWxoi6NtcUGVF23VRV1L3undB4sRZLp4VhogQ7m3CMbZFfJ2cPu6QyarseXGYHmazoirH5lGjEo535c1g==");
    private byte[] gost3410EC_ExB = Base64.decode("MIIBPTCB7QIBADCBgDENMAsGA1UEAxMEdGVzdDEWMBQGA1UEChMNRGVtb3MgQ28gTHRkLjEeMBwGA1UECxMVQ3J5cHRvZ3JhcGh5IGRpdmlzaW9uMQ8wDQYDVQQHEwZNb3Njb3cxCzAJBgNVBAYTAnJ1MRkwFwYJKoZIhvcNAQkBFgpzZGJAZG9sLnJ1MGMwHAYGKoUDAgITMBIGByqFAwICJAEGByqFAwICHgEDQwAEQMBWYUKPy/1Kxad9ChAmgoSWSYOQxRnXo7KEGLU5RNSXA4qMUvArWzvhav+EYUfTbWLh09nELDyHt2XQcvgQHnSgADAIBgYqhQMCAgMDQQAdaNhgH/ElHp64mbMaEo1tPCg9Q22McxpH8rCzE0QBpF4H5mSSQVGI5OAXHToetnNuh7gHHSynyCupYDEHTbkZ");

    public String getName() {
        return "PKCS10CertRequest";
    }

    private void generationTest(int n, String string, String string2, String string3) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, "BC");
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
        hashtable.put(X509Principal.C, "AU");
        hashtable.put(X509Principal.O, "The Legion of the Bouncy Castle");
        hashtable.put(X509Principal.L, "Melbourne");
        hashtable.put(X509Principal.ST, "Victoria");
        hashtable.put(X509Principal.EmailAddress, "feedback-crypto@bouncycastle.org");
        X509Name x509Name = new X509Name(hashtable);
        PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(string2, x509Name, keyPair.getPublic(), null, keyPair.getPrivate(), string3);
        byte[] byArray = pKCS10CertificationRequest.getEncoded();
        PKCS10CertificationRequest pKCS10CertificationRequest2 = new PKCS10CertificationRequest(byArray);
        if (!pKCS10CertificationRequest2.verify(string3)) {
            this.fail(string2 + ": Failed verify check.");
        }
        if (!pKCS10CertificationRequest2.getPublicKey(string3).equals(pKCS10CertificationRequest.getPublicKey(string3))) {
            this.fail(string + ": Failed public key check.");
        }
    }

    private void createECRequest(String string, DERObjectIdentifier dERObjectIdentifier) throws Exception {
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151"), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", 16), new BigInteger("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, fp.decodePoint(Hex.decode("02C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66")), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 16));
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("5769183828869504557786041598510887460263120754767955773309066354712783118202294874205844512909370791582896372147797293913785865682804434049019366394746072023"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(fp.decodePoint(Hex.decode("026BFDD2C9278B63C92D6624F151C9D7A822CC75BD983B17D25D74C26740380022D3D8FAF304781E416175EADF4ED6E2B47142D2454A7AC7801DD803CF44A4D1F0AC")), eCParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(string, new X509Name("CN=XXX"), publicKey, null, privateKey);
        if (!pKCS10CertificationRequest.verify()) {
            this.fail("Failed verify check EC.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(pKCS10CertificationRequest.getEncoded())).verify()) {
            this.fail("Failed verify check EC encoded.");
        }
        ((ECPointEncoder)((Object)publicKey)).setPointFormat("UNCOMPRESSED");
        pKCS10CertificationRequest = new PKCS10CertificationRequest(string, new X509Name("CN=XXX"), publicKey, null, privateKey);
        if (!pKCS10CertificationRequest.verify()) {
            this.fail("Failed verify check EC uncompressed.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(pKCS10CertificationRequest.getEncoded())).verify()) {
            this.fail("Failed verify check EC uncompressed encoded.");
        }
        if (!pKCS10CertificationRequest.getSignatureAlgorithm().getObjectId().equals(dERObjectIdentifier)) {
            this.fail("ECDSA oid incorrect.");
        }
        if (pKCS10CertificationRequest.getSignatureAlgorithm().getParameters() != null) {
            this.fail("ECDSA parameters incorrect.");
        }
        Signature signature = Signature.getInstance(string, "BC");
        signature.initVerify(publicKey);
        signature.update(pKCS10CertificationRequest.getCertificationRequestInfo().getEncoded());
        if (!signature.verify(pKCS10CertificationRequest.getSignature().getBytes())) {
            this.fail("signature not mapped correctly.");
        }
    }

    private void createECGOSTRequest() throws Exception {
        String string = "GOST3411withECGOST3410";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        keyPairGenerator.initialize(ECGOST3410NamedCurveTable.getParameterSpec("GostR3410-2001-CryptoPro-A"), new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(string, new X509Name("CN=XXX"), publicKey, null, privateKey);
        if (!pKCS10CertificationRequest.verify()) {
            this.fail("Failed verify check EC.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(pKCS10CertificationRequest.getEncoded())).verify()) {
            this.fail("Failed verify check EC encoded.");
        }
        if (!pKCS10CertificationRequest.getSignatureAlgorithm().getObjectId().equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001)) {
            this.fail("ECGOST oid incorrect.");
        }
        if (pKCS10CertificationRequest.getSignatureAlgorithm().getParameters() != null) {
            this.fail("ECGOST parameters incorrect.");
        }
        Signature signature = Signature.getInstance(string, "BC");
        signature.initVerify(publicKey);
        signature.update(pKCS10CertificationRequest.getCertificationRequestInfo().getEncoded());
        if (!signature.verify(pKCS10CertificationRequest.getSignature().getBytes())) {
            this.fail("signature not mapped correctly.");
        }
    }

    private void createPSSTest(String string) throws Exception {
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("a56e4a0e701017589a5187dc7ea841d156f2ec0e36ad52a44dfeb1e61f7ad991d8c51056ffedb162b4c0f283a12a88a394dff526ab7291cbb307ceabfce0b1dfd5cd9508096d5b2b8b6df5d671ef6377c0921cb23c270a70e2598e6ff89d19f105acc2d3f0cb35f29280e1386b6f64c4ef22e1e1f20d0ce8cffb2249bd9a2137", 16), new BigInteger("010001", 16));
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger("a56e4a0e701017589a5187dc7ea841d156f2ec0e36ad52a44dfeb1e61f7ad991d8c51056ffedb162b4c0f283a12a88a394dff526ab7291cbb307ceabfce0b1dfd5cd9508096d5b2b8b6df5d671ef6377c0921cb23c270a70e2598e6ff89d19f105acc2d3f0cb35f29280e1386b6f64c4ef22e1e1f20d0ce8cffb2249bd9a2137", 16), new BigInteger("010001", 16), new BigInteger("33a5042a90b27d4f5451ca9bbbd0b44771a101af884340aef9885f2a4bbe92e894a724ac3c568c8f97853ad07c0266c8c6a3ca0929f1e8f11231884429fc4d9ae55fee896a10ce707c3ed7e734e44727a39574501a532683109c2abacaba283c31b4bd2f53c3ee37e352cee34f9e503bd80c0622ad79c6dcee883547c6a3b325", 16), new BigInteger("e7e8942720a877517273a356053ea2a1bc0c94aa72d55c6e86296b2dfc967948c0a72cbccca7eacb35706e09a1df55a1535bd9b3cc34160b3b6dcd3eda8e6443", 16), new BigInteger("b69dca1cf7d4d7ec81e75b90fcca874abcde123fd2700180aa90479b6e48de8d67ed24f9f19d85ba275874f542cd20dc723e6963364a1f9425452b269a6799fd", 16), new BigInteger("28fa13938655be1f8a159cbaca5a72ea190c30089e19cd274a556f36c4f6e19f554b34c077790427bbdd8dd3ede2448328f385d81b30e8e43b2fffa027861979", 16), new BigInteger("1a8b38f398fa712049898d7fb79ee0a77668791299cdfa09efc0e507acb21ed74301ef5bfd48be455eaeb6e1678255827580a8e4e8e14151d1510a82a3f2e729", 16), new BigInteger("27156aba4126d24a81f3a528cbfb27f56886f840a9f6e86e17a44b94fe9319584b8e22fdde1e5a2e3bd8aa5ba8d8584194eb2190acf832b847f13a3d24a79f4d", 16));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(string, new X509Name("CN=XXX"), publicKey, null, privateKey);
        if (!pKCS10CertificationRequest.verify()) {
            this.fail("Failed verify check PSS.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(pKCS10CertificationRequest.getEncoded())).verify()) {
            this.fail("Failed verify check PSS encoded.");
        }
        if (!pKCS10CertificationRequest.getSignatureAlgorithm().getObjectId().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            this.fail("PSS oid incorrect.");
        }
        if (pKCS10CertificationRequest.getSignatureAlgorithm().getParameters() == null) {
            this.fail("PSS parameters incorrect.");
        }
        Signature signature = Signature.getInstance(string, "BC");
        signature.initVerify(publicKey);
        signature.update(pKCS10CertificationRequest.getCertificationRequestInfo().getEncoded());
        if (!signature.verify(pKCS10CertificationRequest.getSignature().getBytes())) {
            this.fail("signature not mapped correctly.");
        }
    }

    public void performTest() throws Exception {
        PKCS10CertificationRequest pKCS10CertificationRequest;
        this.generationTest(512, "RSA", "SHA1withRSA", "BC");
        this.generationTest(512, "GOST3410", "GOST3411withGOST3410", "BC");
        if (Security.getProvider("SunRsaSign") != null) {
            this.generationTest(512, "RSA", "SHA1withRSA", "SunRsaSign");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(this.gost3410EC_A)).verify()) {
            this.fail("Failed verify check gost3410EC_A.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(this.gost3410EC_B)).verify()) {
            this.fail("Failed verify check gost3410EC_B.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(this.gost3410EC_C)).verify()) {
            this.fail("Failed verify check gost3410EC_C.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(this.gost3410EC_ExA)).verify()) {
            this.fail("Failed verify check gost3410EC_ExA.");
        }
        if (!(pKCS10CertificationRequest = new PKCS10CertificationRequest(this.gost3410EC_ExB)).verify()) {
            this.fail("Failed verify check gost3410EC_ExA.");
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        pKCS10CertificationRequest = new PKCS10CertificationRequest("ECDSAWITHSHA1", new X509Name("CN=XXX"), keyPair.getPublic(), null, keyPair.getPrivate());
        if (!pKCS10CertificationRequest.verify()) {
            this.fail("Failed verify check EC.");
        }
        this.createECRequest("SHA1withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        this.createECRequest("SHA224withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        this.createECRequest("SHA256withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        this.createECRequest("SHA384withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        this.createECRequest("SHA512withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        this.createECGOSTRequest();
        this.createPSSTest("SHA1withRSAandMGF1");
        this.createPSSTest("SHA224withRSAandMGF1");
        this.createPSSTest("SHA256withRSAandMGF1");
        this.createPSSTest("SHA384withRSAandMGF1");
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        PKCS10CertRequestTest.runTest(new PKCS10CertRequestTest());
    }
}

