/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class IESTest
extends SimpleTest {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);

    IESTest() {
    }

    public String getName() {
        return "IES";
    }

    public void performTest() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        Cipher cipher = Cipher.getInstance("ECIES", "BC");
        Cipher cipher2 = Cipher.getInstance("ECIES", "BC");
        this.doTest(keyPairGenerator, cipher, cipher2);
        keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
        keyPairGenerator.initialize(192, new SecureRandom());
        this.doTest(keyPairGenerator, cipher, cipher2);
        keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
        keyPairGenerator.initialize(239, new SecureRandom());
        this.doTest(keyPairGenerator, cipher, cipher2);
        keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
        keyPairGenerator.initialize(256, new SecureRandom());
        this.doTest(keyPairGenerator, cipher, cipher2);
        this.doDefTest(keyPairGenerator, cipher, cipher2);
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.p512, this.g512);
        cipher = Cipher.getInstance("IES", "BC");
        cipher2 = Cipher.getInstance("IES", "BC");
        keyPairGenerator = KeyPairGenerator.getInstance("DH", "BC");
        keyPairGenerator.initialize(dHParameterSpec);
        this.doTest(keyPairGenerator, cipher, cipher2);
        this.doDefTest(keyPairGenerator, cipher, cipher2);
    }

    public void doTest(KeyPairGenerator keyPairGenerator, Cipher cipher, Cipher cipher2) throws Exception {
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        PublicKey publicKey2 = keyPair2.getPublic();
        PrivateKey privateKey2 = keyPair2.getPrivate();
        IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
        IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameterSpec iESParameterSpec = new IESParameterSpec(byArray, byArray2, 128);
        cipher.init(1, (Key)iEKeySpec, iESParameterSpec);
        cipher2.init(2, (Key)iEKeySpec2, iESParameterSpec);
        byte[] byArray3 = Hex.decode("1234567890abcdef");
        byte[] byArray4 = cipher.doFinal(byArray3, 0, byArray3.length);
        byte[] byArray5 = cipher2.doFinal(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("stream cipher test failed");
        }
    }

    public void doDefTest(KeyPairGenerator keyPairGenerator, Cipher cipher, Cipher cipher2) throws Exception {
        int n;
        int n2;
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        PublicKey publicKey2 = keyPair2.getPublic();
        PrivateKey privateKey2 = keyPair2.getPrivate();
        IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
        IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
        cipher.init(1, iEKeySpec);
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        cipher2.init(2, (Key)iEKeySpec2, algorithmParameters);
        byte[] byArray = Hex.decode("1234567890abcdef");
        byte[] byArray2 = cipher.doFinal(byArray, 0, byArray.length);
        byte[] byArray3 = cipher2.doFinal(byArray2, 0, byArray2.length);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("stream cipher test failed");
        }
        if ((n2 = cipher.doFinal(byArray, 0, byArray.length, byArray2, 0)) != byArray2.length) {
            this.fail("encryption length wrong");
        }
        if ((n = cipher2.doFinal(byArray2, 0, byArray2.length, byArray3, 0)) != byArray3.length) {
            this.fail("decryption length wrong");
        }
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("stream cipher test failed");
        }
        n2 = cipher.update(byArray, 0, 2, byArray2, 0);
        if ((n2 += cipher.doFinal(byArray, 2, byArray.length - 2, byArray2, n2)) != byArray2.length) {
            this.fail("update encryption length wrong");
        }
        n = cipher2.update(byArray2, 0, 2, byArray3, 0);
        if ((n += cipher2.doFinal(byArray2, 2, byArray2.length - 2, byArray3, n)) != byArray3.length) {
            this.fail("update decryption length wrong");
        }
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("update stream cipher test failed");
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        IESTest.runTest(new IESTest());
    }
}

