/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestFailedException;

public abstract class BaseBlockCipherTest
extends SimpleTest {
    String algorithm;

    BaseBlockCipherTest(String string) {
        this.algorithm = string;
    }

    public String getName() {
        return this.algorithm;
    }

    protected void oidTest(String[] stringArray, String[] stringArray2, int n) throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        for (int i = 0; i != stringArray.length; ++i) {
            Cipher cipher = Cipher.getInstance(stringArray[i], "BC");
            Cipher cipher2 = Cipher.getInstance(stringArray2[i], "BC");
            KeyGenerator keyGenerator = KeyGenerator.getInstance(stringArray[i], "BC");
            SecretKey secretKey = keyGenerator.generateKey();
            if (stringArray2[i].indexOf("/ECB/") > 0) {
                cipher.init(1, secretKey);
                cipher2.init(2, secretKey);
            } else {
                cipher.init(1, (Key)secretKey, ivParameterSpec);
                cipher2.init(2, (Key)secretKey, ivParameterSpec);
            }
            byte[] byArray2 = cipher2.doFinal(cipher.doFinal(byArray));
            if (!this.areEqual(byArray, byArray2)) {
                this.fail("failed OID test");
            }
            if (secretKey.getEncoded().length == 16 + i / n * 8) continue;
            this.fail("failed key length test");
        }
    }

    protected void wrapOidTest(String[] stringArray, String string) throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        for (int i = 0; i != stringArray.length; ++i) {
            Cipher cipher = Cipher.getInstance(stringArray[i], "BC");
            Cipher cipher2 = Cipher.getInstance(string, "BC");
            KeyGenerator keyGenerator = KeyGenerator.getInstance(stringArray[i], "BC");
            SecretKey secretKey = keyGenerator.generateKey();
            cipher.init(3, secretKey);
            cipher2.init(4, secretKey);
            Key key = cipher2.unwrap(cipher.wrap(new SecretKeySpec(byArray, this.algorithm)), this.algorithm, 3);
            if (!this.areEqual(byArray, key.getEncoded())) {
                this.fail("failed wrap OID test");
            }
            if (secretKey.getEncoded().length == 16 + i * 8) continue;
            this.fail("failed key length test");
        }
    }

    protected void wrapTest(int n, String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        Object object;
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(3, new SecretKeySpec(byArray, this.algorithm));
        try {
            object = cipher.wrap(new SecretKeySpec(byArray2, this.algorithm));
            if (!this.areEqual((byte[])object, byArray3)) {
                this.fail("failed wrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode((byte[])object)));
            }
        }
        catch (TestFailedException testFailedException) {
            throw testFailedException;
        }
        catch (Exception exception) {
            this.fail("failed wrap test exception " + exception.toString(), exception);
        }
        cipher.init(4, new SecretKeySpec(byArray, this.algorithm));
        try {
            object = cipher.unwrap(byArray3, this.algorithm, 3);
            if (!this.areEqual(object.getEncoded(), byArray2)) {
                this.fail("failed unwrap test " + n + " expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(object.getEncoded())));
            }
        }
        catch (Exception exception) {
            this.fail("failed unwrap test exception " + exception.toString(), exception);
        }
    }
}

