/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jmx;

import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAService;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.EventFacility;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.jmx.HAServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHAServiceMBeanSupport<S extends HAService<Notification>>
extends ServiceMBeanSupport
implements HAServiceMBean,
HAService<Notification>,
EventFactory<Notification>,
EventFacility<Notification> {
    private final S service = this.createHAService();
    private ClusterPartitionMBean clusterPartition;
    private volatile boolean sendLocalLifecycleNotifications = true;
    private volatile boolean sendRemoteLifecycleNotifications = true;

    protected abstract S createHAService();

    protected final S getHAService() {
        return this.service;
    }

    public HAPartition getHAPartition() {
        return this.service.getHAPartition();
    }

    @Override
    public void setHAPartition(HAPartition partition) {
        this.service.setHAPartition(partition);
    }

    @Override
    public void setClusterPartition(ClusterPartitionMBean clusterPartition) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.clusterPartition = clusterPartition;
        }
    }

    @Override
    public String getPartitionName() {
        return this.service.getHAPartition().getPartitionName();
    }

    public boolean isRegisterThreadContextClassLoader() {
        return this.service.isRegisterThreadContextClassLoader();
    }

    public void setRegisterThreadContextClassLoader(boolean register) {
        this.service.setRegisterThreadContextClassLoader(register);
    }

    public String getHAServiceKey() {
        return this.service.getHAServiceKey();
    }

    @Override
    public void setDistributedState(String key, Serializable value) throws Exception {
        DistributedState ds = this.getHAPartition().getDistributedStateService();
        ds.set(this.getHAServiceKey(), (Serializable)((Object)key), value);
    }

    @Override
    public Serializable getDistributedState(String key) {
        DistributedState ds = this.getHAPartition().getDistributedStateService();
        return ds.get(this.getHAServiceKey(), (Serializable)((Object)key));
    }

    protected void createService() throws Exception {
        this.service.create();
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"start HAServiceMBeanSupport");
        this.setupPartition();
        if (this.getHAPartition() == null) {
            throw new IllegalStateException("HAPartition property must be set before starting HAServiceMBeanSupport");
        }
        if (this.service.getServiceHAName() == null) {
            ObjectName name = this.getServiceName();
            if (name != null) {
                this.service.setServiceHAName(name.getCanonicalName());
            } else {
                throw new IllegalStateException("Cannot determine ServiceHAName for " + this.getClass().getName() + "; either set it explicitly " + "or register this object in JMX before calling create");
            }
        }
        this.service.start();
    }

    protected void stopService() throws Exception {
        this.log.debug((Object)"stop HAServiceMBeanSupport");
        this.service.stop();
    }

    protected void destroyService() throws Exception {
        this.service.destroy();
    }

    protected void setupPartition() throws Exception {
        if (this.clusterPartition != null) {
            this.service.setHAPartition(this.clusterPartition.getHAPartition());
        }
    }

    @Override
    public List callMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        return this.getHAPartition().callMethodOnCluster(this.getHAServiceKey(), methodName, args, types, true);
    }

    protected void callAsyncMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        this.getHAPartition().callAsynchMethodOnCluster(this.getHAServiceKey(), methodName, args, types, true);
    }

    public boolean getSendLocalLifecycleNotifications() {
        return this.sendLocalLifecycleNotifications;
    }

    public void setSendLocalLifecycleNotifications(boolean sendLocalLifecycleNotifications) {
        this.sendLocalLifecycleNotifications = sendLocalLifecycleNotifications;
    }

    public boolean getSendRemoteLifecycleNotifications() {
        return this.sendRemoteLifecycleNotifications;
    }

    public void setSendRemoteLifecycleNotifications(boolean sendRemoteLifecycleNotifications) {
        this.sendRemoteLifecycleNotifications = sendRemoteLifecycleNotifications;
    }

    @Override
    public void sendNotification(Notification notification) {
        boolean stateChange;
        boolean bl = stateChange = notification instanceof AttributeChangeNotification ? "State".equals(((AttributeChangeNotification)notification).getAttributeName()) : false;
        if (!stateChange || this.sendRemoteLifecycleNotifications) {
            try {
                this.sendNotificationRemote(notification);
            }
            catch (Throwable e) {
                this.log.warn((Object)("handleNotification( " + notification + " ) failed "), e);
            }
        }
        if (!stateChange || this.sendLocalLifecycleNotifications) {
            this.sendNotificationToLocalListeners(notification);
        }
    }

    protected void sendNotificationRemote(Notification notification) throws Exception {
        notification.setSource(this.getServiceName());
        this.service.handleEvent((EventObject)notification);
    }

    protected void sendNotificationToLocalListeners(Notification notification) {
        this.notifyListeners(notification);
    }

    public void notifyListeners(Notification notification) {
        super.sendNotification(notification);
    }

    public void handleEvent(Notification notification) throws Exception {
        this.notifyListeners(notification);
    }

    public Notification createEvent(Object source, String type) {
        return new Notification(type, this, this.getNextNotificationSequenceNumber());
    }

    public String getServiceHAName() {
        return this.service.getServiceHAName();
    }

    @Inject(fromContext=FromContext.NAME)
    public void setServiceHAName(String haName) {
        this.service.setServiceHAName(haName);
    }
}

