/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.impl.PacketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBindingQueryResponseMessage
extends PacketImpl {
    private boolean exists;
    private List<SimpleString> queueNames;

    public SessionBindingQueryResponseMessage(boolean exists, List<SimpleString> queueNames) {
        super((byte)50);
        this.exists = exists;
        this.queueNames = queueNames;
    }

    public SessionBindingQueryResponseMessage() {
        super((byte)50);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isExists() {
        return this.exists;
    }

    public List<SimpleString> getQueueNames() {
        return this.queueNames;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeBoolean(this.exists);
        buffer.writeInt(this.queueNames.size());
        for (SimpleString queueName : this.queueNames) {
            buffer.writeSimpleString(queueName);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.exists = buffer.readBoolean();
        int numQueues = buffer.readInt();
        this.queueNames = new ArrayList<SimpleString>(numQueues);
        for (int i = 0; i < numQueues; ++i) {
            this.queueNames.add(buffer.readSimpleString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SessionBindingQueryResponseMessage)) {
            return false;
        }
        SessionBindingQueryResponseMessage r = (SessionBindingQueryResponseMessage)other;
        if (!super.equals(other) || this.exists != r.exists) return false;
        if (this.queueNames.size() != r.queueNames.size()) return false;
        for (int i = 0; i < this.queueNames.size(); ++i) {
            if (this.queueNames.get(i).equals(r.queueNames.get(i))) continue;
            return false;
        }
        return true;
    }
}

