/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Queue;
import javax.jms.Topic;
import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.impl.JMSConfigurationImpl;
import org.hornetq.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.hornetq.jms.server.config.impl.TopicConfigurationImpl;
import org.jboss.as.integration.hornetq.deployers.DeploymentFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.CreateDestinationFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationFactoryDeployerPlugin
implements CreateDestinationFactory {
    private static final Logger log = Logger.getLogger(DestinationFactoryDeployerPlugin.class);
    private JMSServerManager jmsManager;
    private AtomicInteger counter = new AtomicInteger(0);

    public JMSServerManager getJmsManager() {
        return this.jmsManager;
    }

    public void setJmsManager(JMSServerManager jmsManager) {
        this.jmsManager = jmsManager;
    }

    public Object create(DeploymentUnit unit, JBossMessageDrivenBeanMetaData mdb) throws DeploymentException {
        ActivationConfigPropertiesMetaData properties;
        String destinationName = null;
        String destinationType = null;
        ActivationConfigMetaData activationConfig = mdb.getActivationConfig();
        if (activationConfig != null && (properties = activationConfig.getActivationConfigProperties()) != null) {
            destinationName = DestinationFactoryDeployerPlugin.getActivationConfigProperty(properties, "destination");
            destinationType = DestinationFactoryDeployerPlugin.getActivationConfigProperty(properties, "destinationType");
        }
        if (destinationName == null) {
            destinationName = mdb.getDestinationJndiName();
        }
        log.info((Object)("Deploying destination " + destinationName));
        if (destinationName == null || destinationName.trim().length() == 0) {
            log.warn((Object)("Unable to determine destination for " + mdb.getName()));
            return false;
        }
        boolean isTopic = false;
        JMSConfigurationImpl config = new JMSConfigurationImpl();
        String noSlashesName = destinationName.substring(destinationName.lastIndexOf(47) + 1);
        if (destinationType == null) {
            log.warn((Object)("Unable to determine destination type for " + mdb.getName()));
            return false;
        }
        if (destinationType.equals(Queue.class.getName())) {
            config.getQueueConfigurations().add(new JMSQueueConfigurationImpl(noSlashesName, null, true, new String[]{"queue/" + noSlashesName, destinationName}));
        } else if (destinationType.equals(Topic.class.getName())) {
            config.getTopicConfigurations().add(new TopicConfigurationImpl(noSlashesName, new String[]{"topic/" + noSlashesName, destinationName}));
            isTopic = true;
        } else {
            log.warn((Object)("Unknown destination type '" + destinationType + "' for " + mdb.getName()));
            return false;
        }
        HashSet<String> mdbDependencies = mdb.getDepends();
        if (mdbDependencies == null) {
            mdbDependencies = new HashSet<String>();
            mdb.setDepends(mdbDependencies);
        }
        try {
            if (isTopic) {
                mdbDependencies.add(ObjectNameBuilder.DEFAULT.getJMSTopicObjectName(noSlashesName).toString());
            } else {
                mdbDependencies.add(ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(noSlashesName).toString());
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        DeploymentFactory.getInstance().deployJMS(unit, (JMSConfiguration)config);
        return unit;
    }

    protected static String getActivationConfigProperty(ActivationConfigPropertiesMetaData properties, String name) {
        ActivationConfigPropertyMetaData property = (ActivationConfigPropertyMetaData)properties.get(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public Class<?> getOutput() {
        return JMSConfiguration.class;
    }
}

