/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.wireformat.BrowserHasNextMessageRequest;
import org.jboss.jms.wireformat.BrowserHasNextMessageResponse;
import org.jboss.jms.wireformat.BrowserNextMessageBlockRequest;
import org.jboss.jms.wireformat.BrowserNextMessageBlockResponse;
import org.jboss.jms.wireformat.BrowserNextMessageRequest;
import org.jboss.jms.wireformat.BrowserNextMessageResponse;
import org.jboss.jms.wireformat.BrowserResetRequest;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.CloseRequest;
import org.jboss.jms.wireformat.ClosingRequest;
import org.jboss.jms.wireformat.ClosingResponse;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateRequest2;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateResponse;
import org.jboss.jms.wireformat.ConnectionFactoryAddCallbackRequest;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateResponse;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackResponse;
import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyResponse;
import org.jboss.jms.wireformat.ConnectionFactoryRemoveCallbackRequest;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.ConnectionGetClientIDRequest;
import org.jboss.jms.wireformat.ConnectionGetClientIDResponse;
import org.jboss.jms.wireformat.ConnectionGetIDBlockRequest;
import org.jboss.jms.wireformat.ConnectionGetIDBlockResponse;
import org.jboss.jms.wireformat.ConnectionGetPreparedTransactionsRequest;
import org.jboss.jms.wireformat.ConnectionGetPreparedTransactionsResponse;
import org.jboss.jms.wireformat.ConnectionSendTransactionRequest;
import org.jboss.jms.wireformat.ConnectionSetClientIDRequest;
import org.jboss.jms.wireformat.ConnectionStartRequest;
import org.jboss.jms.wireformat.ConnectionStopRequest;
import org.jboss.jms.wireformat.ConsumerChangeRateRequest;
import org.jboss.jms.wireformat.NullResponse;
import org.jboss.jms.wireformat.PolledCallbacksDelivery;
import org.jboss.jms.wireformat.SerializedPacket;
import org.jboss.jms.wireformat.SessionAcknowledgeDeliveriesRequest;
import org.jboss.jms.wireformat.SessionAcknowledgeDeliveryRequest;
import org.jboss.jms.wireformat.SessionAcknowledgeDeliveryResponse;
import org.jboss.jms.wireformat.SessionAddTemporaryDestinationRequest;
import org.jboss.jms.wireformat.SessionCancelDeliveriesRequest;
import org.jboss.jms.wireformat.SessionCancelDeliveryRequest;
import org.jboss.jms.wireformat.SessionCreateBrowserDelegateRequest;
import org.jboss.jms.wireformat.SessionCreateBrowserDelegateResponse;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateRequest;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateResponse;
import org.jboss.jms.wireformat.SessionCreateQueueRequest;
import org.jboss.jms.wireformat.SessionCreateQueueResponse;
import org.jboss.jms.wireformat.SessionCreateTopicRequest;
import org.jboss.jms.wireformat.SessionCreateTopicResponse;
import org.jboss.jms.wireformat.SessionDeleteTemporaryDestinationRequest;
import org.jboss.jms.wireformat.SessionRecoverDeliveriesRequest;
import org.jboss.jms.wireformat.SessionSendRequest;
import org.jboss.jms.wireformat.SessionUnsubscribeRequest;
import org.jboss.messaging.util.Streamable;

public abstract class PacketSupport
implements Streamable {
    private static final int NULL = 0;
    private static final int NOT_NULL = 1;
    protected static Map ONE_WAY_METADATA = new HashMap();
    public static final int SERIALIZED = 1;
    public static final int CLIENT_DELIVERY = 2;
    public static final int CONNECTIONFACTORY_UPDATE = 3;
    public static final int POLLEDCALLBACKS_DELIVERY = 4;
    public static final int REQ_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100;
    public static final int REQ_CONNECTIONFACTORY_GETIDBLOCK = 101;
    public static final int REQ_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 102;
    public static final int REQ_CONNECTIONFACTORY_ADDCALLBACK = 103;
    public static final int REQ_CONNECTIONFACTORY_REMOVECALLBACK = 104;
    public static final int REQ_CONNECTIONFACTORY_GETTOPOLOGY = 105;
    public static final int REQ_CONNECTION_CREATESESSIONDELEGATE = 201;
    public static final int REQ_CONNECTION_GETCLIENTID = 202;
    public static final int REQ_CONNECTION_SETCLIENTID = 203;
    public static final int REQ_CONNECTION_START = 204;
    public static final int REQ_CONNECTION_STOP = 205;
    public static final int REQ_CONNECTION_SENDTRANSACTION = 206;
    public static final int REQ_CONNECTION_GETPREPAREDTRANSACTIONS = 207;
    public static final int REQ_CONNECTION_CREATESESSIONDELEGATE2 = 208;
    public static final int REQ_SESSION_CREATECONSUMERDELEGATE = 301;
    public static final int REQ_SESSION_CREATEBROWSERDELEGATE = 302;
    public static final int REQ_SESSION_CREATEQUEUE = 303;
    public static final int REQ_SESSION_CREATETOPIC = 304;
    public static final int REQ_SESSION_ACKNOWLEDGEDELIVERIES = 305;
    public static final int REQ_SESSION_ACKNOWLEDGEDELIVERY = 306;
    public static final int REQ_SESSION_CANCELDELIVERIES = 307;
    public static final int REQ_SESSION_CANCELDELIVERY = 308;
    public static final int REQ_SESSION_ADDTEMPORARYDESTINATION = 309;
    public static final int REQ_SESSION_DELETETEMPORARYDESTINATION = 310;
    public static final int REQ_SESSION_UNSUBSCRIBE = 311;
    public static final int REQ_SESSION_SEND = 312;
    public static final int REQ_SESSION_RECOVERDELIVERIES = 313;
    public static final int REQ_CONSUMER_CHANGERATE = 401;
    public static final int REQ_BROWSER_NEXTMESSAGE = 501;
    public static final int REQ_BROWSER_HASNEXTMESSAGE = 502;
    public static final int REQ_BROWSER_NEXTMESSAGEBLOCK = 503;
    public static final int REQ_BROWSER_RESET = 504;
    public static final int REQ_CLOSING = 601;
    public static final int REQ_CLOSE = 602;
    public static final int NULL_RESPONSE = 100001;
    public static final int RESP_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100100;
    public static final int RESP_CONNECTIONFACTORY_GETIDBLOCK = 100101;
    public static final int RESP_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 100102;
    public static final int RESP_CONNECTIONFACTORY_GETTOPOLOGY = 100105;
    public static final int RESP_CONNECTION_CREATESESSIONDELEGATE = 100200;
    public static final int RESP_CONNECTION_GETCLIENTID = 100201;
    public static final int RESP_CONNECTION_GETPREPAREDTRANSACTIONS = 100202;
    public static final int RESP_SESSION_CREATECONSUMERDELEGATE = 100300;
    public static final int RESP_SESSION_CREATEBROWSERDELEGATE = 100301;
    public static final int RESP_SESSION_CREATEQUEUE = 100302;
    public static final int RESP_SESSION_CREATETOPIC = 100303;
    public static final int RESP_SESSION_ACKNOWLEDGEDELIVERY = 100304;
    public static final int RESP_BROWSER_NEXTMESSAGE = 100500;
    public static final int RESP_BROWSER_HASNEXTMESSAGE = 100501;
    public static final int RESP_BROWSER_NEXTMESSAGEBLOCK = 100502;
    public static final int RESP_CLOSING = 100601;
    protected int methodId;

    public static PacketSupport createPacket(int id) {
        PacketSupport packet;
        switch (id) {
            case 2: {
                packet = new ClientDelivery();
                break;
            }
            case 312: {
                packet = new SessionSendRequest();
                break;
            }
            case 306: {
                packet = new SessionAcknowledgeDeliveryRequest();
                break;
            }
            case 305: {
                packet = new SessionAcknowledgeDeliveriesRequest();
                break;
            }
            case 206: {
                packet = new ConnectionSendTransactionRequest();
                break;
            }
            case 401: {
                packet = new ConsumerChangeRateRequest();
                break;
            }
            case 100001: {
                packet = new NullResponse();
                break;
            }
            case 100: {
                packet = new ConnectionFactoryCreateConnectionDelegateRequest();
                break;
            }
            case 101: {
                packet = new ConnectionGetIDBlockRequest();
                break;
            }
            case 102: {
                packet = new ConnectionFactoryGetClientAOPStackRequest();
                break;
            }
            case 103: {
                packet = new ConnectionFactoryAddCallbackRequest();
                break;
            }
            case 104: {
                packet = new ConnectionFactoryRemoveCallbackRequest();
                break;
            }
            case 105: {
                packet = new ConnectionFactoryGetTopologyRequest();
                break;
            }
            case 201: {
                packet = new ConnectionCreateSessionDelegateRequest();
                break;
            }
            case 208: {
                packet = new ConnectionCreateSessionDelegateRequest2();
                break;
            }
            case 202: {
                packet = new ConnectionGetClientIDRequest();
                break;
            }
            case 203: {
                packet = new ConnectionSetClientIDRequest();
                break;
            }
            case 204: {
                packet = new ConnectionStartRequest();
                break;
            }
            case 205: {
                packet = new ConnectionStopRequest();
                break;
            }
            case 207: {
                packet = new ConnectionGetPreparedTransactionsRequest();
                break;
            }
            case 301: {
                packet = new SessionCreateConsumerDelegateRequest();
                break;
            }
            case 302: {
                packet = new SessionCreateBrowserDelegateRequest();
                break;
            }
            case 303: {
                packet = new SessionCreateQueueRequest();
                break;
            }
            case 304: {
                packet = new SessionCreateTopicRequest();
                break;
            }
            case 307: {
                packet = new SessionCancelDeliveriesRequest();
                break;
            }
            case 308: {
                packet = new SessionCancelDeliveryRequest();
                break;
            }
            case 309: {
                packet = new SessionAddTemporaryDestinationRequest();
                break;
            }
            case 310: {
                packet = new SessionDeleteTemporaryDestinationRequest();
                break;
            }
            case 311: {
                packet = new SessionUnsubscribeRequest();
                break;
            }
            case 313: {
                packet = new SessionRecoverDeliveriesRequest();
                break;
            }
            case 501: {
                packet = new BrowserNextMessageRequest();
                break;
            }
            case 502: {
                packet = new BrowserHasNextMessageRequest();
                break;
            }
            case 503: {
                packet = new BrowserNextMessageBlockRequest();
                break;
            }
            case 504: {
                packet = new BrowserResetRequest();
                break;
            }
            case 602: {
                packet = new CloseRequest();
                break;
            }
            case 601: {
                packet = new ClosingRequest();
                break;
            }
            case 100100: {
                packet = new ConnectionFactoryCreateConnectionDelegateResponse();
                break;
            }
            case 100101: {
                packet = new ConnectionGetIDBlockResponse();
                break;
            }
            case 100102: {
                packet = new ConnectionFactoryGetClientAOPStackResponse();
                break;
            }
            case 100105: {
                packet = new ConnectionFactoryGetTopologyResponse();
                break;
            }
            case 100200: {
                packet = new ConnectionCreateSessionDelegateResponse();
                break;
            }
            case 100201: {
                packet = new ConnectionGetClientIDResponse();
                break;
            }
            case 100202: {
                packet = new ConnectionGetPreparedTransactionsResponse();
                break;
            }
            case 100300: {
                packet = new SessionCreateConsumerDelegateResponse();
                break;
            }
            case 100301: {
                packet = new SessionCreateBrowserDelegateResponse();
                break;
            }
            case 100302: {
                packet = new SessionCreateQueueResponse();
                break;
            }
            case 100303: {
                packet = new SessionCreateTopicResponse();
                break;
            }
            case 100304: {
                packet = new SessionAcknowledgeDeliveryResponse();
                break;
            }
            case 100500: {
                packet = new BrowserNextMessageResponse();
                break;
            }
            case 100501: {
                packet = new BrowserHasNextMessageResponse();
                break;
            }
            case 100502: {
                packet = new BrowserNextMessageBlockResponse();
                break;
            }
            case 100601: {
                packet = new ClosingResponse();
                break;
            }
            case 1: {
                packet = new SerializedPacket();
                break;
            }
            case 3: {
                packet = new ConnectionFactoryUpdate();
                break;
            }
            case 4: {
                packet = new PolledCallbacksDelivery();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid packet type: " + id);
            }
        }
        return packet;
    }

    public PacketSupport() {
    }

    public PacketSupport(int methodID) {
        this.methodId = methodID;
    }

    public Object getPayload() {
        return this;
    }

    public void write(DataOutputStream os) throws Exception {
        os.writeInt(this.methodId);
    }

    public abstract void read(DataInputStream var1) throws Exception;

    protected void writeNullableString(String s, DataOutputStream os) throws Exception {
        if (s == null) {
            os.writeByte(0);
        } else {
            os.writeByte(1);
            os.writeUTF(s);
        }
    }

    protected String readNullableString(DataInputStream is) throws Exception {
        byte b = is.readByte();
        if (b == 0) {
            return null;
        }
        return is.readUTF();
    }

    static {
        ONE_WAY_METADATA.put("oneway", "true");
    }
}

