/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/*
 * directfb.h
 *
 * External interface of the DirectFB modes seen by the generic, mode
 * independent parts of the DirectFB X server.
 */
/* $XFree86: xc/programs/Xserver/hw/directfb/bundle/directfb.h,v 1.8 2001/12/22 05:28:35 torrey Exp $ */

#ifndef _DIRECTFB_H
#define _DIRECTFB_H

#include <directfb.h>

#include "screenint.h"
#include "scrnintstr.h"

/* DirectFB specific per screen storage structure */
typedef struct {
     IDirectFBDisplayLayer *layer;
     DFBDisplayLayerConfig  layer_config;

     CloseScreenProcPtr     CloseScreen;

     pthread_mutex_t        serverStarted;
     Bool                   serverRunning;
     
     /* Clipboard */
     pthread_t              clipboardThread;
     void                  *pDisplay;
     Window                 clipboardWindow;
     WindowPtr              pClipboardWindow;
     unsigned long          clipboardStamp;
     Atom                   atomLocalProperty;
     Atom                   atomCompoundText;
} DirectFBScreenRec, *DirectFBScreenPtr;

#define DIRECTFB_PRIV(pScreen) \
    ((DirectFBScreenPtr)pScreen->devPrivates[directfbScreenIndex].ptr)

/* Other shared data */
extern int                   directfbScreenIndex;
extern IDirectFB            *dfb;
extern IDirectFBEventBuffer *dfbEvents;
extern IDirectFBInputDevice *dfbKeyboard;


Bool
XDirectFBInitOutput      (int         argc,
                          char      **argv);
Bool
XDirectFBAddScreen       (int         index,
                          ScreenPtr  pScreen,
                          int         argc,
                          char      **argv);

void
XDirectFBCloseOutput     (void);

#endif
