#############################################################
#
# sudo
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SUDO_SOURCE:=sudo.tar.gz
SUDO_SITE:=ftp://ftp.gnu.org/gnu/sudo
SUDO_CAT:=zcat
endif

SUDO_DIR:=$(BUILD_DIR)/sudo
SUDO_BINARY:=sudo
SUDO_TARGET_BINARY:=usr/bin/sudo

ifneq ($(USE_CVS),true)
sudo-fetch:
	 $(WGET) -P $(DL_DIR) $(SUDO_SITE)/$(SUDO_SOURCE)

sudo-source: $(DL_DIR)/$(SUDO_SOURCE)
else
sudo-source:
endif

SUDO_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sudo $(CVS_TAG) $(CVS_PREFIX)sudo

sudo-checkout:
	@$(SUDO_CVSCO)

$(SUDO_DIR)/.unpacked: $(DL_DIR)/$(SUDO_SOURCE)
ifneq ($(USE_CVS),true)
	$(SUDO_CAT) $(DL_DIR)/$(SUDO_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SUDO_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SUDO_DIR)/
	sed -i -e 's,411 -s,411,g' $(SUDO_DIR)/Makefile.in
	touch $(SUDO_DIR)/.unpacked

$(SUDO_DIR)/.configured: $(SUDO_DIR)/.unpacked
	(cd $(SUDO_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--with-pam \
		$(DISABLE_NLS) \
	);
	touch  $(SUDO_DIR)/.configured

$(SUDO_DIR)/$(SUDO_BINARY): $(SUDO_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(SUDO_DIR)

$(TARGET_DIR)/$(SUDO_TARGET_BINARY): $(SUDO_DIR)/$(SUDO_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SUDO_DIR) install
	$(STRIP) $(TARGET_DIR)/$(SUDO_TARGET_BINARY) $(TARGET_DIR)/usr/sbin/visudo
	chmod 4411 $(TARGET_DIR)/$(SUDO_TARGET_BINARY)
	chmod 0440 $(TARGET_DIR)/etc/sudoers
	install -m0644 $(SUDO_DIR)/sample.pam $(TARGET_DIR)/etc/pam.d/sudo
	if [ -e $(TARGET_DIR)/bin/vi ]; then \
		ln -s ../../bin/vi $(TARGET_DIR)/usr/bin/vi 2>&1 ||: ;\
	fi
	install -d $(DOC_DIR)/doc/sudo
	@for f in BUGS LICENSE README ; do \
		install -m0644 $(SUDO_DIR)/$$f $(DOC_DIR)/doc/sudo/$$f ;\
	done

sudo: uclibc pam $(TARGET_DIR)/$(SUDO_TARGET_BINARY)

sudo-clean:
	-rm -f $(TARGET_DIR)/$(SUDO_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/visudo \
		$(TARGET_DIR)/etc/sudoers \
		$(TARGET_DIR)/etc/pam.d/sudo \
		$(TARGET_DIR)/usr/man/man8/sudo.8 \
		$(TARGET_DIR)/usr/man/man8/visudo.8 \
		$(TARGET_DIR)/usr/man/man5/sudoers.5
	-rm -rf $(DOC_DIR)/doc/sudo
	-$(MAKE) -C $(SUDO_DIR) clean

sudo-dirclean:
	rm -rf $(SUDO_DIR)
endif

