#############################################################
#
# procmail
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PROCMAIL_SOURCE:=procmail.tar.gz
PROCMAIL_SITE:=http://www.procmail.org
PROCMAIL_CAT:=zcat
endif

PROCMAIL_DIR:=$(BUILD_DIR)/procmail
PROCMAIL_BINARY:=new/procmail
PROCMAIL_TARGET_BINARY:=usr/bin/procmail

ifneq ($(USE_CVS),true)
procmail-fetch:
	 $(WGET) -P $(DL_DIR) $(PROCMAIL_SITE)/$(PROCMAIL_SOURCE)

procmail-source: $(DL_DIR)/$(PROCMAIL_SOURCE)
else
procmail-source:
endif

PROCMAIL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d procmail $(CVS_TAG) $(CVS_PREFIX)procmail

procmail-checkout:
	@$(PROCMAIL_CVSCO)

$(PROCMAIL_DIR)/.unpacked: $(DL_DIR)/$(PROCMAIL_SOURCE)
ifneq ($(USE_CVS),true)
	$(PROCMAIL_CAT) $(DL_DIR)/$(PROCMAIL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PROCMAIL_CVSCO)
endif
	cat $(SOURCE_DIR)/procmail.patch | patch -p0 -d $(PROCMAIL_DIR)
	touch $(PROCMAIL_DIR)/.unpacked

$(PROCMAIL_DIR)/$(PROCMAIL_BINARY): $(PROCMAIL_DIR)/.unpacked
	$(MAKE) \
		$(TARGET_CONFIGURE_OPTS) \
		STRIP=$(TARGET_CROSS)strip \
		CC_FOR_BUILD=$(HOSTCC) \
		-C $(PROCMAIL_DIR) makefiles
	cp $(SOURCE_DIR)/procmail-autoconf-$(ARCH).h $(PROCMAIL_DIR)/autoconf.h
	$(MAKE) \
		$(TARGET_CONFIGURE_OPTS) \
		STRIP=$(TARGET_CROSS)strip \
		CC_FOR_BUILD=$(HOSTCC) \
		-C $(PROCMAIL_DIR)

$(TARGET_DIR)/$(PROCMAIL_TARGET_BINARY): $(PROCMAIL_DIR)/$(PROCMAIL_BINARY)
	$(MAKE) \
		BASENAME=$(TARGET_DIR)/usr \
		-C $(PROCMAIL_DIR) \
		install
	install -d $(DOC_DIR)/doc/procmail
	@for f in Artistic COPYING FEATURES KNOWN_BUGS README ; do \
		install -m0644 $(PROCMAIL_DIR)/$$f \
			$(DOC_DIR)/doc/procmail/$$f ;\
	done
	cp -r $(PROCMAIL_DIR)/examples $(DOC_DIR)/doc/procmail/examples
	find $(DOC_DIR)/doc/procmail -type d -name CVS | xargs rm -rf

procmail: uclibc $(TARGET_DIR)/$(PROCMAIL_TARGET_BINARY)

procmail-clean:
	-rm -f $(TARGET_DIR)/$(PROCMAIL_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/formail \
		$(TARGET_DIR)/usr/bin/lockfile \
		$(TARGET_DIR)/usr/bin/mailstat \
		$(TARGET_DIR)/usr/man/man1/formail.1 \
		$(TARGET_DIR)/usr/man/man1/procmail.1 \
		$(TARGET_DIR)/usr/man/man1/lockfile.1 \
		$(TARGET_DIR)/usr/man/man5/procmailrc.5 \
		$(TARGET_DIR)/usr/man/man5/procmailsc.5 \
		$(TARGET_DIR)/usr/man/man5/procmailex.5
	-rm -rf $(DOC_DIR)/doc/procmail
	-$(MAKE) -C $(PROCMAIL_DIR) clean

procmail-dirclean:
	rm -rf $(PROCMAIL_DIR)
endif

