#############################################################
#
# libungif
#
#############################################################
ifneq ($(USE_CVS),true)
LIBUNGIF_SOURCE:=libungif.tar.gz
LIBUNGIF_SITE:=ftp://ftp.gnu.org/gnu/libungif
LIBUNGIF_CAT:=zcat
endif

LIBUNGIF_DIR:=$(BUILD_DIR)/libungif
LIBUNGIF_BINARY:=libungif.a
LIBUNGIF_TARGET_BINARY:=usr/lib/libungif.a

ifneq ($(USE_CVS),true)
libungif-fetch:
	 $(WGET) -P $(DL_DIR) $(LIBUNGIF_SITE)/$(LIBUNGIF_SOURCE)

libungif-source: $(DL_DIR)/$(LIBUNGIF_SOURCE)
else
libungif-source:
endif

LIBUNGIF_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d libungif $(CVS_TAG) $(CVS_PREFIX)libungif

libungif-checkout:
	@$(LIBUNGIF_CVSCO)

$(LIBUNGIF_DIR)/.unpacked: $(DL_DIR)/$(LIBUNGIF_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBUNGIF_CAT) $(DL_DIR)/$(LIBUNGIF_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBUNGIF_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBUNGIF_DIR)/
	touch $(LIBUNGIF_DIR)/.unpacked

$(LIBUNGIF_DIR)/.configured: $(LIBUNGIF_DIR)/.unpacked
	(cd $(LIBUNGIF_DIR); \
		rm -rf config.cache; \
		autoreconf --install --force; \
		ac_cv_linux_vers=2 \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(LIBUNGIF_DIR)/.configured

$(LIBUNGIF_DIR)/$(LIBUNGIF_BINARY): $(LIBUNGIF_DIR)/.configured
	$(MAKE) ZLIBLIB="-I$(STAGING_DIR)/usr/lib" ZLIBINC="-I$(STAGING_DIR)/usr/include" CC=$(TARGET_CC) -C $(LIBUNGIF_DIR)

$(STAGING_DIR)/$(LIBUNGIF_TARGET_BINARY): $(LIBUNGIF_DIR)/$(LIBUNGIF_BINARY)
	$(MAKE) prefix=$(STAGING_DIR) DESTDIR=$(STAGING_DIR) -C $(LIBUNGIF_DIR) install
	install -d $(DOC_DIR)/doc/libungif
	@for f in LICENSE README ; do \
		install -m0644 $(LIBUNGIF_DIR)/$$f $(DOC_DIR)/doc/libungif/$$f ;\
	done
	rm -f $(STAGING_DIR)/usr/lib/libungif.la

$(TARGET_DIR)/$(LIBUNGIF_TARGET_BINARY): $(STAGING_DIR)/$(LIBUNGIF_TARGET_BINARY)
	$(MAKE) prefix=$(TARGET_DIR) DESTDIR=$(TARGET_DIR) -C $(LIBUNGIF_DIR) install
	install -d $(DOC_DIR)/doc/libungif
	@for f in LICENSE README ; do \
		install -m0644 $(LIBUNGIF_DIR)/$$f $(DOC_DIR)/doc/libungif/$$f ;\
	done
	rm -rf $(TARGET_DIR)/include

libungif: uclibc $(TARGET_DIR)/$(LIBUNGIF_TARGET_BINARY)

libungif-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBUNGIF_DIR) uninstall
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(LIBUNGIF_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/libungif
	-$(MAKE) -C $(LIBUNGIF_DIR) clean

libungif-dirclean:
	rm -rf $(LIBUNGIF_DIR)

