/* elf.h: FR-V ELF definitions
 *
 * Copyright (C) 2003 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 * - Derived from include/asm-m68knommu/elf.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef __ASM_ELF_H
#define __ASM_ELF_H

/*
 * ELF register definitions..
 */

#include <linux/config.h>
#include <asm/ptrace.h>
#include <asm/user.h>

typedef unsigned long elf_greg_t;

#define ELF_NGREG (sizeof(struct pt_regs) / sizeof(elf_greg_t))
typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef struct fpmedia_struct elf_fpregset_t;

/*
 * This is used to ensure we don't load something for the wrong architecture.
 */

struct elf32_hdr;
extern int elf_check_arch(const struct elf32_hdr *hdr);
#define elf_check_fdpic(x) ((x)->e_flags & EF_FRV_FDPIC && !((x)->e_flags & EF_FRV_NON_PIC_RELOCS))
#define elf_check_const_displacement(x) ((x)->e_flags & EF_FRV_PIC)

/*
 * These are used to set parameters in the core dumps.
 */
#define ELF_CLASS	ELFCLASS32
#define ELF_DATA	ELFDATA2MSB
#define ELF_ARCH	EM_FRV

#define ELF_PLAT_INIT(_r)	do { } while(0)

#define ELF_FDPIC_PLAT_INIT(_regs, _exec_map_addr, _interp_map_addr, _dynamic_addr)	\
do {											\
	__kernel_frame0_ptr->gr16	= _exec_map_addr;				\
	__kernel_frame0_ptr->gr17	= _interp_map_addr;				\
	__kernel_frame0_ptr->gr18	= _dynamic_addr;				\
	ELF_PLAT_INIT(_regs);								\
} while(0)

#define USE_ELF_CORE_DUMP
#define ELF_EXEC_PAGESIZE	16384

/* This is the location that an ET_DYN program is loaded if exec'ed.  Typical
   use of this is to invoke "./ld.so someprog" to test out a new version of
   the loader.  We need to make sure that it is out of the way of the program
   that it will "exec", and that there is sufficient room for the brk.  */

#define ELF_ET_DYN_BASE         0x08000000UL

#define ELF_CORE_COPY_REGS(pr_reg, regs)				\
	/* Bleech. */							\
	memcpy(&pr_reg[0], &regs->gr[1], NGRREGS * sizeof(uint32_t));	\
	pr_reg[14] = regs->d0;						\
	pr_reg[15] = rdusp();						\
	pr_reg[16] = 0 /* regs->orig_d0; */				\
	pr_reg[17] = regs->sr;						\
	pr_reg[18] = regs->pc;						\
	/* pr_reg[19] = (regs->format << 12) | regs->vector; */		\
	{								\
	  struct switch_stack *sw = ((struct switch_stack *)regs) - 1;	\
	  pr_reg[5] = sw->d6;						\
	  pr_reg[6] = sw->d7;						\
	  pr_reg[9] = sw->a2;						\
	  pr_reg[10] = sw->a3;						\
	  pr_reg[11] = sw->a4;						\
	  pr_reg[12] = sw->a5;						\
	  pr_reg[13] = sw->a6;						\
	}

/* This yields a mask that user programs can use to figure out what
   instruction set this cpu supports.  */

#define ELF_HWCAP	(0)

/* This yields a string that ld.so will use to load implementation
   specific libraries for optimization.  This is more specific in
   intent than poking at uname or /proc/cpuinfo.  */

#define ELF_PLATFORM  (NULL)


#endif
