/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.spi.graph.Name;
import org.jboss.dna.spi.graph.NamespaceRegistry;
import org.jboss.dna.spi.graph.Path;
import org.jboss.dna.spi.graph.Property;
import org.jboss.dna.spi.graph.ValueFactories;
import org.jboss.dna.spi.sequencers.SequencerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SequencerNodeContext
implements SequencerContext {
    private final ValueFactories factories;
    private final Path path;
    private final Set<Property> props;

    SequencerNodeContext(Node input, ExecutionContext context) throws RepositoryException {
        assert (input != null);
        assert (context != null);
        this.factories = context.getValueFactories();
        this.path = (Path)this.factories.getPathFactory().create(input.getPath());
        HashSet<Property> props = new HashSet<Property>();
        PropertyIterator iter = input.getProperties();
        while (iter.hasNext()) {
            Property prop;
            javax.jcr.Property jcrProp = iter.nextProperty();
            if (jcrProp.getDefinition().isMultiple()) {
                Value[] jcrVals = jcrProp.getValues();
                Object[] vals = new Object[jcrVals.length];
                int ndx = 0;
                for (Value jcrVal : jcrVals) {
                    vals[ndx++] = this.convert(this.factories, jcrProp.getName(), jcrVal);
                }
                prop = context.getPropertyFactory().create((Name)this.factories.getNameFactory().create(jcrProp.getName()), vals);
            } else {
                Value jcrVal = jcrProp.getValue();
                Object val = this.convert(this.factories, jcrProp.getName(), jcrVal);
                prop = context.getPropertyFactory().create((Name)this.factories.getNameFactory().create(jcrProp.getName()), new Object[]{val});
            }
            props.add(prop);
        }
        this.props = Collections.unmodifiableSet(props);
    }

    private Object convert(ValueFactories factories, String name, Value jcrValue) throws RepositoryException {
        switch (jcrValue.getType()) {
            case 2: {
                return factories.getBinaryFactory().create((Object)jcrValue.getStream());
            }
            case 6: {
                return factories.getBooleanFactory().create(jcrValue.getBoolean());
            }
            case 5: {
                return factories.getDateFactory().create(jcrValue.getDate());
            }
            case 4: {
                return factories.getDoubleFactory().create(jcrValue.getDouble());
            }
            case 3: {
                return factories.getLongFactory().create(jcrValue.getLong());
            }
            case 7: {
                return factories.getNameFactory().create(jcrValue.getString());
            }
            case 8: {
                return factories.getPathFactory().create(jcrValue.getString());
            }
            case 9: {
                return factories.getReferenceFactory().create(jcrValue.getString());
            }
            case 1: {
                return factories.getStringFactory().create(jcrValue.getString());
            }
        }
        throw new RepositoryException(RepositoryI18n.unknownPropertyValueType.text(new Object[]{name, jcrValue.getType()}));
    }

    public ValueFactories getFactories() {
        return this.factories;
    }

    public Path getInputPath() {
        return this.path;
    }

    public Set<Property> getInputProperties() {
        return this.props;
    }

    public Property getInputProperty(Name name) {
        ArgCheck.isNotNull((Object)name, (String)"name");
        for (Property prop : this.props) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.factories.getNameFactory().getNamespaceRegistry();
    }
}

