/*
 * Copyright 2011 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.drools.guvnor.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;

public class AssetTemplateCreator {
    
    private static final LoggingHelper  log                         = LoggingHelper.getLogger( AssetTemplateCreator.class );

    /**
     * For some format types, we add some sugar by adding a new template.
     */
    protected void applyPreBuiltTemplates(String ruleName,
                                        String format,
                                        AssetItem asset) {
        if ( format.equals( AssetFormats.DSL_TEMPLATE_RULE ) ) {
            asset.updateContent( "when\n\nthen\n" );
        } else if ( format.equals( AssetFormats.FUNCTION ) ) {
            asset.updateContent( "function <returnType> " + ruleName + "(<args here>) {\n\n\n}" );
        } else if ( format.equals( AssetFormats.DSL ) ) {
            asset.updateContent( "[when]Condition sentence template {var}=" + "rule language mapping {var}\n" + "[then]Action sentence template=rule language mapping" );
        } else if ( format.equals( AssetFormats.DECISION_SPREADSHEET_XLS ) ) {
            asset.updateBinaryContentAttachment( this.getClass().getResourceAsStream( "/SampleDecisionTable.xls" ) );
            asset.updateBinaryContentAttachmentFileName( "SampleDecisionTable.xls" );
        } else if ( format.equals( AssetFormats.DRL ) ) {
            asset.updateContent( "when\n\t#conditions\nthen\n\t#actions" );
        } else if ( format.equals( AssetFormats.ENUMERATION ) ) {

        } else if ( format.equals( AssetFormats.SPRING_CONTEXT ) ) {
            try {
                ByteArrayOutputStream outContent = new ByteArrayOutputStream();
                BufferedInputStream inContent = new BufferedInputStream( this.getClass().getClassLoader().getResourceAsStream( "spring-context-sample.xml" ) );
                IOUtils.copy( inContent,
                              outContent );

                asset.updateContent( outContent.toString() );
            } catch ( IOException ex ) {
                log.error( "Error reading spring-context-sample.xml",
                           ex );
                throw new IllegalArgumentException( "Error reading spring-context-sample.xml" );
            }
        } else if ( format.equals( AssetFormats.WORKITEM_DEFINITION ) ) {
            try {
                ByteArrayOutputStream outContent = new ByteArrayOutputStream();
                BufferedInputStream inContent = new BufferedInputStream( this.getClass().getClassLoader().getResourceAsStream( "workitem-definition-sample.xml" ) );
                IOUtils.copy( inContent,
                              outContent );

                asset.updateContent( outContent.toString() );
            } catch ( IOException ex ) {
                log.error( "Error reading workitem-definition-sample.xml",
                           ex );
                throw new IllegalArgumentException( "Error reading workitem-definition-sample.xml" );
            }
        }
    }
}
