/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static ClassLoader getTCL() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static void setTCL(final ClassLoader tcl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(tcl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(tcl);
                    return null;
                }
            });
        }
    }
}

