/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationStatistics
implements Serializable {
    private static final long serialVersionUID = -8031193044335393420L;
    private Map<Method, TimeStatistic> methodStats;
    public long concurrentCalls = 0L;
    public long maxConcurrentCalls = 0L;
    public long lastResetTime = System.currentTimeMillis();

    public InvocationStatistics() {
        this.methodStats = new ConcurrentReaderHashMap();
    }

    public void updateStats(Method m, long elapsed) {
        TimeStatistic stat = this.methodStats.get(m);
        if (stat == null) {
            stat = new TimeStatistic();
            this.methodStats.put(m, stat);
        }
        ++stat.count;
        stat.totalTime += elapsed;
        if (stat.minTime > elapsed) {
            stat.minTime = elapsed;
        }
        if (stat.maxTime < elapsed) {
            stat.maxTime = elapsed;
        }
    }

    public synchronized void callIn() {
        ++this.concurrentCalls;
        if (this.concurrentCalls > this.maxConcurrentCalls) {
            this.maxConcurrentCalls = this.concurrentCalls;
        }
    }

    public synchronized void callOut() {
        --this.concurrentCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Map<Method, TimeStatistic> map = this.methodStats;
        synchronized (map) {
            this.methodStats.clear();
        }
        this.maxConcurrentCalls = 0L;
        this.lastResetTime = System.currentTimeMillis();
    }

    public Map getStats() {
        return this.methodStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("' >\n");
        for (Map.Entry<Method, TimeStatistic> entry : this.methodStats.entrySet()) {
            TimeStatistic stat = entry.getValue();
            if (stat == null) continue;
            tmp.append("<method name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' />\n");
        }
        tmp.append("</InvocationStatistics>");
        return tmp.toString();
    }

    public Map<String, Map<String, Long>> toDetypedMap() {
        HashMap<String, Map<String, Long>> detyped = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<Method, TimeStatistic> entry : this.methodStats.entrySet()) {
            TimeStatistic stats = entry.getValue();
            HashMap<String, Long> detypedStats = new HashMap<String, Long>(this.methodStats.size());
            detypedStats.put("count", stats.count);
            detypedStats.put("minTime", stats.minTime);
            detypedStats.put("maxTime", stats.maxTime);
            detypedStats.put("totalTime", stats.totalTime);
            detyped.put(entry.getKey().getName(), detypedStats);
        }
        HashMap<String, Long> global = new HashMap<String, Long>();
        global.put("concurrentCalls", this.concurrentCalls);
        global.put("maxConcurrentCalls", this.maxConcurrentCalls);
        global.put("lastResetTime", this.lastResetTime);
        detyped.put("#Global", global);
        return detyped;
    }

    public class TimeStatistic
    implements Serializable {
        private static final long serialVersionUID = -8689933338506854386L;
        public volatile long count;
        public volatile long minTime = Long.MAX_VALUE;
        public volatile long maxTime;
        public volatile long totalTime;

        public void reset() {
            this.count = 0L;
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
            this.totalTime = 0L;
        }
    }
}

