/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers.pojo;

import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQJMSDeployment;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQConnectionFactoryDeployment
extends HornetQJMSDeployment<ConnectionFactoryConfiguration> {
    private static final Logger log = Logger.getLogger(HornetQConnectionFactoryDeployment.class);

    @Override
    public void start() throws Exception {
        log.debug((Object)("Deploying ConnectionFactory " + ((ConnectionFactoryConfiguration)this.config).getName()));
        try {
            this.jmsServer.createConnectionFactory(false, (ConnectionFactoryConfiguration)this.config, ((ConnectionFactoryConfiguration)this.config).getBindings());
            this.registerControlReference(this.builder.getConnectionFactoryObjectName(((ConnectionFactoryConfiguration)this.config).getName()));
        }
        catch (Exception e) {
            log.warn((Object)("Error deploying ConnectionFactory: " + ((ConnectionFactoryConfiguration)this.config).getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        log.debug((Object)("Destroying ConnectionFactory " + ((ConnectionFactoryConfiguration)this.config).getName()));
        try {
            this.unregisterControlReference(this.builder.getConnectionFactoryObjectName(((ConnectionFactoryConfiguration)this.config).getName()));
            this.jmsServer.destroyConnectionFactory(((ConnectionFactoryConfiguration)this.config).getName());
        }
        catch (Exception e) {
            log.warn((Object)("Error destroying ConnectionFactory: " + ((ConnectionFactoryConfiguration)this.config).getName()), (Throwable)e);
        }
    }
}

