/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class HornetQExceptionMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(HornetQExceptionMessage.class);
    private HornetQException exception;

    public HornetQExceptionMessage(HornetQException exception) {
        super((byte)20);
        this.exception = exception;
    }

    public HornetQExceptionMessage() {
        super((byte)20);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public HornetQException getException() {
        return this.exception;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.exception.getCode());
        buffer.writeNullableString(this.exception.getMessage());
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        int code = buffer.readInt();
        String msg = buffer.readNullableString();
        this.exception = new HornetQException(code, msg);
    }

    @Override
    public String toString() {
        return this.getParentString() + ", exception= " + this.exception + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof HornetQExceptionMessage)) {
            return false;
        }
        HornetQExceptionMessage r = (HornetQExceptionMessage)other;
        return super.equals(other) && this.exception.equals(r.exception);
    }
}

