/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.util.Date;
import org.omg.CosTransactions.Status;

public class AssumedCompleteServerTransaction
extends RecoveredServerTransaction {
    private Date _lastActiveTime;
    private static String ourTypeName = "/StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteServerTransaction";

    public AssumedCompleteServerTransaction(Uid actionUid) {
        super(actionUid, ourTypeName);
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteServerTransaction_1", new Object[]{this.get_uid()});
        }
    }

    @Override
    public Status getOriginalStatus() {
        return Status.StatusNoTransaction;
    }

    @Override
    public String type() {
        return AssumedCompleteServerTransaction.typeName();
    }

    public static String typeName() {
        return ourTypeName;
    }

    public String toString() {
        return "AssumedCompleteServerTransaction < " + this.get_uid() + " >";
    }

    @Override
    public boolean assumeComplete() {
        return false;
    }

    @Override
    public Date getLastActiveTime() {
        return this._lastActiveTime;
    }

    public boolean restore_state(InputObjectState objectState, int ot) {
        boolean result = super.restore_state(objectState, ot);
        if (result) {
            try {
                long oldtime = objectState.unpackLong();
                this._lastActiveTime = new Date(oldtime);
            }
            catch (IOException ex) {
                this._lastActiveTime = new Date();
            }
        }
        return result;
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (result) {
            this._lastActiveTime = new Date();
            try {
                objectState.packLong(this._lastActiveTime.getTime());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

