require 'test_helper'

class UserSessionTest < ActiveSupport::TestCase


  def request
    ActionDispatch::Request.new({})
  end

  test 'generates a key' do
    us = UserSession.new(user_id: 42)
    assert us.valid?

    assert_not_nil us.key
  end

  test 'a revoked key is not active' do
    us = UserSession.create!(user_id: 42)

    us.revoke!

    refute UserSession.active.include?(us)
  end

  test 'access without user does not persist the session' do

    us = UserSession.null

    assert_difference 'UserSession.count', 0 do
      us.access(request)
    end
  end

  test 'revoke does not create session' do

    us = UserSession.null

    assert_difference 'UserSession.count', 0 do
      us.revoke!
    end
  end

  test 'different scenarios for user agent' do
    session = UserSession.new

    session.user_agent = 'foobar'
    assert_equal 'foobar', session.user_agent

    session.user_agent = 'a' * 260
    assert_equal 'a' * 255, session.user_agent
    refute session.valid?

    session.user_agent = nil
    assert_equal nil, session.user_agent
    refute session.valid?

    session.user_agent = 'a' * 253
    assert_equal 'a' * 253, session.user_agent
    session.save

    session.user_agent = 'a'*1000
    assert_equal 'a' * 255, session.user_agent
  end
end
